/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.el;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import javax.servlet.jsp.el.FunctionMapper;

public final class FunctionMapperImpl
implements FunctionMapper {
    private HashMap fnmap = null;
    private Method theMethod = null;

    private FunctionMapperImpl() {
    }

    public static FunctionMapperImpl getInstance() {
        FunctionMapperImpl funcMapper = System.getSecurityManager() != null ? (FunctionMapperImpl)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new FunctionMapperImpl();
            }
        }) : new FunctionMapperImpl();
        funcMapper.fnmap = new HashMap();
        return funcMapper;
    }

    public void mapFunction(String fnQName, final Class c, final String methodName, final Class[] args) {
        Method method;
        if (System.getSecurityManager() != null) {
            try {
                method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return c.getDeclaredMethod(methodName, args);
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                throw new RuntimeException("Invalid function mapping - no such method: " + ex.getException().getMessage());
            }
        }
        try {
            method = c.getDeclaredMethod(methodName, args);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Invalid function mapping - no such method: " + e.getMessage());
        }
        this.fnmap.put(fnQName, method);
    }

    public static FunctionMapperImpl getMapForFunction(String fnQName, final Class c, final String methodName, final Class[] args) {
        Method method;
        FunctionMapperImpl funcMapper;
        if (System.getSecurityManager() != null) {
            funcMapper = (FunctionMapperImpl)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new FunctionMapperImpl();
                }
            });
            try {
                method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return c.getDeclaredMethod(methodName, args);
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                throw new RuntimeException("Invalid function mapping - no such method: " + ex.getException().getMessage());
            }
        }
        funcMapper = new FunctionMapperImpl();
        try {
            method = c.getDeclaredMethod(methodName, args);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Invalid function mapping - no such method: " + e.getMessage());
        }
        funcMapper.theMethod = method;
        return funcMapper;
    }

    public Method resolveFunction(String prefix, String localName) {
        if (this.fnmap != null) {
            return (Method)this.fnmap.get(prefix + ":" + localName);
        }
        return this.theMethod;
    }
}

