/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp2;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.ArchiveHelper;
import jeus.ejb.util.EJBRootClassLoader;
import jeus.server.RootClassLoader;
import jeus.server.enginecontainer.EngineContainer;
import jeus.server.manager.JeusVersion;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.service.archive.ArchiveClassLoader;
import jeus.service.library.ClassPathEntry;
import jeus.service.library.LibraryManager;
import jeus.service.library.LibraryNotFoundException;
import jeus.service.library.LibraryRef;
import jeus.servlet.jsp.compiler.JavaCompiler;
import jeus.servlet.jsp.compiler.JspCompileException;
import jeus.servlet.jsp.compiler.batch.CompileFailedException;
import jeus.servlet.jsp2.Jsp2EngineException;
import jeus.servlet.jsp2.JspCompilationContext;
import jeus.servlet.jsp2.Options;
import jeus.servlet.jsp2.compiler.Compiler;
import jeus.servlet.jsp2.compiler.JspConfig;
import jeus.servlet.jsp2.compiler.JspRuntimeContext;
import jeus.servlet.jsp2.compiler.Localizer;
import jeus.servlet.jsp2.compiler.TagPluginManager;
import jeus.servlet.jsp2.compiler.TldLocationsCache;
import jeus.servlet.jsp2.servlet.JspCServletContext;
import jeus.tool.util.JarManager;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusBootstrapProperties;
import jeus.util.JeusException;
import jeus.util.JeusRootClassLoader;
import jeus.util.message.JeusMessage_WebContainer5_4;
import jeus.xml.binding.jeusDD.ContextType;
import jeus.xml.binding.jeusDD.LibraryRefType;
import jeus.xml.binding.util.JAXBContextFactory;

public class JspC
implements Options {
    public static final String DEFAULT_IE_CLASS_ID = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    private static final String SWITCH_VERBOSE = "-v";
    private static final String SWITCH_HELP = "-help";
    private static final String SWITCH_QUIET = "-q";
    private static final String SWITCH_OUTPUT_DIR = "-d";
    private static final String SWITCH_IE_CLASS_ID = "-ieplugin";
    private static final String SWITCH_PACKAGE_NAME = "-p";
    private static final String SWITCH_CLASS_NAME = "-c";
    private static final String SWITCH_FULL_STOP = "--";
    private static final String SWITCH_COMPILE = "-compile";
    private static final String SWITCH_URI_BASE = "-uribase";
    private static final String SWITCH_URI_ROOT = "-uriroot";
    private static final String SWITCH_FILE_WEBAPP = "-webapp";
    private static final String SWITCH_WEBAPP_INC = "-webinc";
    private static final String SWITCH_WEBAPP_XML = "-webxml";
    private static final String SWITCH_MAPPED = "-mapped";
    private static final String SWITCH_XPOWERED_BY = "-xpoweredBy";
    private static final String SWITCH_TRIM_SPACES = "-trimSpaces";
    private static final String SWITCH_CLASSPATH = "-classpath";
    private static final String SWITCH_DIE = "-die";
    private static final String SWITCH_POOLING = "-poolingEnabled";
    private static final String SWITCH_ENCODING = "-javaEncoding";
    private static final String SHOW_SUCCESS = "-s";
    private static final String LIST_ERRORS = "-l";
    private static final int NO_WEBXML = 0;
    private static final int INC_WEBXML = 10;
    private static final int ALL_WEBXML = 20;
    private static final int DEFAULT_DIE_LEVEL = 1;
    private static final int NO_DIE_LEVEL = 0;
    private static final String[] insertBefore = new String[]{"</web-app>", "<servlet-mapping>", "<session-config>", "<mime-mapping>", "<welcome-file-list>", "<error-page>", "<taglib>", "<resource-env-ref>", "<resource-ref>", "<security-constraint>", "<login-config>", "<security-role>", "<env-entry>", "<ejb-ref>", "<ejb-local-ref>"};
    private static int die;
    private String classPath = null;
    private String sysClassPath = null;
    private ClassLoader loader = null;
    private ClassLoader prevLoader = null;
    private boolean trimSpaces = false;
    private boolean genStringAsCharArray = false;
    private boolean xpoweredBy;
    private boolean mappedFile = true;
    private boolean poolingEnabled = true;
    private File scratchDir;
    private File outputDir;
    private String ieClassId = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    private String targetPackage;
    private String targetClassName;
    private String uriBase;
    private String uriRoot;
    private int dieLevel;
    private boolean helpNeeded = false;
    private boolean compile = true;
    private String compiler = null;
    private String compilerTargetVM = "1.5";
    private String compilerSourceVM = "1.5";
    private boolean classDebugInfo = true;
    private Vector extensions;
    private Vector pages = new Vector();
    private boolean errorOnUseBeanInvalidClassAttribute = true;
    private boolean isKeepGenerated = false;
    private boolean batchCompile = false;
    private boolean eachCompile = true;
    private boolean smapSupressed = true;
    private String javaEncoding = "UTF-8";
    private String webxmlFile;
    private int webxmlLevel;
    private boolean addWebXmlMappings = false;
    private Writer mapout;
    private CharArrayWriter servletout;
    private CharArrayWriter mappingout;
    private JspCServletContext context;
    private JspRuntimeContext rctxt;
    private TldLocationsCache tldLocationsCache = null;
    private JspConfig jspConfig = null;
    private TagPluginManager tagPluginManager = null;
    private boolean verbose = true;
    private boolean listErrors = true;
    private boolean showSuccess = true;
    private int argPos;
    private boolean fullstop = false;
    private String[] args;
    public static final String SWITCH_MODE = "-mode";
    public static final String SWITCH_CTXROOT = "-ctxroot";
    private static final String SWITCH_SRCDIR = "-srcdir";
    private static final String SWITCH_WORKDIR = "-workdir";
    private static final String SWITCH_OUTDIR = "-outdir";
    private static final String SWITCH_OUTWAR = "-outwar";
    private static final String SWITCH_MAPDIR = "-mapdir";
    private static final String SWITCH_QUIT = "-q";
    private static final String SWITCH_COMPILE_OPTION = "-co";
    private static final String SWITCH_HELP_SHORT = "-h";
    private static final String SWITCH_VERSION = "-v";
    public static final String SWITCH_NO_COMPILE = "-nocompile";
    public static final String SWITCH_KEEP = "-keep";
    public static final String SWITCH_BATCH_COMPILE = "-batchcompile";
    public static final String SWITCH_SMAP = "-smap";
    public static final String SWITCH_EXIT_ON_FAIL = "-exitOnFail";
    public static final String MODE_NORMAL = "normal";
    private static final String MODE_WAR = "war";
    public static final String MODE_MAP = "map";
    private static final String UNJAR_PATH;
    private static final String DEFAULT_OUTWAR;
    private static final String MAP_FILE_NAME = "jeus_jspmap.xml";
    private String warfilename;
    private String outwar;
    private String mode;
    private String srcDir;
    private String compileopt;
    private boolean quit = false;
    private StringBuffer listBuffer = null;
    private boolean isTldValidationEnabled;
    private boolean failed = false;
    private boolean exitOnFail = true;

    public static void main(String[] arg) throws CompileFailedException, JeusException {
        JeusRootClassLoader.loader = JspC.class.getClassLoader();
        if (JeusRootClassLoader.loader instanceof RootClassLoader) {
            JeusRootClassLoader.inServer = true;
            JeusRootClassLoader.inModuleCompiler = true;
            EJBRootClassLoader ejbLoader = (EJBRootClassLoader)((RootClassLoader)JeusRootClassLoader.loader).getEJBRootClassLoader();
            if (ejbLoader == null) {
                ejbLoader = new EJBRootClassLoader(new URL[0], JeusRootClassLoader.loader, "JspBatchContainer");
                ((RootClassLoader)JeusRootClassLoader.loader).registerEJBRootClassLoader(ejbLoader);
                EngineContainer.rootClassLoader = ejbLoader;
            }
        }
        if (arg.length == 0) {
            JspC.printUsage();
        } else {
            JspC jspc = new JspC();
            try {
                jspc.setArgs2(arg);
                if (jspc.helpNeeded) {
                    JspC.printUsage();
                    System.exit(1);
                } else {
                    jspc.execute();
                    if (jspc.failed) {
                        if (jspc.exitOnFail) {
                            System.exit(1);
                        }
                        throw new CompileFailedException("failed to compile JSPs");
                    }
                }
            }
            catch (Jsp2EngineException je) {
                je.printStackTrace();
                if (jspc.exitOnFail) {
                    System.exit(1);
                }
                throw new CompileFailedException("failed to compile JSPs");
            }
        }
    }

    public void setArgs(String[] arg) throws Jsp2EngineException {
        String file;
        String tok;
        this.args = arg;
        die = this.dieLevel = 0;
        while ((tok = this.nextArg()) != null) {
            if (tok.equals("-v")) {
                this.verbose = true;
                this.showSuccess = true;
                this.listErrors = true;
                continue;
            }
            if (tok.equals(SWITCH_OUTPUT_DIR)) {
                tok = this.nextArg();
                this.setScratchDir(tok);
                continue;
            }
            if (tok.equals(SWITCH_PACKAGE_NAME)) {
                this.targetPackage = this.nextArg();
                continue;
            }
            if (tok.equals(SWITCH_COMPILE)) {
                this.compile = true;
                continue;
            }
            if (tok.equals(SWITCH_CLASS_NAME)) {
                this.targetClassName = this.nextArg();
                continue;
            }
            if (tok.equals(SWITCH_URI_BASE)) {
                this.uriBase = this.nextArg();
                continue;
            }
            if (tok.equals(SWITCH_URI_ROOT)) {
                this.setUriroot(this.nextArg());
                continue;
            }
            if (tok.equals(SWITCH_FILE_WEBAPP)) {
                this.setUriroot(this.nextArg());
                continue;
            }
            if (tok.equals(SHOW_SUCCESS)) {
                this.showSuccess = true;
                continue;
            }
            if (tok.equals(LIST_ERRORS)) {
                this.listErrors = true;
                continue;
            }
            if (tok.equals(SWITCH_WEBAPP_INC)) {
                this.webxmlFile = this.nextArg();
                if (this.webxmlFile == null) continue;
                this.webxmlLevel = 10;
                continue;
            }
            if (tok.equals(SWITCH_WEBAPP_XML)) {
                this.webxmlFile = this.nextArg();
                if (this.webxmlFile == null) continue;
                this.webxmlLevel = 20;
                continue;
            }
            if (tok.equals(SWITCH_MAPPED)) {
                this.mappedFile = true;
                continue;
            }
            if (tok.equals(SWITCH_XPOWERED_BY)) {
                this.xpoweredBy = true;
                continue;
            }
            if (tok.equals(SWITCH_TRIM_SPACES)) {
                this.setTrimSpaces(true);
                continue;
            }
            if (tok.equals(SWITCH_CLASSPATH)) {
                this.setClassPath(this.nextArg());
                continue;
            }
            if (tok.startsWith(SWITCH_DIE)) {
                try {
                    this.dieLevel = Integer.parseInt(tok.substring(SWITCH_DIE.length()));
                }
                catch (NumberFormatException nfe) {
                    this.dieLevel = 1;
                }
                die = this.dieLevel;
                continue;
            }
            if (tok.equals(SWITCH_HELP)) {
                this.helpNeeded = true;
                continue;
            }
            if (tok.equals(SWITCH_POOLING)) {
                tok = this.nextArg();
                if ("false".equals(tok)) {
                    this.poolingEnabled = false;
                    continue;
                }
                this.poolingEnabled = true;
                continue;
            }
            if (tok.equals(SWITCH_ENCODING)) {
                this.setJavaEncoding(this.nextArg());
                continue;
            }
            if (tok.equals(SWITCH_MODE)) {
                this.setMode(this.nextArg());
                continue;
            }
            if (tok.startsWith("-")) {
                throw new Jsp2EngineException("Unrecognized option: " + tok + ".  Use -help for help.");
            }
            if (this.fullstop) break;
            --this.argPos;
            break;
        }
        while ((file = this.nextFile()) != null) {
            this.pages.addElement(file);
        }
    }

    public void setArgs2(String[] arg) throws Jsp2EngineException {
        String file;
        String tok;
        this.args = arg;
        die = this.dieLevel = 1;
        while ((tok = this.nextArg()) != null) {
            if (tok.equals(SWITCH_MODE)) {
                tok = this.nextArg();
                if (tok == null) {
                    this.exit("no value specified for -mode");
                }
                if (tok.equalsIgnoreCase(MODE_NORMAL)) {
                    this.setMode(MODE_NORMAL);
                    continue;
                }
                if (tok.equalsIgnoreCase(MODE_WAR)) {
                    this.setMode(MODE_WAR);
                    continue;
                }
                if (tok.equalsIgnoreCase(MODE_MAP)) {
                    this.setMode(MODE_MAP);
                    continue;
                }
                this.exit("invalid -mode value : " + tok);
                continue;
            }
            if (tok.equals(SWITCH_CTXROOT)) {
                tok = this.nextArg();
                if (tok == null) {
                    this.exit("no value specified for -ctxroot");
                }
                this.setUriroot(tok);
                continue;
            }
            if (tok.equals(SWITCH_SRCDIR)) {
                tok = this.nextArg();
                this.setSrcDir(tok);
                continue;
            }
            if (tok.equals(SWITCH_WORKDIR)) {
                tok = this.nextArg();
                this.setScratchDir(tok);
                continue;
            }
            if (tok.equals(SWITCH_OUTDIR)) {
                tok = this.nextArg();
                this.setOutputDir(tok);
                continue;
            }
            if (tok.equals(SWITCH_OUTWAR)) {
                this.outwar = tok = this.nextArg();
                continue;
            }
            if (tok.equals(SWITCH_MAPDIR)) {
                this.setMapDir(this.nextArg());
                continue;
            }
            if (tok.equals("-q")) {
                this.quit = true;
                continue;
            }
            if (tok.equals(SWITCH_COMPILE_OPTION)) {
                this.compileopt = tok = this.nextArg();
                this.compileopt = this.compileopt.replace(',', ' ');
                continue;
            }
            if (tok.equals(SWITCH_CLASSPATH)) {
                tok = this.nextArg();
                this.setClassPath(tok);
                continue;
            }
            if (tok.equals(SWITCH_HELP_SHORT) || tok.equals(SWITCH_HELP)) {
                JspC.printUsage();
                continue;
            }
            if (tok.equals("-v")) {
                JspC.printVersion();
                continue;
            }
            if (tok.equals(SWITCH_NO_COMPILE)) {
                this.compile = false;
                continue;
            }
            if (tok.equals(SWITCH_BATCH_COMPILE)) {
                this.batchCompile = true;
                continue;
            }
            if (tok.equals(SWITCH_KEEP)) {
                this.isKeepGenerated = true;
                continue;
            }
            if (tok.equals(SWITCH_SMAP)) {
                this.smapSupressed = false;
                continue;
            }
            if (!tok.startsWith(SWITCH_EXIT_ON_FAIL)) continue;
            tok = this.nextArg();
            if (tok == null) {
                this.exit("no value specified for -exitOnFail");
            }
            this.exitOnFail = Boolean.getBoolean(tok);
        }
        while ((file = this.nextFile()) != null) {
            this.pages.addElement(file);
        }
        if (!this.compile || this.batchCompile) {
            this.eachCompile = false;
        }
    }

    public boolean getKeepGenerated() {
        return this.isKeepGenerated;
    }

    public boolean getTrimSpaces() {
        return this.trimSpaces;
    }

    public void setTrimSpaces(boolean ts) {
        this.trimSpaces = ts;
    }

    public boolean isPoolingEnabled() {
        return this.poolingEnabled;
    }

    public void setPoolingEnabled(boolean poolingEnabled) {
        this.poolingEnabled = poolingEnabled;
    }

    public boolean isXpoweredBy() {
        return this.xpoweredBy;
    }

    public void setXpoweredBy(boolean xpoweredBy) {
        this.xpoweredBy = xpoweredBy;
    }

    public boolean getErrorOnUseBeanInvalidClassAttribute() {
        return this.errorOnUseBeanInvalidClassAttribute;
    }

    public void setErrorOnUseBeanInvalidClassAttribute(boolean b) {
        this.errorOnUseBeanInvalidClassAttribute = b;
    }

    public int getTagPoolSize() {
        return 5;
    }

    public int getInitialCapacity() {
        return 32;
    }

    public boolean getMappedFile() {
        return this.mappedFile;
    }

    public Object getProtectionDomain() {
        return null;
    }

    public boolean getSendErrorToClient() {
        return true;
    }

    public void setClassDebugInfo(boolean b) {
        this.classDebugInfo = b;
    }

    public boolean getClassDebugInfo() {
        return this.classDebugInfo;
    }

    public int getCheckInterval() {
        return 300;
    }

    public int getModificationTestInterval() {
        return 0;
    }

    public boolean getDevelopment() {
        return false;
    }

    public boolean getUsePrecompiled() {
        return false;
    }

    public boolean getReloading() {
        return true;
    }

    public boolean isSmapSuppressed() {
        return this.smapSupressed;
    }

    public boolean isSmapDumped() {
        return false;
    }

    public void setGenStringAsCharArray(boolean genStringAsCharArray) {
        this.genStringAsCharArray = genStringAsCharArray;
    }

    public boolean genStringAsCharArray() {
        return this.genStringAsCharArray;
    }

    public void setIeClassId(String ieClassId) {
        this.ieClassId = ieClassId;
    }

    public String getIeClassId() {
        return this.ieClassId;
    }

    public File getScratchDir() {
        return this.scratchDir;
    }

    public File getOutDir() {
        return this.outputDir;
    }

    public Class getJspCompilerPlugin() {
        return null;
    }

    public String getJspCompilerPath() {
        return null;
    }

    public String getCompiler() {
        return this.compiler;
    }

    public void setCompiler(String c) {
        this.compiler = c;
    }

    public String getCompilerTargetVM() {
        return this.compilerTargetVM;
    }

    public void setCompilerTargetVM(String vm) {
        this.compilerTargetVM = vm;
    }

    public String getCompilerSourceVM() {
        return this.compilerSourceVM;
    }

    public void setCompilerSourceVM(String vm) {
        this.compilerSourceVM = vm;
    }

    public TldLocationsCache getTldLocationsCache() {
        return this.tldLocationsCache;
    }

    public String getJavaEncoding() {
        return this.javaEncoding;
    }

    public void setJavaEncoding(String encodingName) {
        this.javaEncoding = encodingName;
    }

    public boolean getFork() {
        return false;
    }

    public String getClassPath() {
        if (this.classPath != null) {
            return this.classPath;
        }
        return System.getProperty("java.class.path");
    }

    public void setClassPath(String s) {
        this.classPath = s;
    }

    public String getSystemClassPath() {
        if (this.sysClassPath != null) {
            return this.sysClassPath;
        }
        return System.getProperty("java.class.path");
    }

    public void setSystemClassPath(String s) {
        this.sysClassPath = s;
    }

    public void setUriroot(String s) {
        if (s == null) {
            this.uriRoot = s;
            return;
        }
        try {
            this.uriRoot = new File(s).getCanonicalPath();
        }
        catch (Exception ex) {
            this.uriRoot = s;
        }
    }

    public void setJspFiles(String jspFiles) {
        StringTokenizer tok = new StringTokenizer(jspFiles, " ,");
        while (tok.hasMoreTokens()) {
            this.pages.addElement(tok.nextToken());
        }
    }

    public void setCompile(boolean b) {
        this.compile = b;
    }

    public void setVerbose(int level) {
        if (level > 0) {
            this.verbose = true;
            this.showSuccess = true;
            this.listErrors = true;
        }
    }

    public void setValidateXml(boolean b) {
        this.setIsTldValidationEnabled(b);
    }

    public void setIsTldValidationEnabled(boolean b) {
        this.isTldValidationEnabled = b;
    }

    public boolean isTldValidationEnabled() {
        return this.isTldValidationEnabled;
    }

    public void setListErrors(boolean b) {
        this.listErrors = b;
    }

    public void setScratchDir(String s) {
        this.scratchDir = s != null ? new File(s).getAbsoluteFile() : null;
    }

    public void setOutputDir(String outdir) {
        this.outputDir = outdir != null ? new File(outdir).getAbsoluteFile() : null;
    }

    public void setPackage(String p) {
        this.targetPackage = p;
    }

    public void setClassName(String p) {
        this.targetClassName = p;
    }

    public void setWebXmlFragment(String s) {
        this.webxmlFile = s;
        this.webxmlLevel = 10;
    }

    public void setWebXml(String s) {
        this.webxmlFile = s;
        this.webxmlLevel = 20;
    }

    public void setAddWebXmlMappings(boolean b) {
        this.addWebXmlMappings = b;
    }

    public JspConfig getJspConfig() {
        return this.jspConfig;
    }

    public TagPluginManager getTagPluginManager() {
        return this.tagPluginManager;
    }

    public void generateWebMapping(String file, JspCompilationContext clctxt) throws IOException {
        String className = clctxt.getServletClassName();
        String packageName = clctxt.getServletPackageName();
        String thisServletName = "".equals(packageName) ? className : packageName + '.' + className;
        if (this.servletout != null) {
            this.servletout.write("\n    <servlet>\n        <servlet-name>");
            this.servletout.write(thisServletName);
            this.servletout.write("</servlet-name>\n        <servlet-class>");
            this.servletout.write(thisServletName);
            this.servletout.write("</servlet-class>\n    </servlet>\n");
        }
        if (this.mappingout != null) {
            this.mappingout.write("\n    <servlet-mapping>\n        <servlet-name>");
            this.mappingout.write(thisServletName);
            this.mappingout.write("</servlet-name>\n        <url-pattern>");
            this.mappingout.write(file.replace('\\', '/'));
            this.mappingout.write("</url-pattern>\n    </servlet-mapping>\n");
        }
    }

    protected void mergeIntoWebXml() throws IOException {
        int n;
        File webappBase = new File(this.uriRoot);
        File webXml = new File(webappBase, "WEB-INF/web.xml");
        File webXml2 = new File(webappBase, "WEB-INF/web2.xml");
        String insertStartMarker = Localizer.getMessage("jspc.webinc.insertStart");
        String insertEndMarker = Localizer.getMessage("jspc.webinc.insertEnd");
        BufferedReader reader = new BufferedReader(new FileReader(webXml));
        BufferedReader fragmentReader = new BufferedReader(new FileReader(this.webxmlFile));
        PrintWriter writer = new PrintWriter(new FileWriter(webXml2));
        int pos = -1;
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.indexOf(insertStartMarker) >= 0) {
                do {
                    if ((line = reader.readLine()) != null) continue;
                    return;
                } while (line.indexOf(insertEndMarker) < 0);
                line = reader.readLine();
                if (line == null) {
                    return;
                }
            }
            for (int i = 0; i < insertBefore.length && (pos = line.indexOf(insertBefore[i])) < 0; ++i) {
            }
            if (pos >= 0) {
                writer.println(line.substring(0, pos));
                break;
            }
            writer.println(line);
        }
        writer.println(insertStartMarker);
        while (true) {
            String line2;
            if ((line2 = fragmentReader.readLine()) == null) break;
            writer.println(line2);
        }
        writer.println();
        writer.println(insertEndMarker);
        writer.println();
        for (int i = 0; i < pos; ++i) {
            writer.print(" ");
        }
        writer.println(line.substring(pos));
        while ((line = reader.readLine()) != null) {
            writer.println(line);
        }
        writer.close();
        reader.close();
        fragmentReader.close();
        FileInputStream fis = new FileInputStream(webXml2);
        FileOutputStream fos = new FileOutputStream(webXml);
        byte[] buf = new byte[512];
        while ((n = fis.read(buf)) >= 0) {
            fos.write(buf, 0, n);
        }
        fis.close();
        fos.close();
        webXml2.delete();
        new File(this.webxmlFile).delete();
    }

    private void processFile(String file) throws Jsp2EngineException {
        try {
            if (this.scratchDir == null) {
                String temp = null;
                temp = MODE_MAP.equals(this.getMode()) ? this.uriRoot + "/WEB-INF/classes" : this.uriRoot + "/WEB-INF/" + ".warjspwork";
                if (temp == null) {
                    temp = "";
                }
                this.scratchDir = new File(new File(temp).getCanonicalPath());
            }
            if (this.outputDir == null) {
                this.outputDir = this.scratchDir;
            }
            String jspUri = file.replace('\\', '/');
            JspCompilationContext clctxt = new JspCompilationContext(jspUri, false, this, this.context, null, this.rctxt);
            if (this.getMode() != null && this.getMode().equals(MODE_MAP)) {
                clctxt.setUseSameName();
            }
            if (this.targetClassName != null && this.targetClassName.length() > 0) {
                clctxt.setServletClassName(this.targetClassName);
                this.targetClassName = null;
            }
            if (this.targetPackage != null) {
                clctxt.setServletPackageName(this.targetPackage);
            }
            if (this.loader == null) {
                this.initClassLoader(clctxt);
            }
            clctxt.setClassLoader(this.loader);
            clctxt.setClassPath(this.classPath);
            jeus.servlet.jsp.JspConfig jspConfig = new jeus.servlet.jsp.JspConfig();
            jspConfig.compileOutputDir = this.outputDir.getAbsolutePath();
            jspConfig.compileOption = this.compileopt;
            jspConfig.classpath = this.getClassPath();
            clctxt.setJspConfig(jspConfig);
            Compiler clc = clctxt.createCompiler();
            if (this.eachCompile) {
                clc.initJavaCompiler(false);
            }
            if (clc.isOutDated(this.eachCompile)) {
                clc.compile(this.eachCompile, true);
            }
            this.generateWebMapping(file, clctxt);
            if (this.showSuccess) {
                // empty if block
            }
            this.listBuffer.append(new File(clctxt.getServletJavaFileName()).getCanonicalPath());
            this.listBuffer.append('\n');
        }
        catch (Jsp2EngineException je) {
            Object rootCause = je;
            while (rootCause instanceof Jsp2EngineException && rootCause.getRootCause() != null) {
                rootCause = rootCause.getRootCause();
            }
            throw je;
        }
        catch (Exception e) {
            throw new Jsp2EngineException(e);
        }
    }

    public void scanFiles(File base) throws Jsp2EngineException {
        Stack<Object> dirs = new Stack<Object>();
        dirs.push(base);
        if (this.extensions == null) {
            this.extensions = new Vector();
            this.extensions.addElement("jsp");
            this.extensions.addElement("jspx");
        }
        while (!dirs.isEmpty()) {
            String s = dirs.pop().toString();
            File f = new File(s);
            if (!f.exists() || !f.isDirectory()) continue;
            String[] files = f.list();
            for (int i = 0; files != null && i < files.length; ++i) {
                File f2 = new File(s, files[i]);
                if (f2.isDirectory()) {
                    dirs.push(f2.getPath());
                    continue;
                }
                String path = f2.getPath();
                String uri = path.substring(this.uriRoot.length());
                String ext = files[i].substring(files[i].lastIndexOf(46) + 1);
                if (!this.extensions.contains(ext) && !this.jspConfig.isJspPage(uri)) continue;
                this.pages.addElement(path);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws Jsp2EngineException {
        int parsedJspCount = 0;
        try {
            if (this.getMode() == null) {
                throw new Jsp2EngineException("no value specified for -mode");
            }
            if (this.uriRoot == null) {
                if (this.pages.size() == 0) {
                    throw new Jsp2EngineException("no value specified for -ctxroot");
                }
                String firstJsp = (String)this.pages.elementAt(0);
                File file = new File(firstJsp);
                if (!file.exists()) {
                    throw new Jsp2EngineException(Localizer.getMessage("jspc.error.fileDoesNotExist", firstJsp));
                }
                this.locateUriRoot(file);
            }
            if (this.uriRoot == null) {
                throw new Jsp2EngineException(Localizer.getMessage("jsp.error.jspc.no_uriroot"));
            }
            File uriRootF = new File(this.uriRoot);
            if (MODE_WAR.equals(this.getMode())) {
                File file;
                if (!uriRootF.isFile() || !uriRootF.getName().endsWith(".war")) throw new Jsp2EngineException("The -ctxroot option must specify a pre-existing war file");
                if (this.outwar == null) {
                    this.outwar = DEFAULT_OUTWAR;
                }
                if (!(file = new File(UNJAR_PATH + '_' + uriRootF.getName())).exists()) {
                    file.mkdirs();
                } else {
                    this.deleteDirectory(file);
                }
                this.warfilename = this.uriRoot;
                this.uriRoot = file.getCanonicalPath();
                if (this.uriRoot.endsWith(File.separator)) {
                    this.uriRoot = this.uriRoot.substring(0, this.uriRoot.length() - 1);
                }
                try {
                    JarManager.unJar(this.warfilename, this.uriRoot);
                    String warjspworkDir = file.getAbsolutePath() + "/WEB-INF/" + ".warjspwork";
                    this.setScratchDir(warjspworkDir);
                    this.setOutputDir(warjspworkDir);
                }
                catch (Exception e1) {
                    throw new Jsp2EngineException(e1);
                }
            } else if (!uriRootF.exists() || !uriRootF.isDirectory()) {
                throw new Jsp2EngineException("The -ctxroot option must specify a pre-existing directory");
            }
            if (this.context == null) {
                this.initServletContext();
            }
            if (this.pages.size() == 0) {
                if (this.getSrcDir() != null) {
                    this.scanFiles(new File(this.uriRoot + this.getSrcDir()));
                } else {
                    this.scanFiles(new File(this.uriRoot));
                }
            }
            if (this.getMode() != null && MODE_MAP.equals(this.getMode())) {
                if (this.webxmlFile == null) {
                    this.setMapDir(this.uriRoot + "/WEB-INF");
                }
                this.initWebXml();
            }
            int n = this.pages.size();
            int count = 0;
            DecimalFormat numFormat = new DecimalFormat("###%");
            String countStat = null;
            Vector<String> successList = new Vector<String>();
            Vector<String> failList = new Vector<String>();
            String contextName = uriRootF.getName();
            int index = contextName.lastIndexOf(46);
            if (index > 0 && contextName.endsWith(".war")) {
                contextName = contextName.substring(0, index);
            }
            this.listBuffer = new StringBuffer();
            Enumeration e = this.pages.elements();
            while (e.hasMoreElements()) {
                ++count;
                String nextjsp = e.nextElement().toString();
                File fjsp = new File(nextjsp);
                if (!fjsp.isAbsolute()) {
                    fjsp = new File(uriRootF, nextjsp);
                }
                if (!fjsp.exists()) continue;
                String s = fjsp.getAbsolutePath();
                if (s.startsWith(this.uriRoot)) {
                    nextjsp = s.substring(this.uriRoot.length());
                }
                if (nextjsp.startsWith("." + File.separatorChar)) {
                    nextjsp = nextjsp.substring(2);
                }
                try {
                    double percent = (double)count / (double)n;
                    countStat = " [" + numFormat.format(percent) + "]";
                    if (this.eachCompile) {
                        System.out.print(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5701, (Object[])new String[]{contextName, nextjsp}));
                    } else {
                        System.out.print(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5700, (Object[])new String[]{contextName, nextjsp}));
                    }
                    this.processFile(nextjsp);
                    successList.add(nextjsp);
                    System.out.println(" OK " + countStat);
                }
                catch (Jsp2EngineException je) {
                    failList.add(nextjsp);
                    System.out.println(" FAIL " + countStat);
                    Throwable rootCause = je.getRootCause();
                    if (rootCause instanceof JspCompileException) {
                        System.out.println(rootCause.getMessage());
                    } else if (rootCause != null) {
                        rootCause.printStackTrace(System.out);
                        if (rootCause instanceof ServletException) {
                            System.out.println("[RootCause] : ");
                            Throwable tt = je.getRootCause();
                            if (tt != null) {
                                tt.printStackTrace(System.out);
                            }
                        }
                    } else {
                        je.printStackTrace(System.out);
                    }
                    if (!this.quit) continue;
                    throw je;
                }
            }
            parsedJspCount = successList.size();
            if (this.compile && this.batchCompile && parsedJspCount > 0) {
                System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5698, (Object)String.valueOf(parsedJspCount)));
                String argfile = this.outputDir.getCanonicalPath() + File.separator + "__argfile__";
                FileWriter writer = new FileWriter(argfile);
                writer.write(this.listBuffer.toString());
                ((Writer)writer).close();
                JspCompilationContext clctxt = new JspCompilationContext("", false, this, this.context, null, this.rctxt);
                Compiler jspCompiler = clctxt.createCompiler();
                jspCompiler.initJavaCompiler(false);
                JavaCompiler javaCompiler = jspCompiler.getCompiler(this.getCompileClassPath(this.classPath), "UTF8", this.outputDir.getCanonicalPath(), this.compileopt, "@" + argfile);
                try {
                    javaCompiler.compile();
                    System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5696, (Object)String.valueOf(parsedJspCount)));
                    this.printResult(contextName, successList, failList);
                }
                catch (JspCompileException jce) {
                    System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5699));
                    throw new Jsp2EngineException((Throwable)((Object)jce));
                }
            } else {
                this.printResult(contextName, successList, failList);
            }
            if (this.getMode() != null && MODE_MAP.equals(this.getMode())) {
                this.completeWebXml();
            }
            if (!this.addWebXmlMappings) return;
            this.mergeIntoWebXml();
            return;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new Jsp2EngineException(ioe);
        }
        catch (Jsp2EngineException je) {
            void var3_11;
            Jsp2EngineException jsp2EngineException = je;
            while (var3_11 instanceof Jsp2EngineException && ((Jsp2EngineException)var3_11).getRootCause() != null) {
                Throwable throwable = ((Jsp2EngineException)var3_11).getRootCause();
            }
            if (var3_11 == je) throw je;
            var3_11.printStackTrace();
            throw je;
        }
        finally {
            try {
                this.finish(parsedJspCount);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String nextArg() {
        if (this.argPos >= this.args.length || (this.fullstop = SWITCH_FULL_STOP.equals(this.args[this.argPos]))) {
            return null;
        }
        return this.args[this.argPos++];
    }

    private String nextFile() {
        if (this.fullstop) {
            ++this.argPos;
        }
        if (this.argPos >= this.args.length) {
            return null;
        }
        return this.args[this.argPos++];
    }

    private void initWebXml() {
        try {
            if (this.webxmlLevel >= 10) {
                File fmapings = new File(this.webxmlFile);
                this.mapout = new FileWriter(fmapings);
                this.servletout = new CharArrayWriter();
                this.mappingout = new CharArrayWriter();
            } else {
                this.mapout = null;
                this.servletout = null;
                this.mappingout = null;
            }
            if (this.webxmlLevel >= 20) {
                this.mapout.write(Localizer.getMessage("jspc.webxml.header"));
                this.mapout.flush();
            } else if (this.webxmlLevel >= 10 && !this.addWebXmlMappings) {
                this.mapout.write(Localizer.getMessage("jspc.webinc.header"));
                this.mapout.flush();
            }
        }
        catch (IOException ioe) {
            this.mapout = null;
            this.servletout = null;
            this.mappingout = null;
        }
    }

    private void completeWebXml() {
        if (this.mapout != null) {
            try {
                this.servletout.writeTo(this.mapout);
                this.mappingout.writeTo(this.mapout);
                if (this.webxmlLevel >= 20) {
                    this.mapout.write(Localizer.getMessage("jspc.webxml.footer"));
                } else if (this.webxmlLevel >= 10 && !this.addWebXmlMappings) {
                    this.mapout.write(Localizer.getMessage("jspc.webinc.footer"));
                }
                this.mapout.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void initServletContext() {
        try {
            this.context = new JspCServletContext(new PrintWriter(System.out), new URL("file:" + this.uriRoot.replace('\\', '/') + '/'));
            this.tldLocationsCache = new TldLocationsCache(this.context, this, true);
        }
        catch (MalformedURLException me) {
            System.out.println("**" + me);
        }
        this.rctxt = new JspRuntimeContext(this.context, this);
        this.jspConfig = new JspConfig(this.context);
        this.tagPluginManager = new TagPluginManager(this.context);
    }

    private void initClassLoader(JspCompilationContext clctxt) throws IOException {
        URL[] urlsA;
        boolean webinfFirst = false;
        ContextType contextType = this.getContextType();
        if (contextType != null && contextType.isSetWebinfFirst()) {
            webinfFirst = contextType.isWebinfFirst();
        }
        this.context.setWebinfFirst(webinfFirst);
        this.classPath = this.getClassPath();
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(this.classPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            try {
                File libFile = new File(path);
                urls.add(libFile.toURL());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.toString());
            }
        }
        File webappBase = new File(this.uriRoot);
        if (webappBase.exists()) {
            File classes = new File(webappBase, "/WEB-INF/classes");
            try {
                if (classes.exists()) {
                    this.classPath = this.classPath + File.pathSeparator + classes.getCanonicalPath();
                    urls.add(classes.getCanonicalFile().toURL());
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.toString());
            }
            File jeusTagwork = new File(webappBase, "/WEB-INF/.warjspwork/jeus_tagwork");
            try {
                if (!jeusTagwork.exists()) {
                    jeusTagwork.mkdirs();
                }
                this.classPath = this.classPath + File.pathSeparator + jeusTagwork.getCanonicalPath();
                urls.add(jeusTagwork.getCanonicalFile().toURL());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.toString());
            }
            File lib = new File(webappBase, "/WEB-INF/lib");
            if (lib.exists() && lib.isDirectory()) {
                String[] libs = lib.list();
                for (int i = 0; i < libs.length; ++i) {
                    String ext;
                    if (libs[i].length() < 5 || !".jar".equalsIgnoreCase(ext = libs[i].substring(libs[i].length() - 4))) continue;
                    try {
                        File libFile = new File(lib, libs[i]);
                        this.classPath = this.classPath + File.pathSeparator + libFile.getCanonicalPath();
                        urls.add(libFile.getCanonicalFile().toURL());
                        continue;
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe.toString());
                    }
                }
            }
        }
        LibraryManager libraryManager = LibraryManager.getInstance();
        libraryManager.refresh();
        if (contextType != null) {
            List libRefs = contextType.getLibraryRef();
            for (LibraryRefType libRef : libRefs) {
                this.addSharedLibraries(urls, libraryManager, new LibraryRef(libRef));
            }
        }
        LibraryRef ref = new LibraryRef("jsf", "1.2", null);
        this.addSharedLibraries(urls, libraryManager, ref);
        ref = new LibraryRef("jstl", "1.2", null);
        this.addSharedLibraries(urls, libraryManager, ref);
        urls.add(new File(clctxt.getRealPath("/")).getCanonicalFile().toURL());
        this.prevLoader = Thread.currentThread().getContextClassLoader();
        EJBRootClassLoader ejbRootClassLoader = null;
        if (this.prevLoader instanceof ArchiveArrayClassLoader) {
            ArchiveArrayClassLoader archiveArrayClassLoader = (ArchiveArrayClassLoader)this.prevLoader;
            ejbRootClassLoader = (EJBRootClassLoader)archiveArrayClassLoader.getParent();
            this.classPath = archiveArrayClassLoader.getClassPath() + File.pathSeparator + this.classPath;
            tokenizer = new StringTokenizer(archiveArrayClassLoader.getClassPath(), File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                urls.add(0, new File(tokenizer.nextToken()).toURL());
            }
        } else if (this.prevLoader instanceof RootClassLoader) {
            if (((RootClassLoader)this.prevLoader).getEJBRootClassLoader() != null) {
                ejbRootClassLoader = (EJBRootClassLoader)((RootClassLoader)this.prevLoader).getEJBRootClassLoader();
            } else {
                ejbRootClassLoader = new EJBRootClassLoader(new URL[0], JeusRootClassLoader.loader, "JspBatchContainer");
                ((RootClassLoader)JeusRootClassLoader.loader).registerEJBRootClassLoader(ejbRootClassLoader);
                EngineContainer.rootClassLoader = ejbRootClassLoader;
            }
        } else if (this.prevLoader instanceof EJBRootClassLoader) {
            ejbRootClassLoader = (EJBRootClassLoader)this.prevLoader;
        } else {
            urlsA = new URL[urls.size()];
            urls.toArray(urlsA);
            this.loader = new URLClassLoader(urlsA, this.getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(this.loader);
            return;
        }
        urlsA = new URL[urls.size()];
        urls.toArray(urlsA);
        AbstractArchive[] archives = new AbstractArchive[urlsA.length];
        for (int i = 0; i < urls.size(); ++i) {
            archives[i] = ArchiveHelper.openArchive((String)urlsA[i].getFile());
        }
        this.loader = ArchiveArrayClassLoader.createClassLoader(archives, ejbRootClassLoader, true, "BatchContext");
        Thread.currentThread().setContextClassLoader(this.loader);
    }

    private void addSharedLibraries(ArrayList urls, LibraryManager libraryManager, LibraryRef ref) {
        try {
            List<ClassPathEntry> entries = libraryManager.getClassPathEntries(ref);
            if (entries != null) {
                for (ClassPathEntry entry : entries) {
                    try {
                        File libFile = new File(entry.getPath());
                        urls.add(libFile.toURL());
                        this.classPath = this.classPath + File.pathSeparator + libFile.getCanonicalPath();
                    }
                    catch (MalformedURLException e) {
                    }
                    catch (IOException e) {}
                }
            }
        }
        catch (LibraryNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void locateUriRoot(File f) {
        String tUriBase = this.uriBase;
        if (tUriBase == null) {
            tUriBase = "/";
        }
        try {
            if (f.exists()) {
                f = new File(f.getCanonicalPath());
                while (f != null) {
                    String fParent;
                    File g = new File(f, "WEB-INF");
                    if (g.exists() && g.isDirectory()) {
                        this.uriRoot = f.getCanonicalPath();
                        this.uriBase = tUriBase;
                        break;
                    }
                    if (f.exists() && f.isDirectory()) {
                        tUriBase = "/" + f.getName() + "/" + tUriBase;
                    }
                    if ((fParent = f.getParent()) == null) break;
                    f = new File(fParent);
                }
                if (this.uriRoot != null) {
                    File froot = new File(this.uriRoot);
                    this.uriRoot = froot.getCanonicalPath();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public void setSrcDir(String srcDir) {
        this.srcDir = srcDir;
    }

    public String getSrcDir() {
        return this.srcDir;
    }

    private void exit(String msg) {
        System.out.println();
        System.out.println(msg);
        System.out.println();
        System.exit(0);
    }

    public void finish(int parsedJspCount) throws IOException {
        String argFileName;
        File argFile;
        if (this.loader != null) {
            if (this.loader instanceof ArchiveClassLoader) {
                ((ArchiveClassLoader)this.loader).clear();
            }
            this.loader = null;
        }
        if (this.prevLoader != null) {
            Thread.currentThread().setContextClassLoader(this.prevLoader);
        }
        System.gc();
        if (MODE_WAR.equals(this.getMode())) {
            String targetwar = this.outwar;
            File f = new File(targetwar);
            if (f.exists()) {
                f.delete();
            }
            Set list = this.context.getResourcePathsAll("/");
            Iterator it = list.iterator();
            String item = null;
            ArrayList<String> items = new ArrayList<String>();
            while (it.hasNext()) {
                item = (String)it.next();
                if ((item = item.substring(1).trim()) == null || item.length() <= 0 || item.equals("")) continue;
                items.add(item);
            }
            if (items.size() > 0) {
                int size = items.size();
                String[] contents = new String[size];
                String[] entries = new String[size];
                for (int i = 0; i < size; ++i) {
                    entries[i] = (String)items.get(i);
                    contents[i] = this.uriRoot + File.separator + entries[i].replace('/', File.separatorChar);
                }
                JarManager.jar(targetwar, contents, entries);
            }
            this.deleteDirectory(new File(this.uriRoot));
        }
        if (parsedJspCount > 0 && !this.isKeepGenerated && (argFile = new File(argFileName = this.outputDir.getCanonicalPath() + File.separator + "__argfile__")).exists()) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(argFileName)));
            String line = null;
            while ((line = reader.readLine()) != null) {
                File deletingJavaFile = new File(line);
                deletingJavaFile.delete();
                File smapFile = new File(line.substring(line.lastIndexOf(".java")) + ".smap");
                if (!smapFile.exists()) continue;
                smapFile.delete();
            }
            reader.close();
            argFile.delete();
        }
    }

    private boolean deleteDirectory(File dir) {
        if (dir.isFile()) {
            return dir.delete();
        }
        boolean result = false;
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i] == null || (result = this.deleteDirectory(files[i]))) continue;
                System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5673, (Object)files[i].getAbsolutePath()));
                return false;
            }
        }
        if (!(result = dir.delete())) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5673, (Object)dir.getAbsolutePath()));
            return false;
        }
        return true;
    }

    private static void printUsage() {
        System.out.println("JEUS Web Container version: " + JeusVersion.getVersion());
        System.out.println("JspC -mode {normal|war|map}");
        System.out.println("      -ctxroot {<ctxroot>|<war file path>}");
        System.out.println("      [-outwar <output war filename>]");
        System.out.println("      [-srcdir <srcdir or srcfile>] [-workdir <working directory>]");
        System.out.println("      [-outdir <output directory>] [-mapdir <directory of jeus_jspmap.xml>]");
        System.out.println("      [-q] [-co \"javac options\"] [-nocompile]");
        System.out.println("      [-classpath <extra classpath>]");
        System.out.println();
        System.out.println("  * -mode normal");
        System.out.println("    > pre-compile the jsp file(s) of corresponding context");
        System.out.println("    > if -srcdir is omitted, entire jsp files within <ctxroot> will ");
        System.out.println("      be pre-compiled. <srcdir or srcfile> is relative path of <ctxroot>");
        System.out.println("      starting with '/'");
        System.out.println("    > -mapdir option is not used");
        System.out.println("    > if -workdir is omitted, <ctxroot>/WEB-INF/.warjspwork will be a default");
        System.out.println("      working directory");
        System.out.println("    > if -outdir is omitted, <ctxroot>/WEB-INF/.warjspwork will be a default");
        System.out.println("      output directory");
        System.out.println("    > -outwar option is not used");
        System.out.println();
        System.out.println("  * -mode war");
        System.out.println("    > pre-compile the jsp file(s) of corresponding war file");
        System.out.println("    > if -outwar is omitted, \"./jspcout.war\" will be a default file name");
        System.out.println("    > -srcdir option is not used");
        System.out.println("    > -mapdir option is not used");
        System.out.println("    > -workdir option is not used");
        System.out.println("    > -outdir option is not used");
        System.out.println();
        System.out.println("  * -mode map");
        System.out.println("    > pre-compile the jsp file(s) of corresponding context and");
        System.out.println("      generate servlet-mapping table (jeus_jspmap.xml)");
        System.out.println("    > if -srcdir is omitted, entire jsp files within <ctxroot> will ");
        System.out.println("      be pre-compiled. <srcdir or srcfile> is relative path of <ctxroot>");
        System.out.println("      starting with '/'");
        System.out.println("    > if -mapdir is omitted, <ctxroot>/WEB-INF will be a default map directory");
        System.out.println("    > if -workdir is omitted, <ctxroot>/WEB-INF/classes will be a default");
        System.out.println("      working directory");
        System.out.println("    > if -outdir is omitted, <ctxroot>/WEB-INF/classes will be a default");
        System.out.println("      output directory");
        System.out.println("    > -outwar option is not used");
        System.out.println();
        System.out.println("  * common options");
        System.out.println("    -classpath <extra classpath> : extra classpath separated");
        System.out.println("        by ';'(Windows) or ':' (Unix)");
        System.out.println("    -nocompile  : generate only java files without compiling");
        System.out.println("    -q  : stop compilation on compile error");
        System.out.println("    -co : extra javac compile option. space must be replaced by ','");
        System.out.println("    -h  : this message");
        System.out.println("    -v  : version information");
        System.exit(0);
    }

    private static void printVersion() {
        System.out.println("JEUS Web Container version: " + JeusVersion.getVersion());
        System.exit(0);
    }

    private void printResult(String ctxName, Vector successList, Vector failList) {
        String uri;
        Enumeration enum1;
        System.out.println();
        System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5664, (Object)ctxName));
        if (successList != null) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5665));
            enum1 = successList.elements();
            while (enum1.hasMoreElements()) {
                uri = (String)enum1.nextElement();
                System.out.println("[BatchCompiler]         " + uri);
            }
        }
        if (failList != null) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5666));
            enum1 = failList.elements();
            while (enum1.hasMoreElements()) {
                uri = (String)enum1.nextElement();
                System.out.println("[BatchCompiler]         " + uri);
            }
        }
        int successCount = successList == null ? 0 : successList.size();
        int failCount = failList == null ? 0 : failList.size();
        System.out.println("[BatchCompiler]   =====================================================");
        System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5667, (Object[])new String[]{String.valueOf(successCount + failCount), String.valueOf(successCount), String.valueOf(failCount)}));
        System.out.println("[BatchCompiler]   =====================================================");
        if (failCount > 0) {
            this.failed = true;
        }
    }

    private void setMapDir(String mapDir) {
        this.webxmlFile = mapDir + File.separator + MAP_FILE_NAME;
        if (this.webxmlFile != null) {
            this.webxmlLevel = 20;
        }
    }

    private String getCompileClassPath(String classpath) {
        String systemClassPath = null;
        try {
            systemClassPath = JeusRootClassLoader.getRootClassPaths();
        }
        catch (Exception e) {
            systemClassPath = JeusBootstrapProperties.JEUS_HOME + File.separator + "lib" + File.separator + "system" + File.separator + "javaee.jar";
            systemClassPath = systemClassPath + File.pathSeparator + JeusBootstrapProperties.JEUS_HOME + File.separator + "lib" + File.separator + "system" + File.separator + "jeus.jar";
        }
        return systemClassPath + System.getProperty("path.separator") + classpath;
    }

    private ContextType getContextType() {
        File jeusWebDD = new File(this.uriRoot + "/WEB-INF/jeus-web-dd.xml");
        if (!jeusWebDD.exists()) {
            return null;
        }
        ContextType contextType = null;
        try {
            JAXBContext jaxbctx = JAXBContextFactory.getContext("jeus.xml.binding.jeusDD");
            Unmarshaller unmarshaller = jaxbctx.createUnmarshaller();
            contextType = (ContextType)((JAXBElement)unmarshaller.unmarshal(jeusWebDD)).getValue();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return contextType;
    }

    static {
        UNJAR_PATH = System.getProperty("java.io.tmpdir") + File.separator + "__jspctmp";
        DEFAULT_OUTWAR = "." + File.separator + "jspcout.war";
    }
}

