/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp2;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.jsp.tagext.TagInfo;
import jeus.servlet.jsp.JspConfig;
import jeus.servlet.jsp2.Jsp2EngineException;
import jeus.servlet.jsp2.Options;
import jeus.servlet.jsp2.compiler.Compiler;
import jeus.servlet.jsp2.compiler.JspRuntimeContext;
import jeus.servlet.jsp2.compiler.JspUtil;
import jeus.servlet.jsp2.compiler.Localizer;
import jeus.servlet.jsp2.compiler.ServletWriter;
import jeus.servlet.jsp2.servlet.JspServletWrapper;
import jeus.servlet.loader.JspReloader;

public class JspCompilationContext {
    private Hashtable tagFileJarUrls;
    private boolean isPackagedTagFile;
    private String className;
    private String jspUri;
    private boolean isErrPage;
    private String basePackageName;
    private String derivedPackageName;
    private String servletJavaFileName;
    private String javaPath;
    private String classFileName;
    private String contentType;
    private ServletWriter writer;
    private Options options;
    private JspServletWrapper jsw;
    private Compiler jspCompiler;
    private String classPath;
    private String baseURI;
    private String baseOutputDir;
    private String outputDir;
    private String jspWorkDir;
    private ServletContext context;
    private ClassLoader loader;
    private JspRuntimeContext rctxt;
    private int removed = 0;
    private URLClassLoader jspLoader;
    private URL baseUrl;
    private Class servletClass;
    private boolean isTagFile;
    private boolean protoTypeMode;
    private TagInfo tagInfo;
    private URL tagFileJarUrl;
    private JspConfig jspConfig;
    private boolean useSameName = false;
    static Object outputDirLock = new Object();

    public JspCompilationContext(String jspUri, boolean isErrPage, Options options, ServletContext context, JspServletWrapper jsw, JspRuntimeContext rctxt) throws Jsp2EngineException {
        this.jspUri = JspCompilationContext.canonicalURI(jspUri);
        this.isErrPage = isErrPage;
        this.options = options;
        this.jsw = jsw;
        this.context = context;
        this.baseURI = jspUri.substring(0, jspUri.lastIndexOf(47) + 1);
        if (this.baseURI == null || "".equals(this.baseURI)) {
            this.baseURI = "/";
        } else if (this.baseURI.charAt(0) != '/') {
            this.baseURI = "/" + this.baseURI;
        }
        if (this.baseURI.charAt(this.baseURI.length() - 1) != '/') {
            this.baseURI = this.baseURI + '/';
        }
        this.rctxt = rctxt;
        this.tagFileJarUrls = new Hashtable();
        this.basePackageName = "jeus_jspwork";
    }

    public JspCompilationContext(String tagfile, TagInfo tagInfo, Options options, ServletContext context, JspServletWrapper jsw, JspRuntimeContext rctxt, URL tagFileJarUrl) throws Jsp2EngineException {
        this(tagfile, false, options, context, jsw, rctxt);
        this.isTagFile = true;
        this.tagInfo = tagInfo;
        this.tagFileJarUrl = tagFileJarUrl;
        if (tagFileJarUrl != null) {
            this.isPackagedTagFile = true;
        }
    }

    public String getClassPath() {
        if (this.classPath != null) {
            return this.classPath;
        }
        return this.rctxt.getClassPath();
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public ClassLoader getClassLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        return this.rctxt.getParentClassLoader();
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public String getOutputDir() {
        if (this.outputDir == null) {
            this.createOutputDir();
        }
        return this.outputDir;
    }

    public String getJspWorkDir() {
        if (this.jspWorkDir == null) {
            this.createJspWorkDir();
        }
        return this.jspWorkDir;
    }

    public Compiler createCompiler() throws Jsp2EngineException {
        if (this.jspCompiler != null) {
            return this.jspCompiler;
        }
        this.jspCompiler = new Compiler(this, this.jsw);
        return this.jspCompiler;
    }

    public Compiler getCompiler() {
        return this.jspCompiler;
    }

    public String resolveRelativeUri(String uri) {
        if (uri.startsWith("/") || uri.startsWith(File.separator)) {
            return uri;
        }
        return this.baseURI + uri;
    }

    public InputStream getResourceAsStream(String res) throws Jsp2EngineException {
        return this.context.getResourceAsStream(JspCompilationContext.canonicalURI(res));
    }

    public URL getResource(String res) throws MalformedURLException {
        try {
            return this.context.getResource(JspCompilationContext.canonicalURI(res));
        }
        catch (Jsp2EngineException ex) {
            throw new MalformedURLException(ex.getMessage());
        }
    }

    public Set getResourcePaths(String path) throws Jsp2EngineException {
        return this.context.getResourcePaths(JspCompilationContext.canonicalURI(path));
    }

    public String getRealPath(String path) {
        if (this.context != null) {
            return this.context.getRealPath(path);
        }
        return path;
    }

    public Hashtable getTagFileJarUrls() {
        return this.tagFileJarUrls;
    }

    public URL getTagFileJarUrl() {
        return this.tagFileJarUrl;
    }

    public String getServletClassName() {
        if (this.className != null) {
            return this.className;
        }
        if (this.isTagFile) {
            this.className = this.tagInfo.getTagClassName();
            int lastIndex = this.className.lastIndexOf(46);
            if (lastIndex != -1) {
                this.className = this.className.substring(lastIndex + 1);
            }
        } else {
            this.className = JspReloader.generateClassName(null, this.jspUri, this.useSameName);
            int lastIndex = this.className.lastIndexOf(46);
            if (lastIndex != -1) {
                this.className = this.className.substring(lastIndex + 1);
            }
        }
        return this.className;
    }

    public void setServletClassName(String className) {
        this.className = className;
    }

    public String getJspFile() {
        return this.jspUri;
    }

    public boolean isErrorPage() {
        return this.isErrPage;
    }

    public void setErrorPage(boolean isErrPage) {
        this.isErrPage = isErrPage;
    }

    public boolean isTagFile() {
        return this.isTagFile;
    }

    public TagInfo getTagInfo() {
        return this.tagInfo;
    }

    public void setTagInfo(TagInfo tagi) {
        this.tagInfo = tagi;
    }

    public boolean isPrototypeMode() {
        return this.protoTypeMode;
    }

    public void setPrototypeMode(boolean pm) {
        this.protoTypeMode = pm;
    }

    public String getServletPackageName() {
        String dPackageName = this.getDerivedPackageName();
        if (dPackageName.length() == 0) {
            if (this.basePackageName != null) {
                return this.basePackageName;
            }
            return "";
        }
        if (this.basePackageName.length() == 0) {
            return this.getDerivedPackageName();
        }
        return this.basePackageName + '.' + this.getDerivedPackageName();
    }

    private String getDerivedPackageName() {
        if (this.derivedPackageName == null) {
            int iSep = this.jspUri.lastIndexOf(47);
            this.derivedPackageName = iSep > 0 ? JspUtil.makeJavaPackage(this.jspUri.substring(1, iSep), this.useSameName) : "";
        }
        return this.derivedPackageName;
    }

    public void disableDerivedPackageName() {
        this.derivedPackageName = "";
    }

    public void setServletPackageName(String servletPackageName) {
        this.basePackageName = servletPackageName;
    }

    public String getServletJavaFileName() {
        if (this.servletJavaFileName == null) {
            this.servletJavaFileName = this.getOutputDir() + this.getServletClassName() + ".java";
        } else if (this.outputDir != null) {
            this.makeOutputDir();
        } else {
            this.createOutputDir();
        }
        return this.servletJavaFileName;
    }

    public void setServletJavaFileName(String servletJavaFileName) {
        this.servletJavaFileName = servletJavaFileName;
    }

    public Options getOptions() {
        return this.options;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public JspRuntimeContext getRuntimeContext() {
        return this.rctxt;
    }

    public String getJavaPath() {
        if (this.javaPath != null) {
            return this.javaPath;
        }
        if (this.isTagFile()) {
            String tagName = this.tagInfo.getTagClassName();
            this.javaPath = tagName.replace('.', '/') + ".java";
        } else {
            this.javaPath = this.getServletPackageName().replace('.', '/') + '/' + this.getServletClassName() + ".java";
        }
        return this.javaPath;
    }

    public String getClassFileName() {
        if (this.classFileName == null) {
            this.classFileName = this.getOutputDir() + this.getServletClassName() + ".class";
        } else if (this.outputDir != null) {
            this.makeOutputDir();
        } else {
            this.createOutputDir();
        }
        return this.classFileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public ServletWriter getWriter() {
        return this.writer;
    }

    public void setWriter(ServletWriter writer) {
        this.writer = writer;
    }

    public String[] getTldLocation(String uri) throws Jsp2EngineException {
        String[] location = this.getOptions().getTldLocationsCache().getLocation(uri);
        return location;
    }

    public boolean keepGenerated() {
        return this.getOptions().getKeepGenerated();
    }

    public void incrementRemoved() {
        if (this.removed > 1) {
            this.jspCompiler.removeGeneratedFiles();
            if (this.rctxt != null) {
                this.rctxt.removeWrapper(this.jspUri);
            }
        }
        ++this.removed;
    }

    public boolean isRemoved() {
        return this.removed > 1;
    }

    public void compile() throws Jsp2EngineException, FileNotFoundException {
        this.createCompiler();
        try {
            this.jspCompiler.compile();
            this.jsw.setReload(true);
            this.jsw.setCompilationException(null);
        }
        catch (Jsp2EngineException ex) {
            this.jsw.setCompilationException(ex);
            throw ex;
        }
        catch (Exception ex) {
            Jsp2EngineException je = new Jsp2EngineException(Localizer.getMessage("jsp.error.unable.compile"), ex);
            this.jsw.setCompilationException(je);
            throw je;
        }
    }

    public Class load() throws Jsp2EngineException {
        try {
            String name = this.isTagFile() ? this.tagInfo.getTagClassName() : this.getServletPackageName() + "." + this.getServletClassName();
            this.servletClass = this.getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException cex) {
            throw new Jsp2EngineException(Localizer.getMessage("jsp.error.unable.load"), cex);
        }
        catch (Exception ex) {
            throw new Jsp2EngineException(Localizer.getMessage("jsp.error.unable.compile"), ex);
        }
        this.removed = 0;
        return this.servletClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeOutputDir() {
        Object object = outputDirLock;
        synchronized (object) {
            File outDirFile = new File(this.outputDir);
            outDirFile.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeJspWorkDir() {
        Object object = outputDirLock;
        synchronized (object) {
            File workDirFile = new File(this.jspWorkDir);
            workDirFile.mkdirs();
        }
    }

    private void createOutputDir() {
        String path = null;
        if (this.isTagFile()) {
            String tagName = this.tagInfo.getTagClassName();
            path = tagName.replace('.', '/');
            path = path.substring(0, path.lastIndexOf(47));
            path = "jeus_tagwork/" + path;
        } else {
            path = this.getServletPackageName().replace('.', '/');
        }
        try {
            this.baseUrl = this.options.getOutDir().toURL();
            String outUrlString = this.baseUrl.toString();
            outUrlString = outUrlString.endsWith("/") ? outUrlString + path : outUrlString + '/' + path;
            URL outUrl = new URL(outUrlString);
            this.outputDir = outUrl.getFile() + File.separator;
            this.makeOutputDir();
        }
        catch (Exception e) {
            throw new IllegalStateException("No output directory: " + e.getMessage());
        }
    }

    private void createJspWorkDir() {
        String path = null;
        if (this.isTagFile()) {
            String tagName = this.tagInfo.getTagClassName();
            path = tagName.replace('.', '/');
            path = path.substring(0, path.lastIndexOf(47));
            path = "jeus_tagwork/" + path;
        } else {
            path = this.getServletPackageName().replace('.', '/');
        }
        try {
            this.baseUrl = this.options.getScratchDir().toURL();
            String outUrlString = this.baseUrl.toString();
            outUrlString = outUrlString.endsWith("/") ? outUrlString + path : outUrlString + '/' + path;
            URL outUrl = new URL(outUrlString);
            this.jspWorkDir = outUrl.getFile() + File.separator;
            this.makeJspWorkDir();
        }
        catch (Exception e) {
            throw new IllegalStateException("No output directory: " + e.getMessage());
        }
    }

    private static final boolean isPathSeparator(char c) {
        return c == '/' || c == '\\';
    }

    private static final String canonicalURI(String s) throws Jsp2EngineException {
        if (s == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int len = s.length();
        int pos = 0;
        block4: while (pos < len) {
            char c = s.charAt(pos);
            if (JspCompilationContext.isPathSeparator(c)) {
                while (pos + 1 < len && JspCompilationContext.isPathSeparator(s.charAt(pos + 1))) {
                    ++pos;
                }
                if (pos + 1 < len && s.charAt(pos + 1) == '.') {
                    if (pos + 2 >= len) break;
                    switch (s.charAt(pos + 2)) {
                        case '/': 
                        case '\\': {
                            pos += 2;
                            continue block4;
                        }
                        case '.': {
                            if (pos + 3 >= len || !JspCompilationContext.isPathSeparator(s.charAt(pos + 3))) break;
                            pos += 3;
                            int separatorPos = result.length() - 1;
                            if (separatorPos < 0) {
                                throw new Jsp2EngineException(Localizer.getMessage("jsp.error.badpath", s));
                            }
                            while (separatorPos >= 0 && !JspCompilationContext.isPathSeparator(result.charAt(separatorPos))) {
                                --separatorPos;
                            }
                            if (separatorPos < 0) continue block4;
                            result.setLength(separatorPos);
                            continue block4;
                        }
                    }
                }
            }
            result.append(c);
            ++pos;
        }
        return result.toString();
    }

    public JspConfig getJspConfig() {
        return this.jspConfig;
    }

    public void setJspConfig(JspConfig jspConfig) {
        this.jspConfig = jspConfig;
    }

    public void setUseSameName() {
        this.useSameName = true;
        this.basePackageName = "";
    }

    public void resetJspUri(String jspUri) throws Jsp2EngineException {
        this.derivedPackageName = null;
        this.classFileName = null;
        this.className = null;
        this.classPath = null;
        this.servletClass = null;
        this.servletJavaFileName = null;
        this.outputDir = null;
        this.jspUri = JspCompilationContext.canonicalURI(jspUri);
        this.baseURI = jspUri.substring(0, jspUri.lastIndexOf(47) + 1);
        if (this.baseURI == null || "".equals(this.baseURI)) {
            this.baseURI = "/";
        } else if (this.baseURI.charAt(0) != '/') {
            this.baseURI = "/" + this.baseURI;
        }
        if (this.baseURI.charAt(this.baseURI.length() - 1) != '/') {
            this.baseURI = this.baseURI + '/';
        }
        this.tagFileJarUrls = new Hashtable();
        this.basePackageName = "jeus_jspwork";
    }
}

