/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp2.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import jeus.servlet.common.WebContainerManager;
import jeus.servlet.engine.Context;
import jeus.servlet.jsp.compiler.JavaCompiler;
import jeus.servlet.jsp.compiler.JavacJavaCompiler;
import jeus.servlet.jsp.compiler.JspCompileException;
import jeus.servlet.jsp.compiler.SunJavaCompiler;
import jeus.servlet.jsp.compiler.SunJavaCompiler2;
import jeus.servlet.jsp2.Jsp2EngineException;
import jeus.servlet.jsp2.JspCompilationContext;
import jeus.servlet.jsp2.Options;
import jeus.servlet.jsp2.compiler.BeanRepository;
import jeus.servlet.jsp2.compiler.Collector;
import jeus.servlet.jsp2.compiler.ELFunctionMapper;
import jeus.servlet.jsp2.compiler.ErrorDispatcher;
import jeus.servlet.jsp2.compiler.Generator;
import jeus.servlet.jsp2.compiler.JspConfig;
import jeus.servlet.jsp2.compiler.JspUtil;
import jeus.servlet.jsp2.compiler.Node;
import jeus.servlet.jsp2.compiler.PageInfo;
import jeus.servlet.jsp2.compiler.ParserController;
import jeus.servlet.jsp2.compiler.ScriptingVariabler;
import jeus.servlet.jsp2.compiler.ServletWriter;
import jeus.servlet.jsp2.compiler.SmapUtil;
import jeus.servlet.jsp2.compiler.TagFileProcessor;
import jeus.servlet.jsp2.compiler.TagPluginManager;
import jeus.servlet.jsp2.compiler.TextOptimizer;
import jeus.servlet.jsp2.compiler.Validator;
import jeus.servlet.jsp2.servlet.JspServletWrapper;
import jeus.servlet.jsp2.util.SystemLogHandler;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusBootstrapProperties;
import jeus.util.JeusRootClassLoader;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer5;
import jeus.util.message.JeusMessage_WebContainer5_4;

public class Compiler {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.jsp");
    private static final String JAVAC_CLASS1 = "sun.tools.javac.Main";
    private static final String JAVAC_CLASS2 = "com.sun.tools.javac.Main";
    private static final String JAVAC = "javac";
    private String defaultJavaCompiler;
    static Object javacLock = new Object();
    protected JspCompilationContext ctxt;
    private ErrorDispatcher errDispatcher;
    private PageInfo pageInfo;
    private JspServletWrapper jsw;
    private TagFileProcessor tfp;
    protected Options options;
    protected Node.Nodes pageNodes;

    public Compiler(JspCompilationContext ctxt) {
        this(ctxt, null);
    }

    public Compiler(JspCompilationContext ctxt, JspServletWrapper jsw) {
        this.jsw = jsw;
        this.ctxt = ctxt;
        this.options = ctxt.getOptions();
        if (jsw != null) {
            this.initJavaCompiler(WebContainerManager.STANDALONE_MODE);
        }
    }

    private String[] generateJava() throws Exception {
        String[] smapStr = null;
        long t1 = System.currentTimeMillis();
        this.pageInfo = new PageInfo(new BeanRepository(this.ctxt.getClassLoader(), this.errDispatcher), this.ctxt.getJspFile());
        JspConfig jspConfig = this.options.getJspConfig();
        JspConfig.JspProperty jspProperty = jspConfig.findJspProperty(this.ctxt.getJspFile());
        this.pageInfo.setELIgnored(JspUtil.booleanValue(jspProperty.isELIgnored()));
        this.pageInfo.setScriptingInvalid(JspUtil.booleanValue(jspProperty.isScriptingInvalid()));
        this.pageInfo.setTrimDirectiveWhitespaces(JspUtil.booleanValue(jspProperty.getTrimSpaces()));
        this.pageInfo.setDeferredSyntaxAllowedAsLiteral(JspUtil.booleanValue(jspProperty.getPoundAllowed()));
        if (jspProperty.getIncludePrelude() != null) {
            this.pageInfo.setIncludePrelude(jspProperty.getIncludePrelude());
        }
        if (jspProperty.getIncludeCoda() != null) {
            this.pageInfo.setIncludeCoda(jspProperty.getIncludeCoda());
        }
        String javaFileName = this.ctxt.getServletJavaFileName();
        ServletWriter writer = null;
        try {
            String javaEncoding = this.ctxt.getOptions().getJavaEncoding();
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter((OutputStream)new FileOutputStream(javaFileName), javaEncoding);
            }
            catch (UnsupportedEncodingException ex) {
                this.errDispatcher.jspError("jsp.error.needAlternateJavaEncoding", javaEncoding);
            }
            writer = new ServletWriter(new PrintWriter(osw));
            this.ctxt.setWriter(writer);
            JspUtil.resetTemporaryVariableName();
            ParserController parserCtl = new ParserController(this.ctxt, this);
            this.pageNodes = parserCtl.parse(this.ctxt.getJspFile());
            if (this.ctxt.isPrototypeMode()) {
                Generator.generate(writer, this, this.pageNodes);
                writer.close();
                writer = null;
                String[] stringArray = null;
                return stringArray;
            }
            Validator.validate(this, this.pageNodes);
            long t2 = System.currentTimeMillis();
            Collector.collect(this, this.pageNodes);
            this.tfp = new TagFileProcessor();
            this.tfp.loadTagFiles(this, this.pageNodes);
            long t3 = System.currentTimeMillis();
            ScriptingVariabler.set(this.pageNodes, this.errDispatcher);
            TagPluginManager tagPluginManager = this.options.getTagPluginManager();
            tagPluginManager.apply(this.pageNodes, this.errDispatcher, this.pageInfo);
            TextOptimizer.concatenate(this, this.pageNodes);
            ELFunctionMapper.map(this, this.pageNodes);
            Generator.generate(writer, this, this.pageNodes);
            writer.close();
            writer = null;
            this.ctxt.setWriter(null);
            long t4 = System.currentTimeMillis();
        }
        catch (Exception e) {
            if (writer != null) {
                try {
                    writer.close();
                    writer = null;
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            new File(javaFileName).delete();
            throw e;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e2) {}
            }
        }
        if (!this.options.isSmapSuppressed()) {
            smapStr = SmapUtil.generateSmap(this.ctxt, this.pageNodes);
        }
        this.tfp.removeProtoTypeFiles(this.ctxt.getClassFileName());
        return smapStr;
    }

    private String getCompileClassPath(String classpath) {
        String systemClassPath = null;
        try {
            systemClassPath = JeusRootClassLoader.getRootClassPaths(((Context)this.ctxt.getServletContext()).getContextLoader().getParentClassLoader());
        }
        catch (Exception e) {
            systemClassPath = JeusBootstrapProperties.JEUS_HOME + File.separator + "lib" + File.separator + "system" + File.separator + "javaee.jar";
            systemClassPath = systemClassPath + File.pathSeparator + JeusBootstrapProperties.JEUS_HOME + File.separator + "lib" + File.separator + "system" + File.separator + "jeus.jar";
        }
        return systemClassPath + System.getProperty("path.separator") + classpath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateClass(String[] smap) throws FileNotFoundException, Jsp2EngineException, Exception {
        StringBuffer errorReport;
        String javaFileName;
        block13: {
            long t1 = System.currentTimeMillis();
            String javaEncoding = this.ctxt.getOptions().getJavaEncoding();
            javaFileName = this.ctxt.getServletJavaFileName();
            String classpath = this.getCompileClassPath(this.ctxt.getClassPath());
            String sep = System.getProperty("path.separator");
            errorReport = new StringBuffer();
            StringBuffer info = new StringBuffer();
            info.append("Compile: javaFileName=" + javaFileName + "\n");
            info.append("    classpath=" + classpath + "\n");
            SystemLogHandler.setThread();
            jeus.servlet.jsp.JspConfig jspConfig = this.ctxt.getJspConfig();
            String compileOutputDir = jspConfig.getCompileOutputDir();
            if (this.ctxt.isTagFile()) {
                compileOutputDir = compileOutputDir + "/" + "jeus_tagwork";
            }
            String compileOption = jspConfig.getCompileOption();
            JavaCompiler compiler = this.getCompiler(classpath, javaEncoding, compileOutputDir, compileOption, javaFileName);
            try {
                if (this.ctxt.getOptions().getFork()) {
                    compiler.compile();
                    break block13;
                }
                Object object = javacLock;
                synchronized (object) {
                    compiler.compile();
                }
            }
            catch (Throwable t) {
                if (t instanceof JspCompileException) {
                    throw (JspCompileException)((Object)t);
                }
                throw new JspCompileException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5350, (Object)javaFileName), t);
            }
        }
        String errorCapture = SystemLogHandler.unsetThread();
        if (errorCapture != null) {
            errorReport.append(System.getProperty("line.separator"));
            errorReport.append(errorCapture);
        }
        if (!this.ctxt.keepGenerated()) {
            File javaFile = new File(javaFileName);
            javaFile.delete();
        }
        long t2 = System.currentTimeMillis();
        if (this.ctxt.isPrototypeMode()) {
            return;
        }
        if (!this.options.isSmapSuppressed()) {
            SmapUtil.installSmap(smap);
        }
        if (this.jsw != null && this.jsw.getServletClassLastModifiedTime() <= 0L) {
            File targetFile = new File(this.ctxt.getClassFileName());
            this.jsw.setServletClassLastModifiedTime(targetFile.lastModified());
        }
    }

    public void compile() throws FileNotFoundException, Jsp2EngineException, Exception {
        this.compile(true);
    }

    public void compile(boolean compileClass) throws FileNotFoundException, Jsp2EngineException, Exception {
        this.compile(compileClass, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void compile(boolean compileClass, boolean jspcMode) throws FileNotFoundException, Jsp2EngineException, Exception {
        if (this.errDispatcher == null) {
            this.errDispatcher = new ErrorDispatcher(jspcMode);
        }
        try {
            String[] smap = this.generateJava();
            if (compileClass) {
                this.generateClass(smap);
            }
            Object var5_4 = null;
            if (this.tfp != null) {
                this.tfp.removeProtoTypeFiles(null);
            }
            this.tfp = null;
            this.errDispatcher = null;
            this.pageInfo = null;
            this.pageNodes = null;
            if (this.ctxt.getWriter() == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.tfp != null) {
                this.tfp.removeProtoTypeFiles(null);
            }
            this.tfp = null;
            this.errDispatcher = null;
            this.pageInfo = null;
            this.pageNodes = null;
            if (this.ctxt.getWriter() == null) throw throwable;
            this.ctxt.getWriter().close();
            this.ctxt.setWriter(null);
            throw throwable;
        }
        this.ctxt.getWriter().close();
        this.ctxt.setWriter(null);
    }

    public boolean isOutDated() {
        return this.isOutDated(true);
    }

    public boolean isOutDated(boolean checkClass) {
        String jsp = this.ctxt.getJspFile();
        if (this.jsw != null && this.ctxt.getOptions().getModificationTestInterval() > 0) {
            if (this.jsw.getLastModificationTest() + (long)(this.ctxt.getOptions().getModificationTestInterval() * 1000) > System.currentTimeMillis()) {
                return false;
            }
            this.jsw.setLastModificationTest(System.currentTimeMillis());
        }
        long jspRealLastModified = 0L;
        try {
            URL jspUrl = this.ctxt.getResource(jsp);
            if (jspUrl == null) {
                this.ctxt.incrementRemoved();
                return false;
            }
            URLConnection uc = jspUrl.openConnection();
            jspRealLastModified = uc.getLastModified();
            uc.getInputStream().close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        long targetLastModified = 0L;
        File targetFile = checkClass ? new File(this.ctxt.getClassFileName()) : new File(this.ctxt.getServletJavaFileName());
        if (!targetFile.exists()) {
            return true;
        }
        targetLastModified = targetFile.lastModified();
        if (checkClass && this.jsw != null) {
            this.jsw.setServletClassLastModifiedTime(targetLastModified);
        }
        if (targetLastModified < jspRealLastModified) {
            return true;
        }
        if (this.jsw == null) {
            return false;
        }
        List depends = this.jsw.getDependants();
        if (depends == null) {
            return false;
        }
        for (String include : depends) {
            try {
                URL includeUrl = this.ctxt.getResource(include);
                if (includeUrl == null) {
                    return true;
                }
                URLConnection includeUconn = includeUrl.openConnection();
                long includeLastModified = includeUconn.getLastModified();
                includeUconn.getInputStream().close();
                if (includeLastModified <= targetLastModified) continue;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }
        return false;
    }

    public ErrorDispatcher getErrorDispatcher() {
        return this.errDispatcher;
    }

    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public JspCompilationContext getCompilationContext() {
        return this.ctxt;
    }

    public void removeGeneratedFiles() {
        try {
            String classFileName = this.ctxt.getClassFileName();
            if (classFileName != null) {
                File classFile = new File(classFileName);
                classFile.delete();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String javaFileName = this.ctxt.getServletJavaFileName();
            if (javaFileName != null) {
                File javaFile = new File(javaFileName);
                javaFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeGeneratedClassFiles() {
        try {
            String classFileName = this.ctxt.getClassFileName();
            if (classFileName != null) {
                File classFile = new File(classFileName);
                classFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initJavaCompiler(boolean standaloneMode) {
        jeus.servlet.jsp.JspConfig jspConfig = this.ctxt.getJspConfig();
        String userDefault = null;
        if (jspConfig != null) {
            userDefault = jspConfig.getJavaCompiler();
        }
        Class<?> sunJavac = null;
        this.defaultJavaCompiler = null;
        if (userDefault != null) {
            if (userDefault.startsWith(JAVAC)) {
                this.defaultJavaCompiler = JAVAC;
            } else if (userDefault.startsWith("sun.tools.javac")) {
                try {
                    sunJavac = standaloneMode ? Class.forName(JAVAC_CLASS1) : JeusRootClassLoader.loader.loadClass(JAVAC_CLASS1);
                    this.defaultJavaCompiler = JAVAC_CLASS1;
                }
                catch (ClassNotFoundException fnfe) {
                    this.defaultJavaCompiler = null;
                }
            } else if (userDefault.startsWith("com.sun.tools.javac")) {
                try {
                    sunJavac = standaloneMode ? Class.forName(JAVAC_CLASS2) : JeusRootClassLoader.loader.loadClass(JAVAC_CLASS2);
                    this.defaultJavaCompiler = JAVAC_CLASS2;
                    if (SunJavaCompiler2.method141 == null && SunJavaCompiler2.method13 == null) {
                        this.defaultJavaCompiler = null;
                    }
                }
                catch (ClassNotFoundException fnfe) {
                    this.defaultJavaCompiler = null;
                }
            }
        }
        if (this.defaultJavaCompiler == null) {
            try {
                sunJavac = standaloneMode ? Class.forName(JAVAC_CLASS2) : JeusRootClassLoader.loader.loadClass(JAVAC_CLASS2);
                this.defaultJavaCompiler = JAVAC_CLASS2;
            }
            catch (ClassNotFoundException fnfe) {
                try {
                    sunJavac = standaloneMode ? Class.forName(JAVAC_CLASS1) : JeusRootClassLoader.loader.loadClass(JAVAC_CLASS1);
                    this.defaultJavaCompiler = JAVAC_CLASS1;
                }
                catch (ClassNotFoundException fnfe2) {
                    this.defaultJavaCompiler = JAVAC;
                }
            }
        }
        if (logger.isLoggable(JeusMessage_WebContainer5_4._5499_LEVEL)) {
            logger.log(JeusMessage_WebContainer5_4._5499_LEVEL, JeusMessage_WebContainer5_4._5499, (Object)this.defaultJavaCompiler);
        }
    }

    public JavaCompiler getCompiler(String classpath, String encoding, String outdir, String opt, String src) {
        JavaCompiler compiler = null;
        String fs = System.getProperty("path.separator");
        compiler = this.defaultJavaCompiler.equals(JAVAC) ? (fs.startsWith("/") ? new JavacJavaCompiler(classpath, encoding, outdir, opt, src) : new JavacJavaCompiler("\"" + classpath + "\"", encoding, outdir, opt, src)) : (this.defaultJavaCompiler.equals(JAVAC_CLASS1) ? new SunJavaCompiler(classpath, encoding, outdir, opt, src) : (this.defaultJavaCompiler.equals(JAVAC_CLASS2) ? new SunJavaCompiler2(classpath, encoding, outdir, opt, src) : (fs.startsWith("/") ? new JavacJavaCompiler(classpath, encoding, outdir, opt, src) : new JavacJavaCompiler("\"" + classpath + "\"", encoding, outdir, opt, src))));
        return compiler;
    }
}

