/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp2.compiler;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UTFDataFormatException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Stack;
import java.util.jar.JarFile;
import jeus.servlet.jsp2.Jsp2EngineException;
import jeus.servlet.jsp2.JspCompilationContext;
import jeus.servlet.jsp2.compiler.Compiler;
import jeus.servlet.jsp2.compiler.ErrorDispatcher;
import jeus.servlet.jsp2.compiler.JspConfig;
import jeus.servlet.jsp2.compiler.JspDocumentParser;
import jeus.servlet.jsp2.compiler.JspReader;
import jeus.servlet.jsp2.compiler.JspUtil;
import jeus.servlet.jsp2.compiler.Mark;
import jeus.servlet.jsp2.compiler.Node;
import jeus.servlet.jsp2.compiler.Parser;
import jeus.servlet.jsp2.compiler.TagConstants;
import jeus.servlet.jsp2.xmlparser.XMLEncodingDetector;
import jeus.servlet.property.WebProperties;
import org.xml.sax.Attributes;

class ParserController
implements TagConstants {
    private static final String CHARSET = "charset=";
    private JspCompilationContext ctxt;
    private Compiler compiler;
    private ErrorDispatcher err;
    private boolean isXml;
    private Stack baseDirStack = new Stack();
    private boolean isEncodingSpecifiedInProlog;
    private boolean hasBom;
    private String sourceEnc;
    private boolean isDefaultPageEncoding;
    private boolean isTagFile;
    private boolean directiveOnly;

    public ParserController(JspCompilationContext ctxt, Compiler compiler) {
        this.ctxt = ctxt;
        this.compiler = compiler;
        this.err = compiler.getErrorDispatcher();
    }

    public JspCompilationContext getJspCompilationContext() {
        return this.ctxt;
    }

    public Compiler getCompiler() {
        return this.compiler;
    }

    public Node.Nodes parse(String inFileName) throws FileNotFoundException, Jsp2EngineException, IOException {
        this.isTagFile = this.ctxt.isTagFile();
        this.directiveOnly = false;
        return this.doParse(inFileName, null, this.ctxt.getTagFileJarUrl());
    }

    public Node.Nodes parse(String inFileName, Node parent, URL jarFileUrl) throws FileNotFoundException, Jsp2EngineException, IOException {
        return this.doParse(inFileName, parent, jarFileUrl);
    }

    public Node.Nodes parseTagFileDirectives(String inFileName) throws FileNotFoundException, Jsp2EngineException, IOException {
        boolean isTagFileSave = this.isTagFile;
        boolean directiveOnlySave = this.directiveOnly;
        this.isTagFile = true;
        this.directiveOnly = true;
        Node.Nodes page = this.doParse(inFileName, null, (URL)this.ctxt.getTagFileJarUrls().get(inFileName));
        this.directiveOnly = directiveOnlySave;
        this.isTagFile = isTagFileSave;
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node.Nodes doParse(String inFileName, Node parent, URL jarFileUrl) throws FileNotFoundException, Jsp2EngineException, IOException {
        Node.Nodes parsedPage = null;
        this.isEncodingSpecifiedInProlog = false;
        this.isDefaultPageEncoding = false;
        this.hasBom = false;
        JarFile jarFile = this.getJarFile(jarFileUrl);
        String absFileName = this.resolveFileName(inFileName);
        String jspConfigPageEnc = this.getJspConfigPageEncoding(absFileName);
        String parentEncoding = null;
        if (parent != null && jspConfigPageEnc == null && !WebProperties.J2EE_COMPATIBLE.value) {
            if (parent instanceof Node.Root) {
                parentEncoding = ((Node.Root)parent).getPageEncoding();
            } else {
                Node.Root root = parent.getRoot();
                if (root != null) {
                    parentEncoding = root.getPageEncoding();
                }
            }
        }
        this.determineSyntaxAndEncoding(absFileName, jarFile, jspConfigPageEnc, parentEncoding);
        if (parent != null) {
            this.compiler.getPageInfo().addDependant(absFileName);
        }
        this.comparePageEncodings(jspConfigPageEnc);
        if (this.isXml) {
            parsedPage = JspDocumentParser.parse(this, absFileName, jarFile, parent, this.isTagFile, this.directiveOnly, this.sourceEnc, jspConfigPageEnc, this.isEncodingSpecifiedInProlog);
        } else {
            InputStreamReader inStreamReader = null;
            try {
                inStreamReader = JspUtil.getReader(absFileName, this.sourceEnc, jarFile, this.ctxt, this.err);
                JspReader jspReader = new JspReader(this.ctxt, absFileName, this.sourceEnc, inStreamReader, this.err);
                parsedPage = Parser.parse(this, absFileName, jspReader, parent, this.isTagFile, this.directiveOnly, jarFileUrl, this.sourceEnc, jspConfigPageEnc, this.isDefaultPageEncoding, this.hasBom);
            }
            finally {
                if (inStreamReader != null) {
                    try {
                        inStreamReader.close();
                    }
                    catch (Exception any) {}
                }
            }
        }
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.baseDirStack.pop();
        return parsedPage;
    }

    private void comparePageEncodings(String jspConfigPageEnc) throws Jsp2EngineException {
        if (jspConfigPageEnc == null) {
            return;
        }
        if (!(!this.isXml || !this.isEncodingSpecifiedInProlog || jspConfigPageEnc.equals(this.sourceEnc) || jspConfigPageEnc.startsWith("UTF-16") && this.sourceEnc.startsWith("UTF-16"))) {
            this.err.jspError("jsp.error.prolog_config_encoding_mismatch", this.sourceEnc, jspConfigPageEnc);
        }
        if (!(!this.hasBom || jspConfigPageEnc.equals(this.sourceEnc) || jspConfigPageEnc.startsWith("UTF-16") && this.sourceEnc.startsWith("UTF-16"))) {
            this.err.jspError("jsp.error.bom_config_encoding_mismatch", this.sourceEnc, jspConfigPageEnc);
        }
    }

    private String getJspConfigPageEncoding(String absFileName) throws Jsp2EngineException {
        JspConfig jspConfig = this.ctxt.getOptions().getJspConfig();
        JspConfig.JspProperty jspProperty = jspConfig.findJspProperty(absFileName);
        return jspProperty.getPageEncoding();
    }

    private void determineSyntaxAndEncoding(String absFileName, JarFile jarFile, String jspConfigPageEnc, String parentEncoding) throws Jsp2EngineException, IOException {
        this.isXml = false;
        boolean isExternal = false;
        boolean revert = false;
        JspConfig jspConfig = this.ctxt.getOptions().getJspConfig();
        JspConfig.JspProperty jspProperty = jspConfig.findJspProperty(absFileName);
        if (jspProperty.isXml() != null) {
            this.isXml = JspUtil.booleanValue(jspProperty.isXml());
            isExternal = true;
        } else if (absFileName.endsWith(".jspx") || absFileName.endsWith(".tagx")) {
            this.isXml = true;
            isExternal = true;
        }
        if (isExternal && !this.isXml) {
            this.sourceEnc = jspConfigPageEnc;
            if (this.sourceEnc != null) {
                return;
            }
            this.sourceEnc = "ISO-8859-1";
        } else {
            Object[] ret = null;
            try {
                ret = XMLEncodingDetector.getEncoding(absFileName, jarFile, this.ctxt, this.err);
            }
            catch (UTFDataFormatException ex) {
                if (parentEncoding != null) {
                    ret = new Object[]{parentEncoding, new Boolean(false), new Boolean(false)};
                }
                throw ex;
            }
            this.sourceEnc = (String)ret[0];
            if (((Boolean)ret[1]).booleanValue()) {
                this.isEncodingSpecifiedInProlog = true;
            }
            if (ret[2] != null && ((Boolean)ret[2]).booleanValue()) {
                this.hasBom = true;
            }
            if (!this.isXml && this.sourceEnc.equals("UTF-8") && !this.hasBom) {
                this.sourceEnc = "ISO-8859-1";
                revert = true;
            }
        }
        if (this.isXml) {
            return;
        }
        JspReader jspReader = null;
        try {
            jspReader = new JspReader(this.ctxt, absFileName, this.sourceEnc, jarFile, this.err);
        }
        catch (FileNotFoundException ex) {
            throw new Jsp2EngineException(ex);
        }
        jspReader.setSingleFile(true);
        Mark startMark = jspReader.mark();
        if (!isExternal) {
            jspReader.reset(startMark);
            if (this.hasJspRoot(jspReader)) {
                this.isXml = true;
                if (revert) {
                    this.sourceEnc = "UTF-8";
                }
                return;
            }
            this.isXml = false;
        }
        if (!this.hasBom) {
            this.sourceEnc = jspConfigPageEnc;
        }
        if (this.sourceEnc == null) {
            this.sourceEnc = this.getPageEncodingForJspSyntax(jspReader, startMark);
            if (this.sourceEnc == null && parentEncoding != null) {
                this.sourceEnc = parentEncoding;
            }
            if (this.sourceEnc == null) {
                this.sourceEnc = "ISO-8859-1";
                this.isDefaultPageEncoding = true;
            }
        }
    }

    private String getPageEncodingForJspSyntax(JspReader jspReader, Mark startMark) throws Jsp2EngineException {
        String encoding = null;
        String saveEncoding = null;
        jspReader.reset(startMark);
        while (jspReader.skipUntil("<") != null) {
            if (jspReader.matches("%--")) {
                if (jspReader.skipUntil("--%>") != null) continue;
                break;
            }
            boolean isDirective = jspReader.matches("%@");
            if (isDirective) {
                jspReader.skipSpaces();
            } else {
                isDirective = jspReader.matches("jsp:directive.");
            }
            if (!isDirective || !jspReader.matches("tag ") && !jspReader.matches("page")) continue;
            jspReader.skipSpaces();
            Attributes attrs = Parser.parseAttributes(this, jspReader);
            encoding = this.getPageEncodingFromDirective(attrs, "pageEncoding");
            if (encoding != null) break;
            encoding = this.getPageEncodingFromDirective(attrs, "contentType");
            if (encoding == null) continue;
            saveEncoding = encoding;
        }
        if (encoding == null) {
            encoding = saveEncoding;
        }
        if (encoding == null && this.ctxt.getJspConfig().defaultPageEncoding != null) {
            encoding = this.ctxt.getJspConfig().defaultPageEncoding;
        }
        if (this.ctxt.getJspConfig().forcedPageEncoding != null) {
            encoding = this.ctxt.getJspConfig().forcedPageEncoding;
        }
        return encoding;
    }

    private String getPageEncodingFromDirective(Attributes attrs, String attrName) {
        int loc;
        String value = attrs.getValue(attrName);
        if (attrName.equals("pageEncoding")) {
            return value;
        }
        String contentType = value;
        String encoding = null;
        if (contentType != null && (loc = contentType.indexOf(CHARSET)) != -1) {
            encoding = contentType.substring(loc + CHARSET.length());
        }
        return encoding;
    }

    private String resolveFileName(String inFileName) {
        String fileName = inFileName.replace('\\', '/');
        boolean isAbsolute = fileName.startsWith("/");
        fileName = isAbsolute ? fileName : (String)this.baseDirStack.peek() + fileName;
        String baseDir = fileName.substring(0, fileName.lastIndexOf("/") + 1);
        this.baseDirStack.push(baseDir);
        return fileName;
    }

    private boolean hasJspRoot(JspReader reader) throws Jsp2EngineException {
        String xmlnsDecl;
        int c;
        Mark start = null;
        while ((start = reader.skipUntil("<")) != null && ((c = reader.nextChar()) == 33 || c == 63)) {
        }
        if (start == null) {
            return false;
        }
        Mark stop = reader.skipUntil(":root");
        if (stop == null) {
            return false;
        }
        String prefix = reader.getText(start, stop).substring(1);
        start = stop;
        stop = reader.skipUntil(">");
        if (stop == null) {
            return false;
        }
        String root = reader.getText(start, stop);
        int index = root.indexOf(xmlnsDecl = "xmlns:" + prefix);
        if (index == -1) {
            return false;
        }
        index += xmlnsDecl.length();
        while (index < root.length() && Character.isWhitespace(root.charAt(index))) {
            ++index;
        }
        if (index < root.length() && root.charAt(index) == '=') {
            ++index;
            while (index < root.length() && Character.isWhitespace(root.charAt(index))) {
                ++index;
            }
            if (index < root.length() && root.charAt(index++) == '\"' && root.regionMatches(index, "http://java.sun.com/JSP/Page", 0, "http://java.sun.com/JSP/Page".length())) {
                return true;
            }
        }
        return false;
    }

    private JarFile getJarFile(URL jarFileUrl) throws IOException {
        JarFile jarFile = null;
        if (jarFileUrl != null) {
            JarURLConnection conn = (JarURLConnection)jarFileUrl.openConnection();
            conn.setUseCaches(false);
            conn.connect();
            jarFile = conn.getJarFile();
        }
        return jarFile;
    }
}

