/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp2.servlet;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class JasperLoader
extends URLClassLoader {
    private PermissionCollection permissionCollection;
    private CodeSource codeSource;
    private String className;
    private ClassLoader parent;
    private SecurityManager securityManager;
    private PrivilegedLoadClass privLoadClass;

    public JasperLoader(URL[] urls, ClassLoader parent, PermissionCollection permissionCollection, CodeSource codeSource) {
        super(urls, parent);
        this.permissionCollection = permissionCollection;
        this.codeSource = codeSource;
        this.parent = parent;
        this.privLoadClass = new PrivilegedLoadClass();
        this.securityManager = System.getSecurityManager();
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    public Class loadClass(final String name, boolean resolve) throws ClassNotFoundException {
        int dot;
        Class clazz = null;
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (this.securityManager != null && (dot = name.lastIndexOf(46)) >= 0) {
            try {
                if (!"jeus.servlet.jsp2.runtime".equalsIgnoreCase(name.substring(0, dot))) {
                    this.securityManager.checkPackageAccess(name.substring(0, dot));
                }
            }
            catch (SecurityException se) {
                String error = "Security Violation, attempt to use Restricted Class: " + name;
                se.printStackTrace();
                throw new ClassNotFoundException(error);
            }
        }
        if (this.securityManager != null) {
            final ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(this.privLoadClass);
            try {
                clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return classLoader.loadClass(name);
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                Exception rootCause = ex.getException();
                if (rootCause instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)rootCause;
                }
                throw new ClassNotFoundException("JasperLoader", rootCause);
            }
        } else {
            clazz = this.parent.loadClass(name);
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public final PermissionCollection getPermissions(CodeSource codeSource) {
        return this.permissionCollection;
    }

    private class PrivilegedLoadClass
    implements PrivilegedAction {
        private PrivilegedLoadClass() {
        }

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

