/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.listener;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import jeus.service.library.ClassPathEntry;
import jeus.service.library.LibraryManager;
import jeus.service.library.LibraryNotFoundException;
import jeus.service.library.LibraryRef;
import jeus.servlet.deployment.descriptor.ListenerDescriptor;
import jeus.servlet.engine.Context;
import jeus.servlet.listener.ListenerWrapper;
import jeus.servlet.loader.ContextLoader;
import jeus.servlet.loader.WebAppContextSwitch;
import jeus.sessionmanager.SessionActivationListener;
import jeus.sessionmanager.SessionAttributeListener;
import jeus.sessionmanager.SessionListener;
import jeus.sessionmanager.session.Session;
import jeus.sessionmanager.session.WebSession;

public class ListenerManager
implements SessionListener,
SessionAttributeListener,
SessionActivationListener {
    private ContextLoader contextLoader;
    private Context context;
    private ArrayList listeners;
    private Object listenerLock = new Object();
    private Vector<String> listenerClasses;
    private Vector<String> tldListeners = new Vector();
    private Vector<String> webdotxmlListeners = new Vector();
    private static HashSet jsfListeners = new HashSet();
    private static List<String> jsf12Listeners;
    private static List<URL> jsf12Urls;

    public ListenerManager(Context context, ContextLoader contextLoader) {
        this.context = context;
        this.contextLoader = contextLoader;
        this.listeners = new ArrayList();
        this.listenerClasses = new Vector();
    }

    public void addListeners(ArrayList listenerDescriptors) {
        if (listenerDescriptors == null) {
            return;
        }
        for (int i = 0; i < listenerDescriptors.size(); ++i) {
            ListenerDescriptor desc = (ListenerDescriptor)listenerDescriptors.get(i);
            String className = desc.getListenerClass();
            if (this.webdotxmlListeners.contains(className)) continue;
            this.webdotxmlListeners.add(className);
        }
    }

    public void addTldListener(String className) {
        if (!this.tldListeners.contains(className)) {
            this.tldListeners.add(className);
        }
    }

    public void addListener(String className) {
        if (!this.listenerClasses.contains(className)) {
            this.listenerClasses.add(className);
        }
    }

    public void checkJsfListeners() {
        ArrayList<String> found = new ArrayList<String>();
        for (String className : this.tldListeners) {
            if (jsfListeners.contains(className)) {
                found.add(className);
                continue;
            }
            this.addListener(className);
        }
        for (String className : this.webdotxmlListeners) {
            if (jsfListeners.contains(className)) {
                found.add(className);
                continue;
            }
            this.addListener(className);
        }
        switch (found.size()) {
            case 0: {
                if (!this.context.isJsfApplication()) break;
                this.addJsf12Libs();
                this.addJsf12Listeners();
                break;
            }
            case 1: {
                this.addJsf12Libs();
                this.addListener((String)found.get(0));
                break;
            }
            default: {
                this.addJsf12Libs();
                this.addListener((String)found.get(0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.context == null) {
            return;
        }
        Object object = this.listenerLock;
        synchronized (object) {
            for (String className : this.listenerClasses) {
                ListenerWrapper wrapper = new ListenerWrapper(this.contextLoader, className);
                if (!wrapper.init()) continue;
                this.listeners.add(wrapper);
            }
        }
        ServletContextEvent event = new ServletContextEvent((ServletContext)this.context);
        this.fireContextInitializedEvent(event);
    }

    private void addJsf12Libs() {
        if (jsf12Urls == null) {
            jsf12Urls = new ArrayList<URL>();
            if (!this.context.getWebAppDesc().isWebApp_2_3() && !this.context.getWebAppDesc().isWebApp_2_4()) {
                LibraryManager libraryManager = LibraryManager.getInstance();
                libraryManager.refresh();
                LibraryRef ref = new LibraryRef("jsf", "1.2", null);
                try {
                    List<ClassPathEntry> entries = libraryManager.getClassPathEntries(ref);
                    if (entries != null) {
                        for (ClassPathEntry entry : entries) {
                            try {
                                jsf12Urls.add(new File(entry.getPath()).toURL());
                            }
                            catch (MalformedURLException e) {}
                        }
                    }
                }
                catch (LibraryNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        for (URL url : jsf12Urls) {
            this.contextLoader.addClassPath(url);
        }
    }

    private void addJsf12Listeners() {
        for (String className : jsf12Listeners) {
            this.addListener(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ServletContextEvent event = new ServletContextEvent((ServletContext)this.context);
        this.fireContextDestroyedEvent(event);
        if (this.listeners == null && this.listenerClasses == null) {
            return;
        }
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.listeners != null) {
                Iterator iter = this.listeners.iterator();
                while (iter.hasNext()) {
                    ListenerWrapper listenerWrapper = (ListenerWrapper)iter.next();
                    listenerWrapper.destroy();
                    iter.remove();
                }
                this.listeners = null;
            }
            if (this.listenerClasses != null) {
                this.listenerClasses.clear();
                this.listenerClasses = null;
            }
        }
        this.contextLoader = null;
        this.context = null;
    }

    public void fireContextInitializedEvent(ServletContextEvent e) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ListenerWrapper)this.listeners.get(i)).contextInitialized(e);
        }
    }

    public void fireContextDestroyedEvent(ServletContextEvent e) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ListenerWrapper)this.listeners.get(i)).contextDestroyed(e);
        }
    }

    public void fireContextAttributeAddedEvent(ServletContextAttributeEvent e) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ListenerWrapper)this.listeners.get(i)).contextAttributeAdded(e);
        }
    }

    public void fireContextAttributeRemovedEvent(ServletContextAttributeEvent e) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ListenerWrapper)this.listeners.get(i)).contextAttributeRemoved(e);
        }
    }

    public void fireContextAttributeReplacedEvent(ServletContextAttributeEvent e) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ListenerWrapper)this.listeners.get(i)).contextAttributeReplaced(e);
        }
    }

    public void fireSessionCreatedEvent(HttpSessionEvent e) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ListenerWrapper)this.listeners.get(i)).sessionCreated(e);
        }
    }

    public void fireSessionDestroyedEvent(HttpSessionEvent e) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ListenerWrapper)this.listeners.get(i)).sessionDestroyed(e);
        }
    }

    public void fireSessionAttributeAddedEvent(HttpSessionBindingEvent e) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ListenerWrapper)this.listeners.get(i)).sessionAttributeAdded(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRequestInitializedEvent(ServletRequestEvent e) {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        WebAppContextSwitch.preContextSwitch(this.contextLoader);
        try {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ListenerWrapper)this.listeners.get(i)).requestInitialized(e);
            }
        }
        finally {
            WebAppContextSwitch.postContextSwitch();
        }
    }

    public void fireRequestDestroyedEvent(ServletRequestEvent e) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ListenerWrapper)this.listeners.get(i)).requestDestroyed(e);
        }
    }

    public void fireRequestAttributeAddedEvent(ServletRequestAttributeEvent e) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ListenerWrapper)this.listeners.get(i)).requestAttributeAdded(e);
        }
    }

    public void fireRequestAttributeRemovedEvent(ServletRequestAttributeEvent e) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ListenerWrapper)this.listeners.get(i)).requestAttributeRemoved(e);
        }
    }

    public void fireRequestAttributeReplacedEvent(ServletRequestAttributeEvent e) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ListenerWrapper)this.listeners.get(i)).requestAttributeReplaced(e);
        }
    }

    public void fireSessionAttributeRemovedEvent(HttpSessionBindingEvent e) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ListenerWrapper)this.listeners.get(i)).sessionAttributeRemoved(e);
        }
    }

    public void fireSessionAttributeReplacedEvent(HttpSessionBindingEvent e) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ListenerWrapper)this.listeners.get(i)).sessionAttributeReplaced(e);
        }
    }

    public void fireSessionDidActivateEvent(HttpSessionEvent e) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ListenerWrapper)this.listeners.get(i)).sessionDidActivate(e);
        }
    }

    public void fireSessionWillPassivateEvent(HttpSessionEvent e) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ListenerWrapper)this.listeners.get(i)).sessionWillPassivate(e);
        }
    }

    public void notifySessionCreation(Session session) {
        if (session == null || !(session instanceof WebSession)) {
            return;
        }
        WebSession webSession = (WebSession)session;
        HttpSessionEvent hse = webSession.getHttpSessionEvent();
        if (hse != null) {
            this.fireSessionCreatedEvent(hse);
        }
    }

    public void notifySessionDestruction(Session session) {
        if (session == null || !(session instanceof WebSession)) {
            return;
        }
        WebSession webSession = (WebSession)session;
        HttpSessionEvent hse = webSession.getHttpSessionEvent();
        if (hse != null) {
            this.fireSessionDestroyedEvent(hse);
        }
    }

    public void notifySessionActivation(Session session) {
        if (session == null || !(session instanceof WebSession)) {
            return;
        }
        WebSession webSession = (WebSession)session;
        HttpSessionEvent hse = webSession.getHttpSessionEvent();
        if (hse != null) {
            this.fireSessionDidActivateEvent(hse);
        }
    }

    public void notifySessionPassivation(Session session) {
        if (session == null || !(session instanceof WebSession)) {
            return;
        }
        WebSession webSession = (WebSession)session;
        HttpSessionEvent hse = webSession.getHttpSessionEvent();
        if (hse != null) {
            this.fireSessionWillPassivateEvent(hse);
        }
    }

    public void notifyAttibuteAddition(Object param) {
        if (param == null || !(param instanceof HttpSessionBindingEvent)) {
            return;
        }
        HttpSessionBindingEvent hsbe = (HttpSessionBindingEvent)param;
        this.fireSessionAttributeAddedEvent(hsbe);
    }

    public void notifyAttibuteReplacement(Object param) {
        if (param == null || !(param instanceof HttpSessionBindingEvent)) {
            return;
        }
        HttpSessionBindingEvent hsbe = (HttpSessionBindingEvent)param;
        this.fireSessionAttributeReplacedEvent(hsbe);
    }

    public void notifyAttibuteRemoval(Object param) {
        if (param == null || !(param instanceof HttpSessionBindingEvent)) {
            return;
        }
        HttpSessionBindingEvent hsbe = (HttpSessionBindingEvent)param;
        this.fireSessionAttributeRemovedEvent(hsbe);
    }

    static {
        jsfListeners.add("org.apache.myfaces.webapp.StartupServletContextListener");
        jsfListeners.add("com.sun.faces.config.ConfigureListener");
        jsfListeners.add("com.sun.faces.config.GlassFishConfigureListener");
        jsf12Listeners = new ArrayList<String>();
        jsf12Listeners.add("com.sun.faces.config.ConfigureListener");
    }
}

