/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.loader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.instrument.IllegalClassFormatException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import javax.persistence.spi.ClassTransformer;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import jeus.ejb.util.EJBRootClassLoader;
import jeus.management.j2ee.servlet.ServletInfo;
import jeus.management.util.StringUtil;
import jeus.persistence.container.TransformableClassLoader;
import jeus.service.library.ClassPathEntry;
import jeus.service.library.LibraryManager;
import jeus.service.library.LibraryNotFoundException;
import jeus.service.library.LibraryRef;
import jeus.servlet.deployment.descriptor.ContextDescriptor;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.ServletConfigImpl;
import jeus.servlet.engine.ServletManager;
import jeus.servlet.engine.ServletWrapper;
import jeus.servlet.filter.FilterWrapper;
import jeus.servlet.jsp.JspServletWrapper;
import jeus.servlet.jsp.el.BeanInfoManager;
import jeus.servlet.jsp.resource.JspResourceProvider;
import jeus.servlet.jsp2.runtime.ResourceInjectorImpl;
import jeus.servlet.loader.ApplicationClassReleaser;
import jeus.servlet.loader.ClassEntry;
import jeus.servlet.loader.ClassLoadManager;
import jeus.servlet.loader.FilterReloader;
import jeus.servlet.loader.JspReloader;
import jeus.servlet.loader.JspResourceJspReloader;
import jeus.servlet.loader.ListenerReloader;
import jeus.servlet.loader.ServletReloader;
import jeus.servlet.loader.WebAppContextSwitch;
import jeus.servlet.property.ContextProperties;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer1;
import jeus.util.message.JeusMessage_WebContainer5_4;
import sun.misc.Resource;
import sun.misc.URLClassPath;

public final class ContextLoader
extends URLClassLoader
implements TransformableClassLoader {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.loader");
    private static String webinf_classes = "/WEB-INF/classes/";
    private static String webinf_lib = "/WEB-INF/lib/";
    private ClassLoadManager manager;
    private Context context;
    private ContextDescriptor desc;
    private Hashtable servlets;
    private URL baseURL;
    private String classPathString;
    private Servlet suspendServlet;
    private Servlet unavailableServlet;
    private ClassLoader parentClassLoader;
    private Hashtable loadedClasses;
    boolean relodable = false;
    private boolean checkOnDemand = false;
    private List<ClassTransformer> classTransformers;
    private ContextLoader transformerLoader;
    private URL[] base;
    private final Object modifiedLock = new Object();
    private static List<URL> jstl12Urls;

    ContextLoader(ClassLoadManager manager, URL[] base, URL baseURL, ClassLoader parent, Context context) {
        super(base, parent);
        this.base = base;
        this.manager = manager;
        this.baseURL = baseURL;
        this.context = context;
        this.desc = context.getContextDescriptor();
        this.servlets = new Hashtable(493);
        this.relodable = this.desc.isAutoReload();
        this.checkOnDemand = this.desc.isCheckOnDemand();
        this.parentClassLoader = parent;
        context.getVirtualHost().getContextGroup().addContextServlets(this.servlets);
        this.suspendServlet = context.getVirtualHost().getContextGroup().getContainerManager().getSuspendServlet();
        this.unavailableServlet = context.getVirtualHost().getContextGroup().getContainerManager().getUnavailableServlet();
        this.loadedClasses = new Hashtable(89);
        this.init2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init2() {
        Vector<String> libraries;
        String manifestClassPaths;
        String basePath = this.baseURL.getFile();
        if (!basePath.startsWith(File.separator)) {
            basePath = "/" + basePath;
        }
        try {
            URL classURL = new File(basePath + webinf_classes).toURL();
            this.addURL(classURL);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
        try {
            URL libURL = new File(basePath + webinf_lib).toURL();
            this.addURL(libURL);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
        if (this.context.getMBean() != null && (manifestClassPaths = this.context.getMBean().getManifestClassPaths()) != null) {
            try {
                Vector<String> pathList = StringUtil.parseClasspathInManifest(manifestClassPaths);
                for (String path : pathList) {
                    URL libURL = new File(basePath + File.separator + ".." + File.separator + path).toURL();
                    this.addURL(libURL);
                }
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
        }
        String libPath = this.baseURL.getFile() + webinf_lib;
        File f = new File(libPath);
        Vector jars = new Vector();
        try {
            WebAppContextSwitch.preContextSwitch(this);
            if (this.manager != null) {
                this.manager.getJarFilesWithValidation(jars, f);
            }
        }
        finally {
            WebAppContextSwitch.postContextSwitch();
        }
        int size = jars.size();
        for (int i = 0; i < size; ++i) {
            try {
                String jarFile = (String)jars.elementAt(i);
                if (!jarFile.startsWith(File.separator)) {
                    jarFile = "/" + jarFile;
                }
                URL jarURL = new File(jarFile).toURL();
                this.addURL(jarURL);
                continue;
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
        }
        Vector addedClassPaths = this.context.getAddedClassPath();
        if (addedClassPaths != null && addedClassPaths.size() > 0) {
            for (int i = 0; i < addedClassPaths.size(); ++i) {
                String classPath = (String)addedClassPaths.elementAt(i);
                if (!classPath.startsWith(File.separator)) {
                    classPath = "/" + classPath;
                }
                try {
                    URL addedClassPathUrl = null;
                    addedClassPathUrl = new File(classPath).toURL();
                    this.addURL(addedClassPathUrl);
                    continue;
                }
                catch (MalformedURLException mue) {
                    mue.printStackTrace();
                }
            }
        }
        if ((libraries = this.context.getLibraries()) != null && libraries.size() > 0) {
            for (String library : libraries) {
                try {
                    this.addURL(new File(library).toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
        if (jstl12Urls == null) {
            jstl12Urls = new ArrayList<URL>();
            LibraryManager libraryManager = LibraryManager.getInstance();
            libraryManager.refresh();
            LibraryRef ref = new LibraryRef("jstl", "1.2", null);
            try {
                List<ClassPathEntry> entries = libraryManager.getClassPathEntries(ref);
                if (entries != null) {
                    for (ClassPathEntry entry : entries) {
                        try {
                            jstl12Urls.add(new File(entry.getPath()).toURL());
                        }
                        catch (MalformedURLException e) {}
                    }
                }
            }
            catch (LibraryNotFoundException e) {
                e.printStackTrace();
            }
        }
        for (URL url : jstl12Urls) {
            this.addURL(url);
        }
        this.updateClassPath();
    }

    public ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    final void destroy() {
        ApplicationClassReleaser.releaseApplicationClasses(this);
        BeanInfoManager.releaseBeanInfoManagers(this);
        this.context = null;
        this.manager = null;
        this.baseURL = null;
        this.context = null;
        this.servlets = null;
        this.suspendServlet = null;
        this.unavailableServlet = null;
        this.loadedClasses = null;
        this.parentClassLoader = null;
        if (this.classTransformers != null) {
            this.classTransformers.clear();
            this.classTransformers = null;
        }
        if (this.transformerLoader != null) {
            this.transformerLoader.destroy();
            this.transformerLoader = null;
        }
    }

    public void addClassPath(URL url) {
        this.addURL(url);
        this.updateClassPath();
    }

    public String getClassPath() {
        return this.classPathString;
    }

    private void updateClassPath() {
        StringBuffer sbuf = new StringBuffer();
        String ps = System.getProperty("path.separator");
        char fs = File.separatorChar;
        URL[] urls = this.getURLs();
        if (urls != null && urls.length > 0) {
            for (int i = 0; i < urls.length; ++i) {
                String path = urls[i].getFile();
                int start = 0;
                int end = path.length();
                if (path.endsWith("/")) {
                    end = path.length() - 1;
                }
                if (fs == '\\' && (path.startsWith("/") || path.startsWith("\\"))) {
                    start = 1;
                }
                if (start > 0 || end < path.length()) {
                    path = path.substring(start, end);
                }
                sbuf.append(path + ps);
            }
        }
        String cpath = sbuf.toString();
        cpath = cpath.replace('/', fs);
        this.classPathString = cpath = cpath.substring(0, cpath.length() - 1);
    }

    public Servlet getSuspendServlet() {
        return this.suspendServlet;
    }

    public Servlet getUnavailableServlet() {
        return this.unavailableServlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServletWrapper createServlet(String servletName, String className, Hashtable params, ServletManager manager, String _runAs) {
        ServletWrapper wrapper = (ServletWrapper)this.servlets.get(servletName);
        if (wrapper != null) {
            return wrapper;
        }
        ServletConfigImpl config = new ServletConfigImpl(this.context);
        config.setServletName(servletName);
        config.setServletClassName(className);
        config.setInitParams(params);
        ServletReloader reloader = new ServletReloader(this, className, config);
        String runAs = reloader.getRunAs();
        if (_runAs == null) {
            _runAs = runAs;
        } else {
            reloader.setRunAs(_runAs);
        }
        String _userPrincialName = null;
        if (_runAs != null) {
            this.desc = this.context.getContextDescriptor();
            _userPrincialName = this.desc.getUserPrincipalForRunAs(_runAs);
        }
        wrapper = new ServletWrapper(servletName, manager, reloader, _userPrincialName);
        Hashtable hashtable = this.servlets;
        synchronized (hashtable) {
            this.servlets.put(servletName, wrapper);
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JspServletWrapper createJsp(String jspName, String jspUri, Hashtable params, ServletManager manager, boolean samename) throws FileNotFoundException {
        JspServletWrapper wrapper = (JspServletWrapper)this.servlets.get(jspName);
        if (wrapper != null) {
            return wrapper;
        }
        String className = JspReloader.generateClassName(this.context, jspUri, samename);
        ServletConfigImpl config = new ServletConfigImpl(this.context);
        config.setServletName(jspName);
        config.setServletClassName(className);
        if (params == null) {
            params = new Hashtable<String, String>();
        }
        params.put("jeus.servlet.jsp.resource.injector", ResourceInjectorImpl.class.getName());
        config.setInitParams(params);
        JspReloader reloader = null;
        JspResourceProvider jspResourceProvider = this.context.getJspResourceProvider();
        if (jspResourceProvider != null) {
            reloader = new JspResourceJspReloader(this, className, jspUri, jspName, config, manager.getJspConfig(), manager.getJspEngine());
            ((JspResourceJspReloader)reloader).setJspResourceProvider(jspResourceProvider);
            if (logger.isLoggable(JeusMessage_WebContainer5_4._5695_LEVEL)) {
                logger.log(JeusMessage_WebContainer5_4._5695_LEVEL, JeusMessage_WebContainer5_4._5695, (Object)jspUri);
            }
        } else {
            reloader = new JspReloader(this, className, jspUri, jspName, config, manager.getJspConfig(), manager.getJspEngine());
        }
        wrapper = new JspServletWrapper(jspName, manager, reloader);
        Hashtable hashtable = this.servlets;
        synchronized (hashtable) {
            this.servlets.put(jspName, wrapper);
        }
        manager.addMapping(jspUri, wrapper);
        return wrapper;
    }

    public FilterWrapper createFilter(String filterName, String className, FilterConfig config) {
        FilterReloader reloader = new FilterReloader(this, className, config);
        return new FilterWrapper(filterName, reloader);
    }

    public ListenerReloader createListenerReloader(String className) {
        return new ListenerReloader(this, className);
    }

    public boolean suspendServlets() {
        Enumeration enum1 = this.servlets.elements();
        while (enum1.hasMoreElements()) {
            ServletWrapper wrapper = (ServletWrapper)enum1.nextElement();
            ServletReloader reloader = wrapper.getReloader();
            reloader.suspend();
        }
        return true;
    }

    public boolean resumeServlets() {
        Enumeration enum1 = this.servlets.elements();
        while (enum1.hasMoreElements()) {
            ServletWrapper wrapper = (ServletWrapper)enum1.nextElement();
            ServletReloader reloader = wrapper.getReloader();
            reloader.resume();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServlet(String name) {
        Hashtable hashtable = this.servlets;
        synchronized (hashtable) {
            ServletWrapper wrapper = (ServletWrapper)this.servlets.remove(name);
            if (wrapper != null) {
                ServletReloader reloader = wrapper.getReloader();
                reloader.destroy();
            }
        }
    }

    public Enumeration getServlets() {
        return this.servlets.elements();
    }

    public ServletWrapper getServlet(String name) {
        return (ServletWrapper)this.servlets.get(name);
    }

    public Context getContext() {
        return this.context;
    }

    public ServletInfo[] getAllServletInfo() {
        int size = this.servlets.size();
        if (size <= 0) {
            return new ServletInfo[0];
        }
        ServletInfo[] infos = new ServletInfo[size];
        Enumeration wrappers = this.servlets.elements();
        for (int i = 0; i < size; ++i) {
            ServletWrapper wrapper = (ServletWrapper)wrappers.nextElement();
            infos[i] = wrapper.getServletInfo();
        }
        return infos;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.context == null) {
            throw new ClassNotFoundException();
        }
        ContextProperties props = this.context.getContextProperties();
        if (props.SERVLET23_CLASSLOADER_MODEL.value || this.loadWebinfFirst()) {
            Class c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    c = this.getContext().isIsolatedStandalone() && this.parentClassLoader instanceof EJBRootClassLoader ? ((EJBRootClassLoader)this.parentClassLoader).loadClassIsolated(name, false) : this.parentClassLoader.loadClass(name);
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        return super.loadClass(name, resolve);
    }

    protected Class findClass(final String name) throws ClassNotFoundException {
        Class c;
        if (this.classTransformers == null) {
            Class<?> c2 = super.findClass(name);
            this.checkClass(name);
            return c2;
        }
        final URLClassPath ucp = new URLClassPath(super.getURLs());
        AccessControlContext acc = AccessController.getContext();
        try {
            c = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    String path = name.replace('.', '/').concat(".class");
                    Resource res = ucp.getResource(path, false);
                    if (res != null) {
                        try {
                            return ContextLoader.this.transformerDefineClass(name, res);
                        }
                        catch (IOException e) {
                            throw new ClassNotFoundException(name, e);
                        }
                    }
                    throw new ClassNotFoundException(name);
                }
            }, acc);
        }
        catch (PrivilegedActionException pae) {
            throw (ClassNotFoundException)pae.getException();
        }
        this.checkClass(name);
        return c;
    }

    private Class transformerDefineClass(String name, Resource res) throws IOException {
        int i = name.lastIndexOf(46);
        URL url = res.getCodeSourceURL();
        if (i != -1) {
            String pkgname = name.substring(0, i);
            Package pkg = this.getPackage(pkgname);
            Manifest man = res.getManifest();
            if (pkg != null) {
                if (pkg.isSealed()) {
                    if (!pkg.isSealed(url)) {
                        throw new SecurityException("sealing violation: package " + pkgname + " is sealed");
                    }
                } else if (man != null && this.isSealed(pkgname, man)) {
                    throw new SecurityException("sealing violation: can't seal package " + pkgname + ": already loaded");
                }
            } else if (man != null) {
                this.definePackage(pkgname, man, url);
            } else {
                this.definePackage(pkgname, null, null, null, null, null, null, null);
            }
        }
        byte[] bytes = res.getBytes();
        for (ClassTransformer transformer : this.classTransformers) {
            try {
                byte[] transformed = transformer.transform((ClassLoader)this, name, null, null, bytes);
                if (transformed == null) continue;
                bytes = transformed;
                if (!logger.isLoggable(Level.FINE)) continue;
                Object[] params = new String[]{transformer.getClass().getName(), name};
                logger.log(Level.FINE, "ClassTransformer {0} transformed {1} class", params);
            }
            catch (IllegalClassFormatException ex) {
                if (logger.isLoggable(JeusMessage_WebContainer1._2407_LEVEL)) {
                    logger.log(JeusMessage_WebContainer1._2407_LEVEL, JeusMessage_WebContainer1._2407, (Object)name, (Throwable)ex);
                }
                throw new ClassFormatError(ex.getMessage());
            }
        }
        return super.defineClass(name, bytes, 0, bytes.length);
    }

    private boolean isSealed(String name, Manifest man) {
        String path = name.replace('.', '/').concat("/");
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    protected void checkClass(String name) {
        if (!this.relodable) {
            return;
        }
        String resourceName = name.replace('.', '/') + ".class";
        URL resurl = this.getResource(resourceName);
        if (resurl != null && resurl.getProtocol().equalsIgnoreCase("file")) {
            File resfile = null;
            resfile = new File(resurl.getFile());
            ClassEntry entry = new ClassEntry(name, resfile);
            this.loadedClasses.put(name, entry);
        }
    }

    public URL getResource(String name) {
        ContextProperties props = this.context.getContextProperties();
        if (props.SERVLET23_CLASSLOADER_MODEL.value || this.loadWebinfFirst()) {
            URL url = null;
            url = super.findResource(name);
            if (url == null && this.parentClassLoader != null) {
                url = this.parentClassLoader.getResource(name);
            }
            return url;
        }
        return super.getResource(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modified() {
        Object object = this.modifiedLock;
        synchronized (object) {
            Enumeration enum1 = this.loadedClasses.elements();
            while (enum1.hasMoreElements()) {
                ClassEntry e = (ClassEntry)enum1.nextElement();
                if (!e.modified()) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean loadWebinfFirst() {
        return this.desc.isWebinfFirst();
    }

    public boolean isReloadable() {
        return this.relodable;
    }

    public boolean isCheckOnDemand() {
        return this.checkOnDemand;
    }

    public ClassLoader getNewTempClassLoader() {
        this.transformerLoader = new ContextLoader(this.manager, this.base, this.baseURL, this.parentClassLoader, this.context);
        return this.transformerLoader;
    }

    public synchronized void addTransformer(ClassTransformer transformer) {
        if (this.classTransformers == null) {
            this.classTransformers = new ArrayList<ClassTransformer>();
        }
        this.classTransformers.add(transformer);
    }
}

