/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.loader;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import jeus.servlet.loader.PrivateClassLoader;
import jeus.servlet.loader.PrivateReloader;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer1;

public class JspClassLoader
extends PrivateClassLoader {
    private String classDir;

    public JspClassLoader(ClassLoader parent, PrivateReloader reloader, String classDir, String className) {
        super(parent, reloader, className);
        this.classDir = classDir;
        if (!this.classDir.endsWith(File.separator)) {
            this.classDir = this.classDir + File.separator;
        }
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name == null) {
            return null;
        }
        Class<?> clazz = null;
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (name.equals(this.className) || name.startsWith(this.className) && name.indexOf("$") == this.className.length()) {
            clazz = this.findClass(name);
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        clazz = this.parent.loadClass(name);
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        byte[] data = null;
        try {
            data = this.loadJspClassBytes(name);
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer1._2205, (Object)name), ioe);
        }
        if (data == null) {
            throw new ClassNotFoundException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer1._2205, (Object)name));
        }
        Class<?> clazz = this.defineClass(name, data, 0, data.length);
        return clazz;
    }

    private byte[] loadJspClassBytes(String name) throws IOException {
        byte[] result = null;
        String classFileName = name.replace('.', File.separatorChar) + ".class";
        File file = new File(this.classDir + classFileName);
        if (!file.exists()) {
            return null;
        }
        FileInputStream in = new FileInputStream(file);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = in.read(buf)) != -1) {
            os.write(buf, 0, i);
        }
        in.close();
        os.close();
        result = os.toByteArray();
        return result;
    }

    synchronized PrivateClassLoader getNewClassLoader() {
        return new JspClassLoader(this.parent, this.reloader, this.classDir, this.className);
    }
}

