/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.loader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jeus.servlet.engine.ServletConfigImpl;
import jeus.servlet.jsp.JspConfig;
import jeus.servlet.jsp.JspEngine;
import jeus.servlet.jsp.resource.JspResourceProvider;
import jeus.servlet.loader.ContextLoader;
import jeus.servlet.loader.JspReloader;
import jeus.util.file.FileUtils;
import jeus.util.message.JeusMessage_WebContainer5_4;

public class JspResourceJspReloader
extends JspReloader {
    private boolean dirty = true;
    private JspResourceProvider resourceProvider;

    public JspResourceJspReloader(ContextLoader parent, String className, String jspURI, String jspServletName, ServletConfigImpl config, JspConfig jspConfig, JspEngine jspEngine) throws FileNotFoundException {
        super(parent, className, jspURI, jspServletName, config, jspConfig, jspEngine);
    }

    protected boolean[] jspModified() {
        block5: {
            if (!this.getJspFile().exists()) {
                this.dirty = true;
            }
            if (this.dirty && this.resourceProvider != null) {
                try {
                    File outFile = this.getJspFile();
                    outFile.getParentFile().mkdirs();
                    FileUtils.copy((InputStream)this.resourceProvider.getResource(this.getJspURI()), (OutputStream)new FileOutputStream(outFile));
                    this.dirty = false;
                    if (logger.isLoggable(JeusMessage_WebContainer5_4._5686_LEVEL)) {
                        logger.log(JeusMessage_WebContainer5_4._5686_LEVEL, JeusMessage_WebContainer5_4._5686, (Object[])new String[]{this.getJspURI(), outFile.getCanonicalPath()});
                    }
                }
                catch (IOException e) {
                    if (!logger.isLoggable(JeusMessage_WebContainer5_4._5692_LEVEL)) break block5;
                    logger.log(JeusMessage_WebContainer5_4._5692_LEVEL, JeusMessage_WebContainer5_4._5692, (Object)this.getJspURI(), (Throwable)e);
                }
            }
        }
        return super.jspModified();
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setJspResourceProvider(JspResourceProvider resourceProvider) {
        this.resourceProvider = resourceProvider;
    }
}

