/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.loader;

import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.ServletException;
import jeus.servlet.loader.ContextLoader;
import jeus.servlet.loader.PrivateClassLoader;
import jeus.servlet.loader.WebAnnotationProcessor;
import jeus.servlet.loader.WebAppContextSwitch;
import jeus.servlet.property.ContextProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.RemoteClassLoaderRepository;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer1;

public abstract class PrivateReloader {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.loader");
    protected ContextLoader contextLoader;
    private Hashtable refClasses;
    protected PrivateClassLoader classLoader;
    protected String className;
    protected Object instance;
    boolean unavailable;
    protected WebAnnotationProcessor annotationProcessor = null;
    protected String runAs = null;

    PrivateReloader(ContextLoader contextLoader, String className) {
        this.contextLoader = contextLoader;
        this.className = className;
        this.refClasses = new Hashtable();
        this.unavailable = false;
    }

    public ContextLoader getParent() {
        return this.contextLoader;
    }

    public String getClassName() {
        return this.className;
    }

    public Object getInstance() throws ServletException {
        boolean reloaded = this.tryReload(false);
        this.initInstance(this.instance);
        return this.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object initInstance(Object obj) throws ServletException {
        if (obj == null) {
            PrivateReloader privateReloader = this;
            synchronized (privateReloader) {
                if (this.instance == null) {
                    try {
                        WebAppContextSwitch.preContextSwitch(this.contextLoader);
                        try {
                            Class clazz = this.classLoader.loadClass();
                            obj = clazz.newInstance();
                            if (this.annotationProcessor != null) {
                                this.annotationProcessor.inject(obj);
                                this.annotationProcessor.invokePostConstruct(obj);
                            }
                            this.doInitInstance(obj);
                        }
                        finally {
                            WebAppContextSwitch.postContextSwitch();
                        }
                        this.instance = obj;
                    }
                    catch (ServletException se) {
                        throw se;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer1._2203, (Object)this.className), t);
                    }
                }
                obj = this.instance;
            }
        }
        return obj;
    }

    protected abstract void doInitInstance(Object var1) throws ServletException;

    protected abstract void doDestroyInstance();

    protected boolean tryReload(boolean jspRecompiled) {
        boolean reloaded = false;
        if (jspRecompiled) {
            this.doReload();
            reloaded = true;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("[PrivateReloader] reloaded - jspRecompiled == true");
            }
        }
        return reloaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReload() {
        PrivateReloader privateReloader = this;
        synchronized (privateReloader) {
            this.destroyInstance();
            this.destroyPrivateLoader();
            this.classLoader = this.createNewClassLoader();
            ContextProperties props = this.contextLoader.getContext().getContextProperties();
            if (props.ENFORCE_RELOADING_NATIVE_LIBRARIES.value) {
                System.gc();
                System.runFinalization();
            }
        }
    }

    protected PrivateClassLoader createNewClassLoader() {
        return new PrivateClassLoader(this.contextLoader, this, this.className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void destroyInstance() {
        WebAppContextSwitch.preContextSwitch(this.contextLoader);
        try {
            PrivateReloader privateReloader = this;
            synchronized (privateReloader) {
                if (this.instance != null) {
                    if (this.instance != null && this.annotationProcessor != null) {
                        try {
                            this.annotationProcessor.invokePreDestroy(this.instance);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        this.annotationProcessor = null;
                    }
                    this.doDestroyInstance();
                    this.instance = null;
                }
                RemoteClassLoaderRepository.removeRemoteClassLoaderRepository(Thread.currentThread().getContextClassLoader());
            }
        }
        finally {
            WebAppContextSwitch.postContextSwitch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void destroyPrivateLoader() {
        WebAppContextSwitch.preContextSwitch(this.contextLoader);
        try {
            PrivateReloader privateReloader = this;
            synchronized (privateReloader) {
                this.refClasses.clear();
                if (this.classLoader != null) {
                    this.classLoader.destroy();
                    this.classLoader = null;
                }
            }
        }
        finally {
            WebAppContextSwitch.postContextSwitch();
        }
    }

    public void destroy() {
        this.destroyInstance();
        this.destroyPrivateLoader();
        this.contextLoader = null;
    }

    protected void readClassAnnotation() {
        try {
            Class clazz = null;
            if (!this.contextLoader.getContext().isMetadataComplete()) {
                clazz = this.classLoader.loadClass();
            }
            this.annotationProcessor = new WebAnnotationProcessor(this.contextLoader, clazz);
            this.runAs = this.annotationProcessor.getRunAs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (NoClassDefFoundError ndf) {
            ndf.printStackTrace();
        }
    }
}

