/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.property;

import java.util.logging.Level;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.RequestProcessor;
import jeus.servlet.loader.WebAppContextSwitch;
import jeus.servlet.property.ContainerProperties;
import jeus.servlet.property.WebProperties;
import jeus.util.logging.JeusLogger;

public class PropertyUtil {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.property");
    private static ContainerProperties containerProperties = new ContainerProperties();

    private static Context getContext() {
        return WebAppContextSwitch.getCurrentWebContext();
    }

    private static WebProperties getThreadProperties() {
        Thread thread = Thread.currentThread();
        if (thread instanceof RequestProcessor) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Context is not available with thread[" + thread + "]. ContextGroup options will be used.");
            }
            return ((RequestProcessor)thread).getContextGroupProperties();
        }
        return containerProperties;
    }

    public static WebProperties getContextProperties() {
        Context context = PropertyUtil.getContext();
        if (context != null) {
            return context.getContextProperties();
        }
        return PropertyUtil.getThreadProperties();
    }

    public static WebProperties getVirtualHostProperties() {
        Context context = PropertyUtil.getContext();
        if (context != null) {
            return context.getVirtualHost().getVirtualHostProperties();
        }
        return PropertyUtil.getThreadProperties();
    }

    public static WebProperties getContextGroupProperties() {
        Context context = PropertyUtil.getContext();
        if (context != null) {
            return context.getVirtualHost().getContextGroup().getContextGroupProperties();
        }
        return PropertyUtil.getThreadProperties();
    }

    public static WebProperties getContainerProperties() {
        Context context = PropertyUtil.getContext();
        if (context != null) {
            return context.getVirtualHost().getContextGroup().getContainerManager().getContainerProperties();
        }
        return PropertyUtil.getThreadProperties();
    }

    static {
        containerProperties.init(null);
    }
}

