/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.reverseproxy;

import java.io.File;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeus.servlet.reverseproxy.ConfigParser;
import jeus.servlet.reverseproxy.ProxyFilter;
import jeus.servlet.reverseproxy.ServerChain;
import jeus.servlet.reverseproxy.UrlRewritingResponseWrapper;
import jeus.servlet.reverseproxy.model.Server;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer10;

public class RewriteFilter
implements Filter {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.proxy");
    private ServerChain serverChain;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (response.isCommitted()) {
            logger.log(JeusMessage_WebContainer10._10409_LEVEL, JeusMessage_WebContainer10._10409);
            return;
        }
        if (!(request instanceof HttpServletRequest)) {
            logger.log(JeusMessage_WebContainer10._10410_LEVEL, JeusMessage_WebContainer10._10410);
            return;
        }
        if (!(response instanceof HttpServletResponse)) {
            logger.log(JeusMessage_WebContainer10._10411_LEVEL, JeusMessage_WebContainer10._10411);
            return;
        }
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        Server server = this.serverChain.evaluate(httpRequest);
        if (server == null) {
            logger.log(JeusMessage_WebContainer10._10412_LEVEL, JeusMessage_WebContainer10._10412);
            filterChain.doFilter(request, response);
        } else {
            httpRequest.setAttribute(ProxyFilter.servername, (Object)server);
            String ownHostName = request.getServerName() + ":" + request.getServerPort();
            UrlRewritingResponseWrapper wrappedResponse = new UrlRewritingResponseWrapper(httpResponse, server, ownHostName, httpRequest.getContextPath(), this.serverChain);
            filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)wrappedResponse);
            wrappedResponse.processStream();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String data = filterConfig.getInitParameter("dataUrl");
        if (data == null) {
            throw new ServletException("dataUrl is required.");
        }
        try {
            File dataFile = new File(filterConfig.getServletContext().getRealPath(data));
            ConfigParser parser = new ConfigParser(dataFile);
            this.serverChain = parser.getServerChain();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        this.serverChain = null;
    }
}

