/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.reverseproxy;

import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import jeus.servlet.reverseproxy.model.Server;
import jeus.servlet.reverseproxy.model.ServerContainer;

public class ServerChain {
    private List serverContainers;

    public ServerChain(List serverContainers) {
        this.serverContainers = serverContainers;
    }

    protected List getServers() {
        return this.serverContainers;
    }

    protected Iterator getServerIterator() {
        return this.getServers().iterator();
    }

    public void addServer(Server theServer) {
        if (theServer == null) {
            throw new IllegalArgumentException("The rule cannot be null.");
        }
        this.getServers().add(theServer);
    }

    public Server evaluate(HttpServletRequest request) {
        Iterator itr = this.getServerIterator();
        ServerContainer currentContainer = null;
        boolean currentMatches = false;
        while (itr.hasNext() && !currentMatches) {
            currentContainer = (ServerContainer)itr.next();
            currentMatches = currentContainer.getRule().matches(request);
        }
        if (currentMatches) {
            return currentContainer.getServer(request);
        }
        return null;
    }

    public Server getServerMapped(String location) {
        Iterator itr = this.getServerIterator();
        Server match = null;
        while (itr.hasNext() && match == null) {
            ServerContainer container = (ServerContainer)itr.next();
            Server next = container.getServerMapped(location);
            if (next == null) continue;
            match = next;
        }
        return match;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(this.getClass().getName());
        buffer.append(": ");
        Iterator iter = this.getServerIterator();
        Server currentServer = null;
        while (iter.hasNext()) {
            currentServer = (Server)iter.next();
            buffer.append(currentServer);
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

