/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.reverseproxy.requesthandlers;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import jeus.servlet.reverseproxy.model.RequestHandler;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer10;

public abstract class RequestHandlerBase
implements RequestHandler {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.proxy");
    private static Set bannedHeaders = new HashSet();

    public abstract HttpURLConnection process(HttpServletRequest var1, String var2, String var3) throws IOException;

    protected void setHeaders(HttpURLConnection httpURLConnection, HttpServletRequest request) throws IOException {
        Enumeration headers = request.getHeaderNames();
        String connectionToken = request.getHeader("connection");
        while (headers.hasMoreElements()) {
            String name = (String)headers.nextElement();
            boolean isToken = connectionToken != null && name.equalsIgnoreCase(connectionToken);
            if (isToken || bannedHeaders.contains(name.toLowerCase())) continue;
            Enumeration value = request.getHeaders(name);
            while (value.hasMoreElements()) {
                httpURLConnection.setRequestProperty(name, (String)value.nextElement());
            }
        }
        this.setProxySpecificHeaders(httpURLConnection, request);
    }

    private void setProxySpecificHeaders(HttpURLConnection httpURLConnection, HttpServletRequest request) throws IOException {
        String serverHostName = "jEasyExtensibleProxy";
        try {
            serverHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            logger.log(JeusMessage_WebContainer10._10413_LEVEL, JeusMessage_WebContainer10._10413, (Throwable)e);
        }
        String originalVia = request.getHeader("via");
        StringBuffer via = new StringBuffer("");
        if (originalVia != null) {
            if (originalVia.indexOf(serverHostName) != -1) {
                logger.log(JeusMessage_WebContainer10._10414_LEVEL, JeusMessage_WebContainer10._10414);
                throw new IOException("Request has a cyclic dependency on this proxy.");
            }
            via.append(originalVia).append(", ");
        }
        via.append(request.getProtocol()).append(" ").append(serverHostName);
        httpURLConnection.setRequestProperty("via", via.toString());
        httpURLConnection.setRequestProperty("x-forwarded-for", request.getRemoteAddr());
        httpURLConnection.setRequestProperty("x-forwarded-host", request.getServerName());
        httpURLConnection.setRequestProperty("x-forwarded-server", serverHostName);
        httpURLConnection.setRequestProperty("accept-encoding", "");
    }

    public static void addBannedHeader(String header) {
        bannedHeaders.add(header);
    }

    public static void addBannedHeaders(String headers) {
        StringTokenizer tokenizer = new StringTokenizer(headers, ",");
        while (tokenizer.hasMoreTokens()) {
            bannedHeaders.add(tokenizer.nextToken().trim().toLowerCase());
        }
    }
}

