/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.reverseproxy.rules;

import javax.servlet.http.HttpServletRequest;
import jeus.servlet.reverseproxy.rules.BaseRule;

public class DirectoryRule
extends BaseRule {
    private String directory;

    public void setDirectory(String directory) {
        if (directory == null) {
            throw new IllegalArgumentException("The directory string cannot be null.");
        }
        if (!directory.startsWith("/")) {
            directory = "/" + directory;
        }
        if (!directory.endsWith("/")) {
            directory = directory + "/";
        }
        this.directory = directory;
    }

    public String getDirectory() {
        return this.directory;
    }

    public boolean matches(HttpServletRequest request) {
        String uri = request.getServletPath() + "/";
        return uri.startsWith(this.directory);
    }

    public String process(String uri) {
        return uri.substring(this.directory.length() - 1);
    }

    public String revert(String uri) {
        if (uri.startsWith("/")) {
            return this.directory + uri.substring(1);
        }
        return uri;
    }
}

