/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.reverseproxy.rules;

import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import jeus.servlet.reverseproxy.rules.BaseRule;
import jeus.util.logging.JeusLogger;

public class RewriteRule
extends BaseRule {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.proxy");
    private Pattern matchPattern;
    private String rewriteTo;
    private Pattern revertPattern;
    private String revertTo;
    private boolean isRewriting = false;
    private boolean isReverting;

    public boolean matches(HttpServletRequest request) {
        String uri = this.getURI(request);
        Matcher matcher = this.matchPattern.matcher(uri);
        return matcher.matches();
    }

    public String process(String uri) {
        String rewritten = uri;
        if (this.isRewriting) {
            Matcher matcher = this.matchPattern.matcher(uri);
            rewritten = matcher.replaceAll(this.rewriteTo);
            logger.log(Level.FINEST, "Rewriting URI: " + uri + " >> " + rewritten);
        }
        return rewritten;
    }

    public String revert(String uri) {
        String rewritten = uri;
        if (this.isReverting) {
            Matcher matcher = this.revertPattern.matcher(uri);
            rewritten = matcher.replaceAll(this.revertTo);
            logger.log(Level.FINEST, "Reverting URI: " + uri + " >> " + rewritten);
        }
        return rewritten;
    }

    public void setFrom(String regex) {
        if (regex == null) {
            throw new IllegalArgumentException("From pattern cannot be null.");
        }
        this.matchPattern = Pattern.compile(regex);
    }

    public void setTo(String to) {
        if (to == null) {
            throw new IllegalArgumentException("To string cannot be null.");
        }
        this.rewriteTo = to;
        this.isRewriting = true;
    }

    public void setRevertFrom(String regex) {
        if (regex == null) {
            throw new IllegalArgumentException("Revert pattern cannot be null.");
        }
        this.revertPattern = Pattern.compile(regex);
    }

    public void setRevertTo(String to) {
        if (to == null) {
            throw new IllegalArgumentException("To string cannot be null.");
        }
        this.revertTo = to;
        this.isReverting = true;
    }

    private String getURI(HttpServletRequest httpRequest) {
        String contextPath = httpRequest.getContextPath();
        String uri = httpRequest.getRequestURI().substring(contextPath.length());
        if (httpRequest.getQueryString() != null) {
            uri = uri + "?" + httpRequest.getQueryString();
        }
        return uri;
    }
}

