/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.reverseproxy.rules;

import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import jeus.servlet.reverseproxy.rules.BaseRule;

public class TimeRule
extends BaseRule {
    private int startTime;
    private int endTime;

    public boolean matches(HttpServletRequest request) {
        int currentTime = Calendar.getInstance().get(11);
        if (this.startTime > this.endTime) {
            if (currentTime < this.startTime) {
                currentTime += 24;
            }
            return currentTime >= this.startTime && currentTime <= this.endTime + 24;
        }
        return currentTime >= this.startTime && currentTime <= this.endTime;
    }

    public void setStartTime(String time) {
        if (time == null) {
            throw new IllegalArgumentException("The start time cannot be null");
        }
        this.startTime = Integer.parseInt(time) % 24;
    }

    public void setEndTime(String time) {
        if (time == null) {
            throw new IllegalArgumentException("The end time cannot be null");
        }
        this.endTime = Integer.parseInt(time) % 24;
    }
}

