/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.reverseproxy.servers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeus.servlet.reverseproxy.model.Rule;
import jeus.servlet.reverseproxy.model.Server;
import jeus.servlet.reverseproxy.servers.ClusterRequestWrapper;
import jeus.servlet.reverseproxy.servers.ClusterResponseWrapper;
import jeus.servlet.reverseproxy.servers.ServerContainerBase;
import jeus.servlet.reverseproxy.servers.ServerStatusChecker;
import jeus.servlet.reverseproxy.servers.ServerStatusListener;

public abstract class ClusterContainer
extends ServerContainerBase
implements ServerStatusListener {
    protected HashMap servers = new HashMap();
    private ServerStatusChecker statusChecker = new ServerStatusChecker(this, 300000L);

    public ClusterContainer() {
        this.statusChecker.start();
    }

    protected abstract ClusteredServer createNewServer(String var1, String var2);

    protected abstract ClusteredServer getNextServer();

    public Server getServer(HttpServletRequest request) {
        String serverId = this.getServerIdFromCookie(request.getCookies());
        ClusteredServer server = (ClusteredServer)this.servers.get(serverId);
        if (server == null || !server.online()) {
            server = this.getNextServer();
        } else {
            logger.log(Level.FINEST, "Server found in session");
        }
        if (server.online()) {
            logger.log(Level.FINEST, "Using id " + server.getServerId() + " for this request");
        } else {
            logger.log(Level.FINEST, "All the servers in this cluster are offline. Using id " + server.getServerId() + ", will probably not work");
        }
        return server;
    }

    private String getServerIdFromCookie(Cookie[] cookies) {
        String serverId = null;
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                String value;
                String id;
                Cookie cookie = cookies[i];
                if (!this.isSessionCookie(cookie.getName()) || !(id = (value = cookie.getValue()).substring(value.indexOf(".") + 1)).startsWith("server")) continue;
                serverId = id;
            }
        }
        return serverId;
    }

    private boolean isSessionCookie(String name) {
        return name.equalsIgnoreCase("JSESSIONID") || name.equalsIgnoreCase("PHPSESSID") || name.equalsIgnoreCase("ASPSESSIONID") || name.equalsIgnoreCase("ASP.NET_SessionId");
    }

    public Server getServerMapped(String location) {
        Iterator itr = this.servers.values().iterator();
        Server match = null;
        while (itr.hasNext() && match == null) {
            Server server = (Server)itr.next();
            String fullPath = server.getDomainName() + server.getPath() + "/";
            if (!location.startsWith(fullPath)) continue;
            match = server;
        }
        return match;
    }

    public void serverOffline(Server server) {
        if (server instanceof ClusteredServer) {
            ((ClusteredServer)server).setOnline(false);
        }
    }

    public void serverOnline(Server server) {
        if (server instanceof ClusteredServer) {
            ((ClusteredServer)server).setOnline(true);
        }
    }

    public synchronized void addServer(String domainName, String directory) {
        if (domainName == null) {
            throw new IllegalArgumentException("The domainName cannot be null");
        }
        if (directory == null) {
            directory = "";
        }
        ClusteredServer server = this.createNewServer(domainName, directory);
        this.servers.put(server.getServerId(), server);
        this.statusChecker.addServer(server);
        logger.log(Level.FINEST, "Added server " + domainName + directory + " to the cluster on id " + server.getServerId());
    }

    protected class ClusteredServer
    implements Server {
        private String domainName;
        private String path;
        private String serverId;
        private boolean online;

        public ClusteredServer(String domainName, String path, String serverId) {
            this.domainName = domainName;
            this.path = path;
            this.serverId = serverId;
            this.online = true;
        }

        public HttpServletRequest preExecute(HttpServletRequest request) {
            return new ClusterRequestWrapper(request);
        }

        public HttpServletResponse postExecute(HttpServletResponse response) {
            return new ClusterResponseWrapper(response, this.serverId);
        }

        public void setConnectionExceptionRecieved(Exception e) {
            ClusterContainer.this.statusChecker.interrupt();
        }

        public String getDomainName() {
            return this.domainName;
        }

        public String getPath() {
            return this.path;
        }

        public boolean online() {
            return this.online;
        }

        public void setOnline(boolean online) {
            this.online = online;
        }

        public Rule getRule() {
            return ClusterContainer.this.getRule();
        }

        public String getServerId() {
            return this.serverId;
        }
    }
}

