/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.reverseproxy.servers;

import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import jeus.util.logging.JeusLogger;

public class ClusterRequestWrapper
extends HttpServletRequestWrapper {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.proxy");
    private Vector cookies = new Vector();
    private static Pattern sessionPattern = Pattern.compile("((JSESSIONID=|PHPSESSID=|ASPSESSIONID=|ASP.NET_SessionId=)[a-z0-9]+)(\\.[^;\\s]+)", 130);

    public ClusterRequestWrapper(HttpServletRequest request) {
        super(request);
        Enumeration reqCookies = request.getHeaders("Cookie");
        while (reqCookies.hasMoreElements()) {
            String value = (String)reqCookies.nextElement();
            Matcher matcher = sessionPattern.matcher(value);
            String replaced = matcher.replaceAll("$1");
            if (!replaced.equals(value)) {
                logger.log(Level.FINEST, "Session processed, serverId removed \"" + value + "\" >> " + replaced);
            }
            this.cookies.add(replaced);
        }
    }

    public String getHeader(String name) {
        if (name.equalsIgnoreCase("cookie")) {
            return (String)this.cookies.firstElement();
        }
        return super.getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        if (name.equalsIgnoreCase("cookie")) {
            return this.cookies.elements();
        }
        return super.getHeaders(name);
    }
}

