/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.servlets;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.ExecutionWrapper;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.HttpServletResponseImpl;
import jeus.servlet.engine.RequestUtil;
import jeus.servlet.engine.ServletManager;
import jeus.servlet.filter.FilterChainImpl;
import jeus.servlet.filter.FilterFactory;
import jeus.servlet.jsp.JspServletWrapper;
import jeus.servlet.jsp2.EmbeddedServletOptions;
import jeus.servlet.jsp2.Options;
import jeus.servlet.jsp2.compiler.JspRuntimeContext;
import jeus.servlet.loader.WebAppContextSwitch;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer8;

public class JspServlet
extends HttpServlet
implements ExecutionWrapper {
    private ServletManager servletManager = null;
    private Context context;
    private ServletConfig config;
    private Options options;
    private JspRuntimeContext rctxt;

    public JspServlet(Context context, ServletManager manager) {
        this.context = context;
        this.servletManager = manager;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.config = config;
        this.context = (Context)config.getServletContext();
        this.options = new EmbeddedServletOptions(config, this.context);
        this.rctxt = new JspRuntimeContext(this.context, this.options);
    }

    public int getJspCount() {
        return this.rctxt.getJspCount();
    }

    public int getJspReloadCount() {
        return this.rctxt.getJspReloadCount();
    }

    boolean preCompile(HttpServletRequest request) throws ServletException {
        String value;
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        int start = queryString.indexOf("jsp_precompile");
        if (start < 0) {
            return false;
        }
        if ((queryString = queryString.substring(start + "jsp_precompile".length())).length() == 0) {
            return true;
        }
        if (queryString.startsWith("&")) {
            return true;
        }
        if (!queryString.startsWith("=")) {
            return false;
        }
        int limit = queryString.length();
        int ampersand = queryString.indexOf("&");
        if (ampersand > 0) {
            limit = ampersand;
        }
        if ((value = queryString.substring(1, limit)).equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return true;
        }
        throw new ServletException("Cannot have request parameter jsp_precompile set to " + value);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String jspFile;
            String jspUri;
            String currentIncludedUri;
            String includeUri = (String)request.getAttribute("javax.servlet.include.servlet_path");
            String requestUri = (String)request.getAttribute("javax.servlet.include.request_uri");
            if (requestUri != null && !includeUri.equals(currentIncludedUri = requestUri.substring(requestUri.indexOf(includeUri)))) {
                includeUri = currentIncludedUri;
            }
            if (includeUri == null) {
                jspUri = request.getServletPath();
                if (request.getPathInfo() != null) {
                    jspUri = request.getServletPath() + request.getPathInfo();
                }
            } else {
                jspUri = includeUri;
            }
            if ((jspFile = (String)request.getAttribute("org.apache.catalina.jsp_file")) != null) {
                jspUri = jspFile;
            }
            boolean precompile = this.preCompile(request);
            this.serviceJspFile(request, response, jspUri, null, precompile);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    public void destroy() {
        this.rctxt.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceJspFile(HttpServletRequest request, HttpServletResponse response, String jspUri, Throwable exception, boolean precompile) throws ServletException, IOException {
        jeus.servlet.jsp2.servlet.JspServletWrapper wrapper = this.rctxt.getWrapper(jspUri);
        if (wrapper == null) {
            JspServlet jspServlet = this;
            synchronized (jspServlet) {
                wrapper = this.rctxt.getWrapper(jspUri);
                if (wrapper == null) {
                    InputStream resourceStream = this.context.getResourceAsStream(jspUri);
                    if (resourceStream == null) {
                        response.sendError(404, jspUri);
                        return;
                    }
                    try {
                        resourceStream.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    boolean isErrorPage = exception != null;
                    wrapper = new jeus.servlet.jsp2.servlet.JspServletWrapper(this.config, this.options, jspUri, isErrorPage, this.rctxt);
                    this.rctxt.addWrapper(jspUri, wrapper);
                }
            }
        }
        wrapper.service(request, response, precompile);
    }

    public String getName() {
        return "jeus.servlet.servlets.JspServlet";
    }

    public String getClassName() {
        return this.getName();
    }

    public boolean isResourceServlet() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(HttpServletRequestImpl request, HttpServletResponseImpl response) throws ServletException, IOException {
        WebAppContextSwitch.preContextSwitch(this.context.getContextLoader());
        try {
            request.setAttribute("jeus.web.DISPATCHER_TYPE", FilterFactory.REQUEST_INTEGER);
            request.setAttribute("jeus.web.DISPATCHER_REQUEST_PATH", request.getLookupPath());
            FilterFactory factory = FilterFactory.getInstance();
            FilterChainImpl filterChain = factory.createFilterChain((ServletRequest)request, this);
            try {
                if (filterChain != null) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                } else {
                    if (!this.context.enableJSP()) {
                        response.sendError(503, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer8._8401));
                        return;
                    }
                    String jspUri = null;
                    jspUri = request.getServletPath();
                    String jspName = null;
                    jspName = JspServletWrapper.FILENAME_IGNORECASE ? jspUri.toLowerCase() : jspUri;
                    JspServletWrapper wrapper = this.servletManager.addJsp(jspName, jspUri, null);
                    if (wrapper != null) {
                        wrapper.executeServlet((ServletRequest)request, (ServletResponse)response);
                    }
                }
            }
            finally {
                if (filterChain != null) {
                    filterChain.release();
                }
            }
        }
        finally {
            WebAppContextSwitch.postContextSwitch();
        }
    }

    public void executeServlet(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletRequest request = null;
        HttpServletResponse response = null;
        try {
            request = (HttpServletRequest)req;
            response = (HttpServletResponse)res;
        }
        catch (ClassCastException e) {
            throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer8._8403));
        }
        if (!this.context.enableJSP()) {
            response.sendError(503, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer8._8401));
            return;
        }
        String jspUri = null;
        int dispatchType = 8;
        Integer disInt = (Integer)req.getAttribute("jeus.web.DISPATCHER_TYPE");
        if (disInt != null) {
            dispatchType = disInt;
        }
        if (dispatchType == 4) {
            String includeUri = (String)request.getAttribute("javax.servlet.include.request_uri");
            String _cpath = (String)request.getAttribute("javax.servlet.include.context_path");
            includeUri = RequestUtil.removeContextPathFromRequestURI(_cpath, includeUri);
            if (includeUri == null) {
                throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer8._8407));
            }
            jspUri = includeUri;
        } else {
            jspUri = request.getServletPath();
        }
        String jspName = null;
        jspName = JspServletWrapper.FILENAME_IGNORECASE ? jspUri.toLowerCase() : jspUri;
        JspServletWrapper wrapper = this.servletManager.addJsp(jspName, jspUri, null);
        try {
            wrapper.executeServlet((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException se) {
            throw se;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable t) {
            throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer8._8402, (Object)jspUri), t);
        }
    }

    public ServletManager getServletManager() {
        return this.servletManager;
    }
}

