/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.servlets;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.ExecutionWrapper;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.HttpServletResponseImpl;
import jeus.servlet.engine.ServletManager;
import jeus.servlet.filter.FilterChainImpl;
import jeus.servlet.filter.FilterFactory;
import jeus.servlet.loader.WebAppContextSwitch;
import jeus.servlet.util.URLResolver;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer8;

public class WorkerServlet
extends HttpServlet
implements ExecutionWrapper {
    private static final char DEFAULT_PKG_SEP = '/';
    private String[] servletRoots;
    private int numServletRoot;
    private ServletManager servletManager;
    private ExecutionWrapper defaultServlet;
    private char pkgSep = (char)47;

    public void init() throws ServletException {
        String packageSeparator;
        Context context = (Context)this.getServletContext();
        this.servletRoots = this.getServletRoot();
        boolean defaultRoot = false;
        if (this.servletRoots == null) {
            this.servletRoots = new String[1];
            this.servletRoots[0] = context.getDocBase() + File.separator + "WEB-INF" + File.separator + "classes";
            defaultRoot = true;
        }
        this.pkgSep = (packageSeparator = this.getInitParameter("PackageSeparator")) != null ? packageSeparator.charAt(0) : (char)47;
        this.servletManager = context.getServletManager();
        if (this.servletManager == null) {
            throw new ServletException("the servlet manager must be initialized");
        }
        this.defaultServlet = this.servletManager.getDefaultServlet();
        this.numServletRoot = this.servletRoots.length;
        for (int i = 0; i < this.numServletRoot; ++i) {
            if (this.servletRoots[i].endsWith(File.separator)) {
                this.servletRoots[i] = this.servletRoots[i].substring(0, this.servletRoots[i].length() - 1);
            }
            URL servletRootURL = null;
            try {
                int pos = this.servletRoots[i].lastIndexOf(File.separator);
                if (pos < 0) continue;
                String baseDir = this.servletRoots[i].substring(0, pos);
                String realDir = this.servletRoots[i].substring(pos + 1);
                URL baseURL = URLResolver.resolve(baseDir);
                String protocol = baseURL.getProtocol();
                int port = baseURL.getPort();
                String host = baseURL.getHost();
                String classPath = baseURL.getFile() + "/" + realDir + "/";
                servletRootURL = new URL(protocol, host, port, classPath);
            }
            catch (MalformedURLException mue) {
                throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer8._8410), (Throwable)mue);
            }
            int n = i;
            this.servletRoots[n] = this.servletRoots[n] + File.separator;
            if (defaultRoot) continue;
            context.getContextLoader().addClassPath(servletRootURL);
        }
    }

    private String[] getServletRoot() {
        String root = this.getInitParameter("ServletRoot");
        if (root == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(root, ";");
        int count = tokenizer.countTokens();
        if (count <= 0) {
            return null;
        }
        String[] roots = new String[count];
        count = 0;
        while (tokenizer.hasMoreTokens()) {
            roots[count] = tokenizer.nextToken();
            roots[count] = roots[count].trim();
            ++count;
        }
        return roots;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    private ExecutionWrapper findWrapper(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean isIncluded;
        String servletPath = null;
        String pathInfo = null;
        int dispatchType = 8;
        Integer disInt = (Integer)request.getAttribute("jeus.web.DISPATCHER_TYPE");
        if (disInt != null) {
            dispatchType = disInt;
        }
        boolean bl = isIncluded = dispatchType == 4;
        if (isIncluded) {
            servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
        } else {
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
        }
        ExecutionWrapper wrapper = null;
        if (pathInfo == null) {
            wrapper = this.defaultServlet;
        } else {
            char fsc = File.separatorChar;
            String packagePath = pathInfo.substring(1).replace(this.pkgSep, fsc);
            String className = pathInfo.substring(1).replace(this.pkgSep, '.');
            String mapPath = null;
            mapPath = this.pkgSep != '/' ? servletPath + "/" + pathInfo.substring(1).replace(this.pkgSep, '/') : servletPath + pathInfo;
            wrapper = this.servletManager.getServletByName(mapPath);
            String classFilePath = null;
            if (wrapper == null) {
                boolean found = false;
                for (int i = 0; i < this.numServletRoot; ++i) {
                    String servletRoot = this.servletRoots[i];
                    classFilePath = servletRoot + packagePath + ".class";
                    File f = new File(classFilePath);
                    if (!f.exists()) continue;
                    wrapper = this.servletManager.addServlet(mapPath, className, null);
                    this.servletManager.addMapping(mapPath, wrapper);
                    HttpServletRequestImpl orgreq = this.getOriginalRequest(request);
                    orgreq.setExecutionWrapper(wrapper);
                    if (!isIncluded) {
                        orgreq.setServletPath(mapPath);
                    }
                    orgreq.setPathInfo(null);
                    if (isIncluded) {
                        orgreq.setAttribute("javax.servlet.include.servlet_path", mapPath);
                        orgreq.setAttribute("javax.servlet.include.path_info", null);
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    wrapper = this.defaultServlet;
                }
            }
        }
        return wrapper;
    }

    private HttpServletRequestImpl getOriginalRequest(HttpServletRequest request) throws ServletException {
        if (request instanceof HttpServletRequestImpl) {
            return (HttpServletRequestImpl)request;
        }
        if (!(request instanceof ServletRequestWrapper)) {
            return null;
        }
        ServletRequest tmp = ((ServletRequestWrapper)request).getRequest();
        while (true) {
            if (tmp == null) {
                return null;
            }
            if (tmp instanceof HttpServletRequestImpl) {
                return (HttpServletRequestImpl)tmp;
            }
            if (!(tmp instanceof ServletRequestWrapper)) break;
            tmp = ((ServletRequestWrapper)tmp).getRequest();
        }
        throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer8._8408));
    }

    public String getName() {
        return "jeus.servlet.servlets.WorkerServlet";
    }

    public String getClassName() {
        return this.getName();
    }

    public boolean isResourceServlet() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(HttpServletRequestImpl request, HttpServletResponseImpl response) throws ServletException, IOException {
        WebAppContextSwitch.preContextSwitch(request.getContext().getContextLoader());
        try {
            request.setAttribute("jeus.web.DISPATCHER_TYPE", FilterFactory.REQUEST_INTEGER);
            request.setAttribute("jeus.web.DISPATCHER_REQUEST_PATH", request.getLookupPath());
            FilterFactory factory = FilterFactory.getInstance();
            FilterChainImpl filterChain = factory.createFilterChain((ServletRequest)request, this);
            try {
                if (filterChain != null) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                } else {
                    ExecutionWrapper wrapper = this.findWrapper(request, response);
                    if (wrapper != null) {
                        wrapper.executeServlet((ServletRequest)request, (ServletResponse)response);
                    }
                }
            }
            finally {
                if (filterChain != null) {
                    filterChain.release();
                }
            }
        }
        finally {
            WebAppContextSwitch.postContextSwitch();
        }
    }

    public void executeServlet(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletRequest request = null;
        HttpServletResponse response = null;
        try {
            request = (HttpServletRequest)req;
            response = (HttpServletResponse)res;
        }
        catch (ClassCastException e) {
            throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer8._8403));
        }
        ExecutionWrapper wrapper = this.findWrapper(request, response);
        if (wrapper == null) {
            return;
        }
        try {
            wrapper.executeServlet((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException se) {
            throw se;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable t) {
            throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer8._8411, (Object)request.getRequestURI()), t);
        }
    }

    public ServletManager getServletManager() {
        return this.servletManager;
    }
}

