/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.tcp;

import java.io.IOException;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.servlet.tcp.TCPDispatcherConfig;
import jeus.servlet.tcp.TCPServletRequest;
import jeus.util.StringUtil;
import jeus.util.message.JeusMessage_WebContainer1;

public class TCPServletRequestImpl
extends TCPServletRequest {
    private int headerLength;

    public TCPServletRequestImpl(ContextGroup ctxGroup, ThreadPoolManager manager, TCPDispatcherConfig config) {
        super(ctxGroup, manager, config);
    }

    public int readRequest(int readTimeout, int postdataReadTimeout) throws IOException, InterruptedException {
        int clen;
        if (readTimeout >= 0) {
            try {
                if (this.socket != null) {
                    this.socket.setSoTimeout(readTimeout);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (postdataReadTimeout > 0) {
            try {
                if (this.socket != null) {
                    this.socket.setSoTimeout(0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.headerLength = this.config.getHeaderLength();
        if (this.headerLength < 0) {
            this.headerLength = 0;
        }
        this.header = new byte[this.headerLength];
        if (this.headerLength > 0) {
            this.in.readFully(this.header, 0, this.header.length);
        }
        this.method.setString("GET");
        this.protocol.setString("HTTP/0.9");
        this.contentLength = this.config.getBodyLength(this.header);
        this.contextPath = this.config.getContextPath(this.header);
        this.servletPath = this.config.getServletPath(this.header);
        if (this.servletPath != null && !this.servletPath.startsWith("/")) {
            this.servletPath = "/" + this.servletPath;
        }
        this.pathInfo = this.config.getPathInfo(this.header);
        this.requestURI.setString(this.contextPath);
        if (this.servletPath != null && !this.servletPath.equals("/")) {
            this.requestURI.setString(this.requestURI.getString() + this.servletPath);
        }
        if (this.pathInfo != null) {
            this.requestURI.setString(this.requestURI.getString() + this.pathInfo);
        }
        this.processCommonRequest(this.requestURI, null, null);
        if (logger.isLoggable(JeusMessage_WebContainer1._2401_LEVEL)) {
            StringBuffer buf = new StringBuffer();
            buf.append("\tcontext-path : " + this.contextPath + StringUtil.lineSeparator);
            buf.append("\tservlet-path : " + this.servletPath + StringUtil.lineSeparator);
            buf.append("\tpath-info    : " + this.pathInfo + StringUtil.lineSeparator);
            buf.append("\trequest-uri  : " + this.requestURI + StringUtil.lineSeparator);
            buf.append("\tcontent-len  : " + this.contentLength + StringUtil.lineSeparator);
            logger.log(JeusMessage_WebContainer1._2401_LEVEL, JeusMessage_WebContainer1._2401, (Object)buf.toString());
        }
        if ((clen = this.getContentLength()) > 0) {
            this.in.setLimit(clen);
        } else {
            this.in.setLimit(0);
        }
        if (postdataReadTimeout > 0) {
            try {
                if (this.socket != null) {
                    this.socket.setSoTimeout(postdataReadTimeout);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return 1;
    }

    public final void clearPostData2() throws IOException {
        String servletName;
        if (this.body != null) {
            return;
        }
        String string = servletName = this.wrapper == null ? "unknown" : this.wrapper.getClassName();
        if (logger.isLoggable(JeusMessage_WebContainer1._2402_LEVEL)) {
            logger.log(JeusMessage_WebContainer1._2402_LEVEL, JeusMessage_WebContainer1._2402, (Object[])new String[]{servletName, String.valueOf(this.contentLength), String.valueOf(this.contentLength)});
        }
        this.getBody();
    }

    public void clearing() {
        this.header = null;
        this.body = null;
        super.clearing();
    }

    public String getRequestInfo() {
        String servletName = "unknown";
        if (this.wrapper != null) {
            servletName = this.wrapper.getClassName();
        }
        return "request from " + this.getRemoteAddr() + ":" + this.getRemotePort() + ". servlet = " + servletName + ", hdrlen = " + this.headerLength + ", bodylen = " + this.contentLength;
    }
}

