/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.util;

import java.io.File;
import java.util.Date;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.HttpServletResponseImpl;
import jeus.servlet.util.Logger;
import jeus.util.SimpleLogDateFormat;
import jeus.util.trace.GID;

public class AccessLogger
extends Logger {
    private SimpleLogDateFormat adf = null;

    public AccessLogger(File file, int bsize, String logFormat) {
        super(file, bsize);
        this.initLogFormat(logFormat);
    }

    public AccessLogger(File file, int bsize, int days) {
        super(file, "accesslog", bsize, days);
        this.initLogFormat(null);
    }

    public AccessLogger(File file, int bsize, int days, String logFormat) {
        super(file, "accesslog", bsize, days);
        this.initLogFormat(logFormat);
    }

    public AccessLogger(File file, int bsize, int days, int numLogs, String logFormat) {
        super(file, "accesslog", bsize, days, numLogs);
        this.initLogFormat(logFormat);
    }

    private void initLogFormat(String logFormat) {
        if (logFormat == null || logFormat.equalsIgnoreCase("default")) {
            this.adf = this.df;
        } else {
            logFormat = "[" + logFormat + "]";
            try {
                this.adf = new SimpleLogDateFormat(logFormat);
            }
            catch (Exception e) {
                this.adf = this.df;
            }
        }
    }

    public void log(String msg) {
        Date d = new Date();
        String date = this.adf.format(d);
        if (this.isConsoleOut) {
            jeus.util.Logger.directLog(date + msg);
        } else {
            this.out.println(date + msg);
            if (this.noBuffering) {
                this.out.flush();
            }
        }
    }

    public void log(HttpServletRequestImpl request, HttpServletResponseImpl response, long processing) {
        Date d = new Date();
        String date = this.adf.format(d);
        String clientIP = request.getRemoteAddr();
        String method = request.getMethod();
        String requestURI = request.getRequestURI();
        String queryString = request.getQueryString();
        if (queryString != null) {
            requestURI = requestURI + "?" + queryString;
        }
        String status = "" + response.getAccessLogStatus();
        if (this.isConsoleOut) {
            jeus.util.Logger.directLog(date + " " + this.getGID() + clientIP + " \"" + method + " " + requestURI + "\" " + status + " " + processing + "ms");
        } else {
            this.out.println(date + " " + this.getGID() + clientIP + " \"" + method + " " + requestURI + "\" " + status + " " + processing + "ms");
            if (this.noBuffering) {
                this.out.flush();
            }
        }
    }

    public void log(HttpServletRequestImpl request, HttpServletResponseImpl response, long processing, long sessionSyncTime) {
        Date d = new Date();
        String date = this.adf.format(d);
        String clientIP = request.getRemoteAddr();
        String method = request.getMethod();
        String requestURI = request.getRequestURI();
        String queryString = request.getQueryString();
        if (queryString != null) {
            requestURI = requestURI + "?" + queryString;
        }
        String status = "" + response.getAccessLogStatus();
        if (this.isConsoleOut) {
            jeus.util.Logger.directLog(date + " " + this.getGID() + clientIP + " \"" + method + " " + requestURI + "\" " + status + " " + processing + "ms " + sessionSyncTime + "ms");
        } else {
            this.out.println(date + " " + this.getGID() + clientIP + " \"" + method + " " + requestURI + "\" " + status + " " + processing + "ms " + sessionSyncTime + "ms");
            if (this.noBuffering) {
                this.out.flush();
            }
        }
    }

    private String getGID() {
        GID gid = GID.getCurrentGID();
        if (gid == null) {
            return "";
        }
        return "[" + gid.toString() + "] ";
    }
}

