/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.util;

import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import jeus.servlet.property.PropertyUtil;
import jeus.servlet.property.WebProperties;

public class CookieUtil {
    private static final String tspecials = "()<>@,;:\\\"/[]?={} \t";

    public static String getCookieHeaderName(Cookie cookie) {
        int version = cookie.getVersion();
        if (version == 1 && !WebProperties.J2EE_COMPATIBLE.value) {
            return "Set-Cookie2";
        }
        return "Set-Cookie";
    }

    public static String getCookieHeaderValue(Cookie cookie) {
        StringBuffer buf = new StringBuffer();
        int version = cookie.getVersion();
        buf.append(cookie.getName());
        buf.append("=");
        WebProperties props = PropertyUtil.getContextProperties();
        if (props.URLDECODE_COOKIE.value) {
            CookieUtil.maybeQuote(version, buf, URLEncoder.encode(cookie.getValue()));
        } else {
            CookieUtil.maybeQuote(version, buf, cookie.getValue());
        }
        if (version == 1) {
            buf.append(";Version=1");
            if (cookie.getComment() != null) {
                buf.append(";Comment=");
                CookieUtil.maybeQuote(version, buf, cookie.getComment());
            }
        }
        if (cookie.getDomain() != null) {
            buf.append(";Domain=");
            CookieUtil.maybeQuote(version, buf, cookie.getDomain());
        }
        if (cookie.getMaxAge() >= 0) {
            if (version == 0) {
                buf.append(";Expires=");
                buf.append(CookieUtil.oldCookieExpiry(cookie.getMaxAge()));
            } else {
                buf.append(";Max-Age=");
                buf.append(cookie.getMaxAge());
            }
        } else if (version == 1) {
            buf.append(";Discard");
        }
        if (cookie.getPath() != null) {
            buf.append(";Path=");
            CookieUtil.maybeQuote(version, buf, cookie.getPath());
        }
        if (cookie.getSecure()) {
            buf.append(";Secure");
        }
        return buf.toString();
    }

    public static String getCookieHeaderValueWithVersion0(Cookie cookie) {
        StringBuffer buf = new StringBuffer();
        int version = cookie.getVersion();
        buf.append(cookie.getName());
        buf.append("=");
        WebProperties props = PropertyUtil.getContextProperties();
        if (props.URLDECODE_COOKIE.value) {
            CookieUtil.maybeQuote(version, buf, URLEncoder.encode(cookie.getValue()));
        } else {
            CookieUtil.maybeQuote(version, buf, cookie.getValue());
        }
        if (version == 1) {
            buf.append(";Version=1");
            if (cookie.getComment() != null) {
                buf.append(";Comment=");
                CookieUtil.maybeQuote(0, buf, cookie.getComment());
            }
        }
        if (cookie.getDomain() != null) {
            buf.append(";Domain=");
            CookieUtil.maybeQuote(0, buf, cookie.getDomain());
        }
        if (cookie.getMaxAge() >= 0) {
            if (version == 0) {
                buf.append(";Expires=");
                buf.append(CookieUtil.oldCookieExpiry(cookie.getMaxAge()));
            } else {
                buf.append(";Max-Age=");
                buf.append(cookie.getMaxAge());
            }
        } else if (version == 1) {
            buf.append(";Discard");
        }
        if (cookie.getPath() != null) {
            buf.append(";Path=");
            CookieUtil.maybeQuote(0, buf, cookie.getPath());
        }
        if (cookie.getSecure()) {
            buf.append(";Secure");
        }
        return buf.toString();
    }

    static void maybeQuote(int version, StringBuffer buf, String value) {
        if (version == 0 || CookieUtil.isToken(value)) {
            buf.append(value);
        } else if (WebProperties.J2EE_COMPATIBLE.value && value.startsWith("\"")) {
            buf.append(value);
        } else {
            buf.append('\"');
            buf.append(value);
            buf.append('\"');
        }
    }

    private static boolean isToken(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f' && tspecials.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    public static String oldCookieExpiry(long maxAge) {
        Locale loc = Locale.US;
        TimeZone zone = TimeZone.getTimeZone("GMT");
        GregorianCalendar calendar = new GregorianCalendar(zone, loc);
        if (maxAge == 0L) {
            calendar.setTime(new Date(10000L));
        } else {
            calendar.setTime(new Date(System.currentTimeMillis() + maxAge * 1000L));
        }
        String pattern = "EEE, dd-MMM-yyyy HH:mm:ss z";
        SimpleDateFormat df = new SimpleDateFormat(pattern, loc);
        df.setTimeZone(zone);
        return df.format(calendar.getTime());
    }
}

