/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.util.Date;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import javax.servlet.ServletException;
import jeus.servlet.util.Logger;
import jeus.util.ErrorMsgManager;
import jeus.util.trace.GID;

public class ErrorLogger
extends Logger {
    public static final int FATAL = 0;
    public static final int EMERGENT = 0;
    public static final int ERROR = 1;
    public static final int NOTICE = 1;
    public static final int WARNING = 2;
    public static final int INFORMATION = 2;
    public static final int DEBUG = 3;
    public static final int TEST = 100;
    private int logLevel = 1;
    private Session session;
    private MimeMessage message;
    private int notifyLevel;
    private String emailSubject;
    private boolean enableEmailNotify;
    private boolean emailNotifierInited = false;
    public static boolean TEST_MODE = false;

    public ErrorLogger(File file, int bsize) {
        super(file, bsize);
    }

    public ErrorLogger(File file, int bsize, int days) {
        super(file, "errorlog", bsize, days);
    }

    public ErrorLogger(File file, int bsize, int days, int numLogs) {
        super(file, "errorlog", bsize, days, numLogs);
    }

    public void setLogLevel(int level) {
        this.logLevel = level;
        TEST_MODE = level > 3;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public boolean isLogLevel(int level) {
        return level >= this.logLevel;
    }

    public void log(String msg) {
        Date d = new Date();
        String date = this.df.format(d);
        if (this.isConsoleOut) {
            jeus.util.Logger.directLog(date + this.getGID() + msg);
        } else {
            this.out.println(date + this.getGID() + msg);
            if (this.noBuffering) {
                this.out.flush();
            }
        }
    }

    public void log(String step, String msg) {
        Date d = new Date();
        String date = this.df.format(d);
        if (this.isConsoleOut) {
            jeus.util.Logger.directLog(date + this.getGID() + "[" + step + "] " + msg);
        } else {
            this.out.println(date + this.getGID() + "[" + step + "] " + msg);
            if (this.noBuffering) {
                this.out.flush();
            }
        }
    }

    public void log(String msg, Throwable e) {
        Date d = new Date();
        String date = this.df.format(d);
        if (this.isConsoleOut) {
            jeus.util.Logger.directLog(date + this.getGID() + msg, e);
        } else {
            this.out.println(date + this.getGID() + msg);
            this.printStackTrace(e);
            if (this.noBuffering) {
                this.out.flush();
            }
        }
    }

    public void log(String step, String msg, Throwable e) {
        Date d = new Date();
        String date = this.df.format(d);
        if (this.isConsoleOut) {
            jeus.util.Logger.directLog(date + this.getGID() + "[" + step + "] " + msg);
            this.printStackTrace(e);
        } else {
            this.out.println(date + this.getGID() + "[" + step + "] " + msg);
            this.printStackTrace(e);
            if (this.noBuffering) {
                this.out.flush();
            }
        }
    }

    public void log(String msg, int level) {
        String logMsg = null;
        if (level <= this.logLevel) {
            logMsg = this.df.format(new Date()) + this.getGID() + "[" + level + "] " + msg;
            if (this.isConsoleOut) {
                jeus.util.Logger.directLog(logMsg);
            } else {
                this.out.println(logMsg);
                if (this.noBuffering) {
                    this.out.flush();
                }
            }
        }
        if (this.enableEmailNotify && level <= this.notifyLevel) {
            this.sendEmailNotification(logMsg);
        }
    }

    public void log(String step, String msg, int level) {
        this.log(step, msg, level, null);
    }

    public void log(String step, String msg, int level, String mailsbj) {
        String logMsg = null;
        if (level <= this.logLevel) {
            logMsg = this.df.format(new Date()) + this.getGID() + "[" + level + "] [" + step + "] " + msg;
            if (this.isConsoleOut) {
                jeus.util.Logger.directLog(logMsg);
            } else {
                this.out.println(logMsg);
                if (this.noBuffering) {
                    this.out.flush();
                }
            }
        }
        if (this.enableEmailNotify && level <= this.notifyLevel) {
            this.sendEmailNotification(mailsbj, logMsg);
        }
    }

    public void log(Throwable e, int level) {
        String msg = "";
        String logMsg = null;
        if (level <= this.logLevel) {
            logMsg = this.df.format(new Date()) + this.getGID() + "[" + level + "] " + msg;
            if (this.isConsoleOut) {
                jeus.util.Logger.directLog(logMsg);
                this.printStackTrace(e);
            } else {
                this.out.println(logMsg);
                this.printStackTrace(e);
                if (this.noBuffering) {
                    this.out.flush();
                }
            }
        }
        if (this.enableEmailNotify && level <= this.notifyLevel) {
            this.sendEmailNotification(null, logMsg, e);
        }
    }

    public void log(String msg, Throwable e, int level) {
        String logMsg = null;
        if (level <= this.logLevel) {
            logMsg = this.df.format(new Date()) + this.getGID() + "[" + level + "] " + msg;
            if (this.isConsoleOut) {
                jeus.util.Logger.directLog(logMsg);
                this.printStackTrace(e);
            } else {
                this.out.println(logMsg);
                this.printStackTrace(e);
                if (this.noBuffering) {
                    this.out.flush();
                }
            }
        }
        if (this.enableEmailNotify && level <= this.notifyLevel) {
            this.sendEmailNotification(null, logMsg, e);
        }
    }

    public void log(String step, String msg, Throwable e, int level) {
        this.log(step, msg, e, level, null);
    }

    public void mailLog(String step, String msg, Throwable e, int level, String mailsbj) {
        String logMsg = null;
        if (level <= this.logLevel) {
            logMsg = this.df.format(new Date()) + this.getGID() + "[" + level + "] [" + step + "]" + msg;
            if (this.isConsoleOut) {
                jeus.util.Logger.directLog(logMsg);
                if (e != null) {
                    this.printStackTrace(e);
                }
            } else {
                this.out.println(logMsg);
                if (e != null) {
                    this.printStackTrace(e);
                }
                if (this.noBuffering) {
                    this.out.flush();
                }
            }
        }
        if (this.emailNotifierInited) {
            this.sendEmailNotification(mailsbj, logMsg, e);
        }
    }

    public void log(String step, String msg, Throwable e, int level, String mailsbj) {
        String logMsg = null;
        if (level <= this.logLevel) {
            logMsg = this.df.format(new Date()) + this.getGID() + "[" + level + "] [" + step + "] " + msg;
            if (this.isConsoleOut) {
                jeus.util.Logger.directLog(logMsg);
                this.printStackTrace(e);
            } else {
                this.out.println(logMsg);
                this.printStackTrace(e);
                if (this.noBuffering) {
                    this.out.flush();
                }
            }
        }
        if (this.enableEmailNotify && level <= this.notifyLevel) {
            this.sendEmailNotification(mailsbj, logMsg, e);
        }
    }

    private void printStackTrace(Throwable e) {
        if (this.isConsoleOut) {
            Throwable root;
            jeus.util.Logger.directLog(e);
            if (e instanceof ServletException && (root = ((ServletException)e).getRootCause()) != null) {
                jeus.util.Logger.directLog("caused by: ", root);
            }
        } else {
            Throwable root;
            this.out.println("<<__Exception__>>");
            e.printStackTrace(this.out);
            this.out.println("<<__!Exception__>>");
            if (e instanceof ServletException && (root = ((ServletException)e).getRootCause()) != null) {
                this.out.println("<<__Exception__>>");
                this.out.print("caused by: ");
                root.printStackTrace(this.out);
                this.out.println("<<__!Exception__>>");
            }
        }
    }

    private String stackTraceToString(Throwable t) {
        Throwable root;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos, true);
        t.printStackTrace(pw);
        if (t instanceof ServletException && (root = ((ServletException)t).getRootCause()) != null) {
            root.printStackTrace(pw);
        }
        return baos.toString();
    }

    private void sendEmailNotification(String msg) {
        this.sendEmailNotification(null, msg, null);
    }

    public void sendEmailNotification(String subject, String msg) {
        this.sendEmailNotification(subject, msg, null);
    }

    public void sendEmailNotification(String subject, String msg, Throwable t) {
        if (this.message == null) {
            return;
        }
        if (subject == null) {
            subject = this.emailSubject;
        }
        if (t != null) {
            String trace = this.stackTraceToString(t);
            msg = msg + "\n\n" + trace;
        }
        try {
            this.message.setSubject(subject);
            this.message.setText(msg);
            Transport.send((Message)this.message);
        }
        catch (MessagingException me) {
            this.log("warning: email notification failed", me, 2, false);
        }
    }

    public void log(String msg, Throwable e, int level, boolean notify) {
        String logMsg = null;
        if (level <= this.logLevel) {
            logMsg = this.df.format(new Date()) + this.getGID() + "[" + level + "] " + msg;
            if (this.isConsoleOut) {
                jeus.util.Logger.directLog(logMsg);
                this.printStackTrace(e);
            } else {
                this.out.println(logMsg);
                this.printStackTrace(e);
                if (this.noBuffering) {
                    this.out.flush();
                }
            }
        }
    }

    public void log(int msgID, String arg, int level) {
        String logMsg = null;
        if (level <= this.logLevel) {
            logMsg = this.df.format(new Date()) + this.getGID() + "[" + level + "] " + ErrorMsgManager.getLocalizedString((int)msgID, (Object)arg);
            if (this.isConsoleOut) {
                jeus.util.Logger.directLog(logMsg);
            } else {
                this.out.println(logMsg);
                if (this.noBuffering) {
                    this.out.flush();
                }
            }
        }
        if (this.enableEmailNotify && level <= this.notifyLevel) {
            this.sendEmailNotification(logMsg);
        }
    }

    public void log(int msgID, String[] args, int level) {
        String logMsg = null;
        if (level <= this.logLevel) {
            logMsg = this.df.format(new Date()) + this.getGID() + "[" + level + "] " + ErrorMsgManager.getLocalizedString((int)msgID, (Object[])args);
            if (this.isConsoleOut) {
                jeus.util.Logger.directLog(logMsg);
            } else {
                this.out.println(logMsg);
                if (this.noBuffering) {
                    this.out.flush();
                }
            }
        }
        if (this.enableEmailNotify && level <= this.notifyLevel) {
            this.sendEmailNotification(logMsg);
        }
    }

    public void log(int msgID, int level) {
        String logMsg = null;
        if (level <= this.logLevel) {
            logMsg = this.df.format(new Date()) + this.getGID() + "[" + level + "] " + ErrorMsgManager.getLocalizedString((int)msgID);
            if (this.isConsoleOut) {
                jeus.util.Logger.directLog(logMsg);
            } else {
                this.out.println(logMsg);
                if (this.noBuffering) {
                    this.out.flush();
                }
            }
        }
        if (this.enableEmailNotify && level <= this.notifyLevel) {
            this.sendEmailNotification(logMsg);
        }
    }

    public void log(int msgID, Throwable t, int level) {
        String logMsg = null;
        if (level <= this.logLevel) {
            logMsg = this.df.format(new Date()) + this.getGID() + "[" + level + "] " + ErrorMsgManager.getLocalizedString((int)msgID);
            if (this.isConsoleOut) {
                jeus.util.Logger.directLog(logMsg);
                if (t != null) {
                    this.printStackTrace(t);
                }
            } else {
                this.out.println(logMsg);
                if (t != null) {
                    this.printStackTrace(t);
                }
                if (this.noBuffering) {
                    this.out.flush();
                }
            }
        }
        if (this.enableEmailNotify && level <= this.notifyLevel) {
            this.sendEmailNotification(logMsg);
        }
    }

    public void log(int msgID, String arg, Throwable t, int level) {
        String logMsg = null;
        if (level <= this.logLevel) {
            logMsg = this.df.format(new Date()) + this.getGID() + "[" + level + "] " + ErrorMsgManager.getLocalizedString((int)msgID, (Object)arg);
            if (this.isConsoleOut) {
                jeus.util.Logger.directLog(logMsg);
                if (t != null) {
                    this.printStackTrace(t);
                }
            } else {
                this.out.println(logMsg);
                if (t != null) {
                    this.printStackTrace(t);
                }
                if (this.noBuffering) {
                    this.out.flush();
                }
            }
        }
        if (this.enableEmailNotify && level <= this.notifyLevel) {
            this.sendEmailNotification(logMsg);
        }
    }

    public void log(int msgID, String[] args, Throwable t, int level) {
        String logMsg = null;
        if (level <= this.logLevel) {
            logMsg = this.df.format(new Date()) + this.getGID() + "[" + level + "] " + ErrorMsgManager.getLocalizedString((int)msgID, (Object[])args);
            if (this.isConsoleOut) {
                jeus.util.Logger.directLog(logMsg);
                if (t != null) {
                    this.printStackTrace(t);
                }
            } else {
                this.out.println(logMsg);
                if (t != null) {
                    this.printStackTrace(t);
                }
                if (this.noBuffering) {
                    this.out.flush();
                }
            }
        }
        if (this.enableEmailNotify && level <= this.notifyLevel) {
            this.sendEmailNotification(logMsg);
        }
    }

    public void log(int msgID, String[] args, Throwable e, int level, String mailsbj) {
        String logMsg = null;
        if (level <= this.logLevel) {
            logMsg = this.df.format(new Date()) + this.getGID() + "[" + level + "] " + ErrorMsgManager.getLocalizedString((int)msgID, (Object[])args);
            if (this.isConsoleOut) {
                jeus.util.Logger.directLog(logMsg);
                if (e != null) {
                    this.printStackTrace(e);
                }
            } else {
                this.out.println(logMsg);
                if (e != null) {
                    this.printStackTrace(e);
                }
                if (this.noBuffering) {
                    this.out.flush();
                }
            }
        }
        if (this.enableEmailNotify && level <= this.notifyLevel) {
            this.sendEmailNotification(mailsbj, logMsg, e);
        }
    }

    public void log(int msgID, String arg, Throwable e, int level, String mailsbj) {
        String logMsg = null;
        if (level <= this.logLevel) {
            logMsg = this.df.format(new Date()) + this.getGID() + "[" + level + "] " + ErrorMsgManager.getLocalizedString((int)msgID, (Object)arg);
            if (this.isConsoleOut) {
                jeus.util.Logger.directLog(logMsg);
                if (e != null) {
                    this.printStackTrace(e);
                }
            } else {
                this.out.println(logMsg);
                if (e != null) {
                    this.printStackTrace(e);
                }
                if (this.noBuffering) {
                    this.out.flush();
                }
            }
        }
        if (this.enableEmailNotify && level <= this.notifyLevel) {
            this.sendEmailNotification(mailsbj, logMsg, e);
        }
    }

    public void mailLog(int msgID, String[] args, Throwable e, int level, String mailsbj) {
        String logMsg = null;
        if (level <= this.logLevel) {
            logMsg = this.df.format(new Date()) + this.getGID() + "[" + level + "] " + ErrorMsgManager.getLocalizedString((int)msgID, (Object[])args);
            if (this.isConsoleOut) {
                jeus.util.Logger.directLog(logMsg);
                if (e != null) {
                    this.printStackTrace(e);
                }
            } else {
                this.out.println(logMsg);
                if (e != null) {
                    this.printStackTrace(e);
                }
                if (this.noBuffering) {
                    this.out.flush();
                }
            }
        }
        if (this.emailNotifierInited) {
            this.sendEmailNotification(mailsbj, logMsg, e);
        }
    }

    private String getGID() {
        GID gid = GID.getCurrentGID();
        if (gid == null) {
            return "";
        }
        return "[" + gid.toString() + "] ";
    }
}

