/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.util;

import java.io.File;
import java.util.StringTokenizer;
import jeus.servlet.engine.Context;

public class SecurityCheckUtil {
    private static final String[] SPECIAL_UNENCODED_CHAR = new String[]{"%2e", "%2f", "%5c"};

    public static boolean isUriWithWebInf(String uri, boolean ignorecase) {
        String check = uri;
        if (check == null) {
            return false;
        }
        if (ignorecase) {
            check = check.toUpperCase();
        }
        return check.indexOf("WEB-INF") != -1;
    }

    public static boolean isUriWithLastSpace(String uri) {
        if (uri == null || uri.length() <= 0) {
            return false;
        }
        if (Character.isWhitespace(uri.charAt(uri.length() - 1))) {
            return true;
        }
        return uri.lastIndexOf(0) != -1;
    }

    public static boolean isUnEncodeUriWithLastSpecialChar(String unEncodeUri) {
        if (unEncodeUri == null || unEncodeUri.length() <= 0) {
            return false;
        }
        for (int i = 0; i < SPECIAL_UNENCODED_CHAR.length; ++i) {
            if (unEncodeUri.lastIndexOf(SPECIAL_UNENCODED_CHAR[i]) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean isExistWebInf(Context ctx, String uri, boolean excludeRoot) {
        String checkFileDir = null;
        int totalToken = 0;
        int i = 0;
        if (ctx == null || uri == null) {
            return false;
        }
        checkFileDir = ctx.getDocBase();
        StringTokenizer stn = new StringTokenizer(uri, "/");
        totalToken = stn.countTokens();
        if (excludeRoot) {
            i = 1;
        }
        while (i < totalToken) {
            String checkWebInfDir = (checkFileDir = checkFileDir + "/" + stn.nextToken()) + "/WEB-INF";
            if (new File(checkWebInfDir).exists()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isUriWithSharp(String uri) {
        return uri.indexOf("#") > 0;
    }
}

