/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jeus.util.file.FileUtils;

public class URLResolver {
    public static URL resolve(String s) throws MalformedURLException {
        return URLResolver.resolve(s, null);
    }

    public static URL resolve(String s, URL url) throws MalformedURLException {
        URL resolve = null;
        String fs = System.getProperty("file.separator");
        if (s.indexOf("://") > -1 || s.indexOf("file:") > -1) {
            resolve = new URL(s);
        } else if (url != null) {
            resolve = new URL(url, s);
        } else if (s.startsWith(fs) || s.startsWith("/") || s.length() >= 2 && Character.isLetter(s.charAt(0)) && s.charAt(1) == ':') {
            String fName = s;
            try {
                fName = new File(s).getCanonicalPath();
            }
            catch (NullPointerException npe) {
            }
            catch (IOException npe) {
                // empty catch block
            }
            resolve = new URL("file", "", fName);
        } else {
            String path = System.getProperty("user.dir") + File.separator + s;
            resolve = new URL("file", "", path);
        }
        if (!resolve.getProtocol().equalsIgnoreCase("war") && resolve.getFile().toLowerCase().endsWith(".war") && !FileUtils.isExploded((String)resolve.getFile())) {
            resolve = new URL("war:" + resolve.toString());
        }
        String trimed = URLResolver.trim(resolve.getFile(), ".", "..");
        trimed = URLResolver.trim(trimed, "./");
        resolve = new URL(resolve.getProtocol(), resolve.getHost(), trimed);
        return resolve;
    }

    private static String trim(String s, String t) {
        return URLResolver.trim(s, t, null);
    }

    private static String trim(String s, String r, String t) {
        while (s.endsWith(r) && (t == null || !s.endsWith(t))) {
            int i = s.length() - r.length();
            s = s.substring(0, i);
        }
        return s;
    }

    public static Object getExactMatch(HashMap _g_urlMapExact, String pattern) {
        if (_g_urlMapExact.size() == 0) {
            return null;
        }
        return _g_urlMapExact.get(pattern);
    }

    public static List getAllPrefixMatch(HashMap _g_urlMapPrefix, String pattern) {
        return (List)URLResolver.getPrefixMatch0(_g_urlMapPrefix, pattern, true);
    }

    public static Object getPrefixMatch(HashMap _g_urlMapPrefix, String pattern) {
        return URLResolver.getPrefixMatch0(_g_urlMapPrefix, pattern, false);
    }

    private static Object getPrefixMatch0(HashMap _g_urlMapPrefix, String pattern, boolean all) {
        if (_g_urlMapPrefix.size() == 0) {
            return null;
        }
        ArrayList<Object> list = null;
        if (all) {
            list = new ArrayList<Object>();
        }
        Object wrappers = null;
        String s = pattern;
        while (s.length() > 0) {
            int i;
            String suffix = s.endsWith("/") ? "*" : "/*";
            wrappers = _g_urlMapPrefix.get(s + suffix);
            if (wrappers != null) {
                if (!all) break;
                list.add(wrappers);
                wrappers = null;
            }
            if ((i = s.lastIndexOf("/")) > 0) {
                s = s.substring(0, i);
                continue;
            }
            if (i == 0 && !s.equals("/")) {
                s = "/";
                continue;
            }
            s = "";
        }
        if (all) {
            return list;
        }
        return wrappers;
    }

    public static Object getExtensionMatch(HashMap _g_urlMapExtension, String path) {
        if (_g_urlMapExtension.size() == 0) {
            return null;
        }
        int i = path.lastIndexOf(".");
        int j = path.lastIndexOf("/");
        if (i > -1) {
            String extension = path.substring(i);
            if (j > i) {
                int k = extension.indexOf("/");
                extension = extension.substring(0, k);
            }
            return _g_urlMapExtension.get("*" + extension);
        }
        return null;
    }

    public static void addUrlMapping(HashMap _g_urlMapPrefix, HashMap _g_urlMapExtension, HashMap _g_urlMapExact, String pattern, Object mappedValue) {
        pattern = pattern.trim();
        if (mappedValue != null && pattern.length() > 0) {
            if (pattern.startsWith("/") && pattern.endsWith("/*")) {
                _g_urlMapPrefix.put(pattern, mappedValue);
            } else if (pattern.startsWith("*.")) {
                _g_urlMapExtension.put(pattern, mappedValue);
            } else {
                _g_urlMapExact.put(pattern, mappedValue);
            }
        }
    }
}

