/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.util2.buf;

import java.io.IOException;
import java.io.Serializable;
import jeus.servlet.util2.buf.Ascii;
import jeus.servlet.util2.buf.CharChunk;
import jeus.servlet.util2.buf.HexUtils;

public final class ByteChunk
implements Cloneable,
Serializable {
    public static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";
    private byte[] buff;
    private int start = 0;
    private int end;
    private String enc;
    private boolean isSet = false;
    private int limit = -1;
    private ByteInputChannel in = null;
    private ByteOutputChannel out = null;
    private boolean isOutput = false;
    private boolean optimizedWrite = true;
    private int initStart = 0;
    private boolean chunked = true;
    protected static final String ENCODING_NAME = "chunked";
    protected static final ByteChunk ENCODING = new ByteChunk();
    protected byte[] chunkLength = new byte[10];
    protected static final ByteChunk END_CHUNK = new ByteChunk();

    public ByteChunk() {
    }

    public ByteChunk(int initial) {
        this.allocate(initial, -1, 0);
    }

    public ByteChunk(int initial, int header) {
        this.allocate(initial, -1, header);
    }

    public ByteChunk(int initial, boolean chunked) {
        this.chunked = chunked;
        if (chunked) {
            this.chunkInit();
            this.allocate(initial, -1, 10);
        } else {
            this.allocate(initial, -1, 0);
        }
    }

    public void resetByteChunk(int initial, boolean chunked) {
        if (this.chunked != chunked) {
            this.chunked = chunked;
            if (chunked) {
                this.chunkInit();
                this.allocate(initial, -1, 10);
            } else {
                this.allocate(initial, -1, 0);
            }
        }
    }

    private void chunkInit() {
        this.chunkLength = new byte[10];
        this.chunkLength[8] = 13;
        this.chunkLength[9] = 10;
    }

    public ByteChunk getClone() {
        try {
            return (ByteChunk)this.clone();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean isNull() {
        return !this.isSet;
    }

    public void recycle() {
        this.enc = null;
        this.start = this.initStart;
        this.end = this.initStart;
        this.isSet = false;
    }

    public void reset() {
        this.buff = null;
    }

    public void allocate(int initial, int limit) {
        this.allocate(initial, limit, 0);
    }

    public void allocate(int initial, int limit, int header) {
        System.out.println("[adol] ByteChunk [" + header + "]");
        this.isOutput = true;
        if (this.buff == null || this.buff.length < initial) {
            this.buff = new byte[initial];
        }
        this.limit = limit;
        this.start = this.initStart = header;
        this.end = this.initStart;
        this.isSet = true;
    }

    public void setBytes(byte[] b, int off, int len) {
        this.buff = b;
        this.start = off;
        this.end = this.start + len;
        this.isSet = true;
    }

    public void setOptimizedWrite(boolean optimizedWrite) {
        this.optimizedWrite = optimizedWrite;
    }

    public void setEncoding(String enc) {
        this.enc = enc;
    }

    public byte[] getBytes() {
        return this.getBuffer();
    }

    public byte[] getBuffer() {
        return this.buff;
    }

    public int getStart() {
        return this.start;
    }

    public int getOffset() {
        return this.getStart();
    }

    public void setOffset(int off) {
        if (this.end < off) {
            this.end = off;
        }
        this.start = off;
    }

    public int getLength() {
        return this.end - this.start;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setByteInputChannel(ByteInputChannel in) {
        this.in = in;
    }

    public void setByteOutputChannel(ByteOutputChannel out) {
        this.out = out;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int i) {
        this.end = i;
    }

    public void append(char c) throws IOException {
        this.append((byte)c);
    }

    public void append(byte b) throws IOException {
        this.makeSpace(1);
        if (this.limit > 0 && this.end >= this.limit) {
            this.flushBuffer();
        }
        this.buff[this.end++] = b;
    }

    public void append(ByteChunk src) throws IOException {
        this.append(src.getBytes(), src.getStart(), src.getLength());
    }

    public void append(byte[] src, int off, int len) throws IOException {
        int remain;
        this.makeSpace(len);
        if (this.limit < 0) {
            System.arraycopy(src, off, this.buff, this.end, len);
            this.end += len;
            return;
        }
        if (this.optimizedWrite && len == this.limit && this.end == this.start) {
            this.out.realWriteBytes(src, off, len);
            return;
        }
        if (len <= this.limit - this.end) {
            System.arraycopy(src, off, this.buff, this.end, len);
            this.end += len;
            return;
        }
        int avail = this.limit - this.end;
        System.arraycopy(src, off, this.buff, this.end, avail);
        this.end += avail;
        this.flushBuffer();
        for (remain = len - avail; remain > this.limit - this.end; remain -= this.limit - this.end) {
            this.out.realWriteBytes(src, off + len - remain, this.limit - this.end);
        }
        System.arraycopy(src, off + len - remain, this.buff, this.end, remain);
        this.end += remain;
    }

    public int substract() throws IOException {
        if (this.end - this.start == 0) {
            if (this.in == null) {
                return -1;
            }
            int n = this.in.realReadBytes(this.buff, 0, this.buff.length);
            if (n < 0) {
                return -1;
            }
        }
        return this.buff[this.start++] & 0xFF;
    }

    public int substract(ByteChunk src) throws IOException {
        if (this.end - this.start == 0) {
            if (this.in == null) {
                return -1;
            }
            int n = this.in.realReadBytes(this.buff, 0, this.buff.length);
            if (n < 0) {
                return -1;
            }
        }
        int len = this.getLength();
        src.append(this.buff, this.start, len);
        this.start = this.end;
        return len;
    }

    public int substract(byte[] src, int off, int len) throws IOException {
        int n;
        if (this.end - this.start == 0) {
            if (this.in == null) {
                return -1;
            }
            n = this.in.realReadBytes(this.buff, 0, this.buff.length);
            if (n < 0) {
                return -1;
            }
        }
        n = len;
        if (len > this.getLength()) {
            n = this.getLength();
        }
        System.arraycopy(this.buff, this.start, src, off, n);
        this.start += n;
        return n;
    }

    public void flushBuffer() throws IOException {
        if (this.out == null) {
            throw new IOException("Buffer overflow, no sink " + this.limit + " " + this.buff.length);
        }
        if (this.chunked) {
            int result = this.getLength();
            System.out.println("[adol] ByteChunk::result = " + result);
            if (result <= 0) {
                return;
            }
            for (int i = 0; i < 9; ++i) {
                this.buff[i] = 0;
            }
            int pos = 7;
            for (int current = result; current > 0; current /= 16) {
                int digit = current % 16;
                this.chunkLength[pos--] = HexUtils.HEX[digit];
            }
            int j = 0;
            for (int i = pos + 1; i <= 7; ++i) {
                this.buff[j++] = this.chunkLength[i];
            }
            this.buff[8] = this.chunkLength[8];
            this.buff[9] = this.chunkLength[9];
            this.append(this.chunkLength, 8, 2);
            this.out.realWriteBytes(this.buff, 0, this.end - this.start + 10);
            this.end = this.initStart;
        } else {
            System.out.println("[adol] ByteChunk::buff [" + this.buff.toString() + "]");
            System.out.println("[adol] end [" + this.end + "] start [" + this.start + "]");
            this.out.realWriteBytes(this.buff, 0, this.end - this.start);
            this.end = this.initStart;
        }
    }

    private void makeSpace(int count) {
        byte[] tmp = null;
        int desiredSize = this.end + count;
        if (this.limit > 0 && desiredSize > this.limit) {
            desiredSize = this.limit;
        }
        if (this.buff == null) {
            if (desiredSize < 256) {
                desiredSize = 256;
            }
            this.buff = new byte[desiredSize];
        }
        if (desiredSize <= this.buff.length) {
            return;
        }
        if (desiredSize < 2 * this.buff.length) {
            int newSize = this.buff.length * 2;
            if (this.limit > 0 && newSize > this.limit) {
                newSize = this.limit;
            }
            tmp = new byte[newSize];
        } else {
            int newSize = this.buff.length * 2 + count;
            if (this.limit > 0 && newSize > this.limit) {
                newSize = this.limit;
            }
            tmp = new byte[newSize];
        }
        System.arraycopy(this.buff, this.start, tmp, 0, this.end - this.start);
        this.buff = tmp;
        tmp = null;
        this.end -= this.start;
        this.start = this.initStart;
    }

    public String toString() {
        if (null == this.buff) {
            return null;
        }
        Object strValue = null;
        try {
            if (this.enc == null) {
                this.enc = DEFAULT_CHARACTER_ENCODING;
            }
            return new String(this.buff, this.start, this.end - this.start, this.enc);
        }
        catch (IOException e) {
            return null;
        }
    }

    public int getInt() {
        return Ascii.parseInt(this.buff, this.start, this.end - this.start);
    }

    public long getLong() {
        return Ascii.parseLong(this.buff, this.start, this.end - this.start);
    }

    public boolean equals(String s) {
        byte[] b = this.buff;
        int blen = this.end - this.start;
        if (b == null || blen != s.length()) {
            return false;
        }
        int boff = this.start;
        for (int i = 0; i < blen; ++i) {
            if (b[boff++] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String s) {
        byte[] b = this.buff;
        int blen = this.end - this.start;
        if (b == null || blen != s.length()) {
            return false;
        }
        int boff = this.start;
        for (int i = 0; i < blen; ++i) {
            if (Ascii.toLower(b[boff++]) == Ascii.toLower(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(ByteChunk bb) {
        return this.equals(bb.getBytes(), bb.getStart(), bb.getLength());
    }

    public boolean equals(byte[] b2, int off2, int len2) {
        byte[] b1 = this.buff;
        if (b1 == null && b2 == null) {
            return true;
        }
        int len = this.end - this.start;
        if (len2 != len || b1 == null || b2 == null) {
            return false;
        }
        int off1 = this.start;
        while (len-- > 0) {
            if (b1[off1++] == b2[off2++]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(CharChunk cc) {
        return this.equals(cc.getChars(), cc.getStart(), cc.getLength());
    }

    public boolean equals(char[] c2, int off2, int len2) {
        byte[] b1 = this.buff;
        if (c2 == null && b1 == null) {
            return true;
        }
        if (b1 == null || c2 == null || this.end - this.start != len2) {
            return false;
        }
        int off1 = this.start;
        int len = this.end - this.start;
        while (len-- > 0) {
            if ((char)b1[off1++] == c2[off2++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String s) {
        byte[] b = this.buff;
        int blen = s.length();
        if (b == null || blen > this.end - this.start) {
            return false;
        }
        int boff = this.start;
        for (int i = 0; i < blen; ++i) {
            if (b[boff++] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(byte[] b2) {
        byte[] b1 = this.buff;
        if (b1 == null && b2 == null) {
            return true;
        }
        int len = this.end - this.start;
        if (b1 == null || b2 == null || b2.length > len) {
            return false;
        }
        int i = this.start;
        int j = 0;
        while (i < this.end && j < b2.length) {
            if (b1[i++] == b2[j++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWithIgnoreCase(String s, int pos) {
        byte[] b = this.buff;
        int len = s.length();
        if (b == null || len + pos > this.end - this.start) {
            return false;
        }
        int off = this.start + pos;
        for (int i = 0; i < len; ++i) {
            if (Ascii.toLower(b[off++]) == Ascii.toLower(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public int indexOf(String src, int srcOff, int srcLen, int myOff) {
        char first = src.charAt(srcOff);
        int srcEnd = srcOff + srcLen;
        for (int i = myOff + this.start; i <= this.end - srcLen; ++i) {
            if (this.buff[i] != first) continue;
            int myPos = i + 1;
            int srcPos = srcOff + 1;
            while (srcPos < srcEnd && this.buff[myPos++] == src.charAt(srcPos++)) {
                if (srcPos != srcEnd) continue;
                return i - this.start;
            }
        }
        return -1;
    }

    public int hash() {
        return ByteChunk.hashBytes(this.buff, this.start, this.end - this.start);
    }

    public int hashIgnoreCase() {
        return ByteChunk.hashBytesIC(this.buff, this.start, this.end - this.start);
    }

    private static int hashBytes(byte[] buff, int start, int bytesLen) {
        int max = start + bytesLen;
        byte[] bb = buff;
        int code = 0;
        for (int i = start; i < max; ++i) {
            code = code * 37 + bb[i];
        }
        return code;
    }

    private static int hashBytesIC(byte[] bytes, int start, int bytesLen) {
        int max = start + bytesLen;
        byte[] bb = bytes;
        int code = 0;
        for (int i = start; i < max; ++i) {
            code = code * 37 + Ascii.toLower(bb[i]);
        }
        return code;
    }

    public int indexOf(char c, int starting) {
        int ret = ByteChunk.indexOf(this.buff, this.start + starting, this.end, c);
        return ret >= this.start ? ret - this.start : -1;
    }

    public static int indexOf(byte[] bytes, int off, int end, char qq) {
        while (off < end) {
            byte b = bytes[off];
            if (b == qq) {
                return off;
            }
            ++off;
        }
        return -1;
    }

    public static int findChar(byte[] buf, int start, int end, char c) {
        byte b = (byte)c;
        for (int offset = start; offset < end; ++offset) {
            if (buf[offset] != b) continue;
            return offset;
        }
        return -1;
    }

    public static int findChars(byte[] buf, int start, int end, byte[] c) {
        int clen = c.length;
        for (int offset = start; offset < end; ++offset) {
            for (int i = 0; i < clen; ++i) {
                if (buf[offset] != c[i]) continue;
                return offset;
            }
        }
        return -1;
    }

    public static int findNotChars(byte[] buf, int start, int end, byte[] c) {
        int clen = c.length;
        for (int offset = start; offset < end; ++offset) {
            boolean found = true;
            for (int i = 0; i < clen; ++i) {
                if (buf[offset] != c[i]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return offset;
        }
        return -1;
    }

    static {
        ENCODING.setBytes(ENCODING_NAME.getBytes(), 0, ENCODING_NAME.length());
        byte[] END_CHUNK_BYTES = new byte[]{48, 13, 10, 13, 10};
        END_CHUNK.setBytes(END_CHUNK_BYTES, 0, END_CHUNK_BYTES.length);
    }

    public static interface ByteOutputChannel {
        public void realWriteBytes(byte[] var1, int var2, int var3) throws IOException;
    }

    public static interface ByteInputChannel {
        public int realReadBytes(byte[] var1, int var2, int var3) throws IOException;
    }
}

