/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.util2.http;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import jeus.servlet.util2.buf.MessageBytes;
import jeus.servlet.util2.http.MimeHeaderField;
import jeus.servlet.util2.http.NamesEnumerator;
import jeus.servlet.util2.http.ValuesEnumerator;

public class MimeHeaders {
    public static final int DEFAULT_HEADER_SIZE = 8;
    private MimeHeaderField[] headers = new MimeHeaderField[8];
    private int count;

    public void recycle() {
        this.clear();
    }

    public void clear() {
        for (int i = 0; i < this.count; ++i) {
            this.headers[i].recycle();
        }
        this.count = 0;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("=== MimeHeaders ===");
        Enumeration e = this.names();
        while (e.hasMoreElements()) {
            String n = (String)e.nextElement();
            pw.println(n + " = " + this.getHeader(n));
        }
        return sw.toString();
    }

    public int size() {
        return this.count;
    }

    public MessageBytes getName(int n) {
        return n >= 0 && n < this.count ? this.headers[n].getName() : null;
    }

    public MessageBytes getValue(int n) {
        return n >= 0 && n < this.count ? this.headers[n].getValue() : null;
    }

    public int findHeader(String name, int starting) {
        for (int i = starting; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    public Enumeration names() {
        return new NamesEnumerator(this);
    }

    public Enumeration values(String name) {
        return new ValuesEnumerator(this, name);
    }

    private MimeHeaderField createHeader() {
        MimeHeaderField mh;
        int len = this.headers.length;
        if (this.count >= len) {
            MimeHeaderField[] tmp = new MimeHeaderField[this.count * 2];
            System.arraycopy(this.headers, 0, tmp, 0, len);
            this.headers = tmp;
        }
        if ((mh = this.headers[this.count]) == null) {
            this.headers[this.count] = mh = new MimeHeaderField();
        }
        ++this.count;
        return mh;
    }

    public MessageBytes addValue(String name) {
        MimeHeaderField mh = this.createHeader();
        mh.getName().setString(name);
        return mh.getValue();
    }

    public MessageBytes addValue(byte[] b, int startN, int len) {
        MimeHeaderField mhf = this.createHeader();
        mhf.getName().setBytes(b, startN, len);
        return mhf.getValue();
    }

    public MessageBytes addValue(char[] c, int startN, int len) {
        MimeHeaderField mhf = this.createHeader();
        mhf.getName().setChars(c, startN, len);
        return mhf.getValue();
    }

    public MessageBytes setValue(String name) {
        System.out.println("[adol] MimeHeader1");
        MessageBytes value = this.getValue(name);
        if (value == null) {
            System.out.println("[adol] MimeHeader2");
            MimeHeaderField mh = this.createHeader();
            mh.getName().setString(name);
            value = mh.getValue();
        }
        System.out.println("[adol] MimeHeader3");
        return value;
    }

    public MessageBytes getValue(String name) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(name)) continue;
            return this.headers[i].getValue();
        }
        return null;
    }

    public String getHeader(String name) {
        MessageBytes mh = this.getValue(name);
        return mh != null ? mh.toString() : null;
    }

    public void removeHeader(String name) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(name)) continue;
            MimeHeaderField mh = this.headers[i];
            mh.recycle();
            this.headers[i] = this.headers[this.count - 1];
            this.headers[this.count - 1] = mh;
            --this.count;
            --i;
        }
    }
}

