/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.Invocation;
import jeus.sessionmanager.Router;
import jeus.sessionmanager.RouterConfig;
import jeus.sessionmanager.WebInvocation;
import jeus.sessionmanager.WebRouterConfig;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Session4;

public class JkRouter
implements Router {
    private static final JeusLogger logger = Constants.SESSION_LOGGER;
    private String suffix;
    private RouterConfig config;

    public JkRouter() {
        this(null);
    }

    public JkRouter(String suffix) {
        this.setSuffix(suffix);
    }

    public void init(RouterConfig config) {
        this.config = config;
    }

    public void destroy() {
        this.config = null;
    }

    public String strip(String id) {
        int i = id.indexOf(46);
        if (i < 0) {
            return id;
        }
        return id.substring(0, i);
    }

    public String augment(String id) {
        return this.augment(id, this.suffix);
    }

    private String augment(String id, String target) {
        if (id == null) {
            return id;
        }
        if (!target.startsWith(".")) {
            return id;
        }
        int i = id.indexOf(46);
        if (i < 0) {
            return id + target;
        }
        if (id.endsWith(target)) {
            return id;
        }
        return id.substring(0, i) + target;
    }

    public boolean reroute(Invocation invocation) {
        if (!(invocation instanceof WebInvocation)) {
            return false;
        }
        WebInvocation webInvocation = (WebInvocation)invocation;
        HttpServletRequest req = webInvocation.getHttpServletRequest();
        HttpServletResponse res = webInvocation.getHttpServletResponse();
        String id = req.getRequestedSessionId();
        return !this.isRoutingIdMatched(id) && req.isRequestedSessionIdFromCookie() && this.rerouteCookie(req, res, id);
    }

    public boolean isStickySession() {
        return true;
    }

    public boolean isRoutingIdMatched(String id) {
        if (id == null) {
            return false;
        }
        return id.endsWith(this.suffix);
    }

    private boolean rerouteCookie(HttpServletRequest req, HttpServletResponse res, String id) {
        return this.rerouteCookie(req, res, id, this.suffix);
    }

    private boolean rerouteCookie(HttpServletRequest req, HttpServletResponse res, String oldId, String target) {
        if (!(this.config instanceof WebRouterConfig)) {
            return false;
        }
        WebRouterConfig webRouterConfig = (WebRouterConfig)this.config;
        if (!target.startsWith(".")) {
            return false;
        }
        String newId = this.augment(oldId);
        if (logger.isLoggable(JeusMessage_Session4._49011_LEVEL)) {
            logger.log(JeusMessage_Session4._49011_LEVEL, JeusMessage_Session4._49011, new Object[]{oldId, newId});
        }
        Cookie[] cookies = req.getCookies();
        for (int i = 0; i < cookies.length; ++i) {
            String cookieDomain;
            Cookie cookie = cookies[i];
            if (!cookie.getName().equalsIgnoreCase(webRouterConfig.getSessionCookieName(req)) || !cookie.getValue().equals(oldId)) continue;
            String cookiePath = webRouterConfig.getSessionCookiePath(req);
            if (cookiePath != null && cookiePath.length() > 0) {
                cookie.setPath(cookiePath);
            }
            if ((cookieDomain = webRouterConfig.getSessionCookieDomain(req)) != null && cookieDomain.length() > 0) {
                cookie.setDomain(cookieDomain);
            }
            cookie.setVersion(webRouterConfig.getSessionCookieVersion(req));
            cookie.setMaxAge(webRouterConfig.getSessionCookieMaxAge(req));
            cookie.setSecure(webRouterConfig.isSessionCookieSecure(req));
            cookie.setValue(newId);
            res.addCookie(cookie);
        }
        return true;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix == null ? "" : "." + suffix;
    }
}

