/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.central;

import java.io.IOException;
import java.util.Vector;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.central.SessionManager;
import jeus.sessionmanager.central.SessionManagerClient;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Session2;

public class BackupThread
extends Thread {
    private static final JeusLogger logger = Constants.CENTRAL_SESSION_LOGGER;
    private SessionManager manager;
    private boolean closed = false;
    private Thread thread;
    private SessionManagerClient backup = null;
    private String backupName;
    private final Object backupSyn = new Object();
    private boolean isInterrupted = false;
    private boolean isSleeping = false;
    private boolean isBlockingBackup = false;
    private final Object blockingBackupSyn = new Object();
    private static int BLOCKING_BACKUP_MAX_WAIT_TIME = 10000;
    private long checkTO;
    private long connectionTimeout;
    private long replyWaitTimeout;

    public BackupThread(SessionManager manager, SessionManagerClient backup, String backupName, long checkTO, long connectionTimeout, long replyWaitTimeout) {
        super("jeus.server.session.BackupThread");
        this.manager = manager;
        this.backup = backup;
        this.backupName = backupName;
        this.checkTO = checkTO;
        this.connectionTimeout = connectionTimeout;
        this.replyWaitTimeout = replyWaitTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backup() {
        if (this.isSleeping && !this.isInterrupted) {
            Object object = this.backupSyn;
            synchronized (object) {
                if (this.isSleeping && !this.isInterrupted) {
                    this.thread.interrupt();
                    this.isInterrupted = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckTO(long i) {
        Object object = this.backupSyn;
        synchronized (object) {
            this.checkTO = i;
        }
    }

    public long getCheckTO() {
        return this.checkTO;
    }

    public String getBackupServerName() {
        return this.backupName;
    }

    public boolean isBackupConnected() {
        if (this.backup == null) {
            return false;
        }
        try {
            this.backup.alive();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void close() {
        this.closed = true;
        if (this.backup != null) {
            this.backup.destroy();
            this.backup = null;
        }
        this.thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.thread = Thread.currentThread();
        boolean errorLoggingDone = false;
        while (true) {
            Vector list;
            Object object;
            Object object2 = this.backupSyn;
            synchronized (object2) {
                try {
                    this.isSleeping = true;
                    this.backupSyn.wait(this.checkTO);
                    this.isSleeping = false;
                }
                catch (Throwable ex) {
                    if (this.closed) {
                        return;
                    }
                    this.isInterrupted = false;
                    this.isSleeping = false;
                    Thread.interrupted();
                }
            }
            if (!this.isBackupConnected()) {
                this.backup = new SessionManagerClient(this.backupName, this.connectionTimeout, this.replyWaitTimeout);
                try {
                    this.backup.initialize();
                    this.backup.alive();
                }
                catch (Throwable ex) {
                    if (!errorLoggingDone) {
                        if (logger.isLoggable(JeusMessage_Session2._21002_LEVEL)) {
                            logger.log(JeusMessage_Session2._21002_LEVEL, JeusMessage_Session2._21002, (Object[])new String[]{this.manager.getServerName(), this.backupName}, ex);
                        }
                        errorLoggingDone = true;
                    }
                    this.backup.destroy();
                    this.backup = null;
                    this.manager.backupDead();
                    if (!this.isBlockingBackup) continue;
                    object = this.blockingBackupSyn;
                    synchronized (object) {
                        if (this.isBlockingBackup) {
                            this.blockingBackupSyn.notify();
                            this.isBlockingBackup = false;
                        }
                        continue;
                    }
                }
                if (logger.isLoggable(JeusMessage_Session2._21003_LEVEL)) {
                    logger.log(JeusMessage_Session2._21003_LEVEL, JeusMessage_Session2._21003, (Object[])new String[]{this.manager.getServerName(), this.backupName});
                }
                list = this.manager.getBackupData(true);
            } else {
                list = this.manager.getBackupData(false);
            }
            if (!this.manager.recovered) {
                this.manager.doRecovery(this.backup);
            }
            if (list.size() != 0 && this.backup != null) {
                try {
                    this.backup.dumpBackup(list);
                    if (logger.isLoggable(JeusMessage_Session2._21303_LEVEL)) {
                        logger.log(JeusMessage_Session2._21303_LEVEL, JeusMessage_Session2._21303, (Object[])new String[]{this.manager.getServerName(), this.backupName});
                    }
                }
                catch (Throwable ex) {
                    if (ex instanceof IOException) {
                        if (logger.isLoggable(JeusMessage_Session2._21002_LEVEL)) {
                            logger.log(JeusMessage_Session2._21002_LEVEL, JeusMessage_Session2._21002, (Object[])new String[]{this.manager.getServerName(), this.backupName}, ex);
                        }
                    } else if (logger.isLoggable(JeusMessage_Session2._21320_LEVEL)) {
                        logger.log(JeusMessage_Session2._21320_LEVEL, ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21320, (Object)this.manager.getServerName()), ex);
                    }
                    if (this.backup != null) {
                        this.backup.destroy();
                        this.backup = null;
                    }
                    this.manager.backupDead();
                    errorLoggingDone = false;
                    if (!this.isBlockingBackup) continue;
                    object = this.blockingBackupSyn;
                    synchronized (object) {
                        if (this.isBlockingBackup) {
                            this.blockingBackupSyn.notify();
                            this.isBlockingBackup = false;
                        }
                        continue;
                    }
                }
            }
            if (!this.isBlockingBackup) continue;
            object2 = this.blockingBackupSyn;
            synchronized (object2) {
                if (this.isBlockingBackup) {
                    this.blockingBackupSyn.notify();
                    this.isBlockingBackup = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockingBackup() {
        if (!this.isBlockingBackup) {
            Object object = this.blockingBackupSyn;
            synchronized (object) {
                if (!this.isBlockingBackup) {
                    this.isBlockingBackup = true;
                    this.backup();
                }
                try {
                    this.blockingBackupSyn.wait(BLOCKING_BACKUP_MAX_WAIT_TIME);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

