/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.central;

public class CentralConstants {
    public static final boolean ASYNC_MODE;
    public static final boolean SESSION_CLIENT_USE_NIO;
    public static final boolean SESSION_GLOBAL_USE_SSL;
    public static final int CONNECTION_RETRY_COUNT;
    public static final int WRITE_BUFFER_LIMIT_BYTE;
    public static final int WRITE_BUFFER_RESTART_BYTE;
    public static final boolean NEW_SESSION_CONSISTENT;
    public static final long SESSION_MEMORY_LIMIT_BYTES;
    public static final double SESSION_MEMORY_LIMIT_RATIO;
    public static final boolean SESSION_MEMORY_LIMIT_GC_FORCEFULLY;
    public static final int RECOVERY_TRY_COUNT;
    public static final boolean IO_FAIL_RETRY;

    static {
        String tempString = "";
        int tempInt = 0;
        long tempLong = 0L;
        double tempDouble = 0.0;
        tempString = System.getProperty("jeus.sessionserver.async");
        ASYNC_MODE = tempString != null && tempString.equalsIgnoreCase("true");
        tempString = System.getProperty("jeus.sessionserver.clientusenio");
        SESSION_CLIENT_USE_NIO = tempString == null || !tempString.equalsIgnoreCase("false");
        tempString = System.getProperty("jeus.sessionserver.usessl");
        SESSION_GLOBAL_USE_SSL = tempString != null && tempString.equalsIgnoreCase("true");
        tempString = System.getProperty("jeus.sessionserver.retrycount");
        if (tempString != null) {
            try {
                tempInt = Integer.parseInt(tempString);
            }
            catch (NumberFormatException e) {
                tempInt = 1;
            }
        } else {
            tempInt = 1;
        }
        CONNECTION_RETRY_COUNT = tempInt;
        tempString = System.getProperty("jeus.sessionserver.writequeuelimit");
        if (tempString != null) {
            try {
                tempInt = Integer.parseInt(tempString);
            }
            catch (NumberFormatException e) {
                tempInt = 0xA00000;
            }
        } else {
            tempInt = 0xA00000;
        }
        WRITE_BUFFER_LIMIT_BYTE = tempInt;
        tempString = System.getProperty("jeus.sessionserver.writequeuerestart");
        if (tempString != null) {
            try {
                tempInt = Integer.parseInt(tempString);
            }
            catch (NumberFormatException e) {
                tempInt = 0x300000;
            }
        } else {
            tempInt = 0x300000;
        }
        WRITE_BUFFER_RESTART_BYTE = tempInt;
        tempString = System.getProperty("jeus.sessionserver.sessionconsistent");
        NEW_SESSION_CONSISTENT = tempString == null || !tempString.equalsIgnoreCase("false");
        tempString = System.getProperty("jeus.sessionserver.memory.max");
        if (tempString != null) {
            try {
                if (tempString.endsWith("m") || tempString.endsWith("M")) {
                    tempString = tempString.substring(0, tempString.length() - 1);
                    tempLong = Integer.parseInt(tempString) * 1024 * 1024;
                } else if (tempString.endsWith("k") || tempString.endsWith("K")) {
                    tempString = tempString.substring(0, tempString.length() - 1);
                    tempLong = Integer.parseInt(tempString) * 1024;
                } else {
                    tempLong = Long.parseLong(tempString);
                }
            }
            catch (NumberFormatException nfe) {
                tempLong = -1L;
            }
            catch (IndexOutOfBoundsException ioobe) {
                tempLong = -1L;
            }
            SESSION_MEMORY_LIMIT_BYTES = tempLong;
        } else {
            SESSION_MEMORY_LIMIT_BYTES = -1L;
        }
        tempString = System.getProperty("jeus.sessionserver.memory.passivationratio");
        if (tempString != null) {
            try {
                tempDouble = Double.parseDouble(tempString);
            }
            catch (NumberFormatException nfe) {
                tempDouble = 0.2;
            }
            if (tempDouble <= 0.0 || tempDouble > 1.0) {
                tempDouble = 0.2;
            }
            SESSION_MEMORY_LIMIT_RATIO = tempDouble;
        } else {
            SESSION_MEMORY_LIMIT_RATIO = 0.2;
        }
        tempString = System.getProperty("jeus.sessionserver.memory.enablegc");
        SESSION_MEMORY_LIMIT_GC_FORCEFULLY = tempString == null || !tempString.equalsIgnoreCase("false");
        tempString = System.getProperty("jeus.sessionserver.recovery.trycount");
        if (tempString != null) {
            try {
                tempInt = Integer.parseInt(tempString);
            }
            catch (NumberFormatException e) {
                tempInt = 3;
            }
            if (tempInt <= 0) {
                tempInt = 3;
            }
        } else {
            tempInt = 3;
        }
        RECOVERY_TRY_COUNT = tempInt;
        tempString = System.getProperty("jeus.sessionserver.io.retry");
        IO_FAIL_RETRY = tempString != null && tempString.equalsIgnoreCase("true");
    }
}

