/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.central;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.central.SessionManagerClient;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Session2;

public final class SessionServerConnector {
    private static final JeusLogger logger = Constants.CENTRAL_SESSION_LOGGER;
    private SessionManagerClient sessionManagerClient;
    private String serverName;
    private String mailSubject;
    private int connectorId = -1;
    private final ReentrantReadWriteLock rRWlock = new ReentrantReadWriteLock(true);
    private final Lock readLock = this.rRWlock.readLock();
    private final Lock writeLock = this.rRWlock.writeLock();

    public SessionServerConnector(String engineName, String svrname) {
        this.serverName = svrname;
        this.mailSubject = "[FATAL] [" + engineName + "] Session Clustering Error Notify";
        this.connectorId = 0;
    }

    public void initialize(long connectTimeout, long readTimeout) throws Exception {
        this.initialize(null, connectTimeout, readTimeout);
    }

    private void initialize(String serverName, long connectTimeout, long readTimeout) throws Exception {
        if (serverName != null) {
            this.serverName = serverName;
        }
        if (this.connectorId >= Integer.MAX_VALUE) {
            this.connectorId = 0;
        }
        ++this.connectorId;
        this.sessionManagerClient = new SessionManagerClient(this.connectorId, this.serverName, connectTimeout, readTimeout);
        try {
            this.sessionManagerClient.initialize();
        }
        catch (Exception e) {
            this.sessionManagerClient.destroy();
            this.sessionManagerClient = null;
            throw new Exception("failed to initialize a SessionManagerClient", e);
        }
    }

    public void destroy() {
        if (this.sessionManagerClient != null) {
            this.sessionManagerClient.destroy();
            this.sessionManagerClient = null;
        }
        if (logger.isLoggable(JeusMessage_Session2._21400_LEVEL)) {
            logger.log(JeusMessage_Session2._21400_LEVEL, JeusMessage_Session2._21400, (Object)this.serverName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(String id, byte[] data) throws Exception {
        this.readLock.lock();
        try {
            if (this.sessionManagerClient == null) {
                throw new Exception(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21401, (Object)this.serverName));
            }
            this.sessionManagerClient.addSession(id, data);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(String id, byte[] data, int len) throws Exception {
        this.readLock.lock();
        try {
            if (this.sessionManagerClient == null) {
                throw new Exception(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21401, (Object)this.serverName));
            }
            this.sessionManagerClient.addSession(id, data, len);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewSession(String id, byte[] data) throws Exception {
        this.readLock.lock();
        try {
            if (this.sessionManagerClient == null) {
                throw new Exception(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21401, (Object)this.serverName));
            }
            this.sessionManagerClient.addNewSession(id, data);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewSession(String id, byte[] data, int len) throws Exception {
        this.readLock.lock();
        try {
            if (this.sessionManagerClient == null) {
                throw new Exception(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21401, (Object)this.serverName));
            }
            this.sessionManagerClient.addNewSession(id, data, len);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSession(String id) throws Exception {
        this.readLock.lock();
        try {
            if (this.sessionManagerClient == null) {
                throw new Exception(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21401, (Object)this.serverName));
            }
            byte[] byArray = this.sessionManagerClient.getServletSession(id);
            return byArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] findSession(String id) throws Exception {
        this.readLock.lock();
        try {
            if (this.sessionManagerClient == null) {
                throw new Exception(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21401, (Object)this.serverName));
            }
            byte[] byArray = this.sessionManagerClient.getSession(id);
            return byArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(String id) throws Exception {
        this.readLock.lock();
        try {
            if (this.sessionManagerClient == null) {
                throw new Exception(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21401, (Object)this.serverName));
            }
            this.sessionManagerClient.removeSession(id);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAllSessionsSize() throws Exception {
        this.readLock.lock();
        try {
            if (this.sessionManagerClient == null) {
                throw new Exception(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21401, (Object)this.serverName));
            }
            int n = this.sessionManagerClient.getAllSessionsSize();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveSessionsSize() throws Exception {
        this.readLock.lock();
        try {
            if (this.sessionManagerClient == null) {
                throw new Exception(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21401, (Object)this.serverName));
            }
            int n = this.sessionManagerClient.getActiveSessionsSize();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPassivateSessionsSize() throws Exception {
        this.readLock.lock();
        try {
            if (this.sessionManagerClient == null) {
                throw new Exception(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21401, (Object)this.serverName));
            }
            int n = this.sessionManagerClient.getPassivateSessionsSize();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean checkReady(String svrname, long connectTimeout, long readTimeout) {
        SessionManagerClient conn = new SessionManagerClient(svrname, connectTimeout, readTimeout);
        try {
            conn.initialize();
            if (!conn.isRecovery()) {
                conn.destroy();
                conn = null;
                return false;
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_Session2._21402_LEVEL)) {
                logger.log(JeusMessage_Session2._21402_LEVEL, JeusMessage_Session2._21402, (Object)svrname, (Throwable)e);
            }
            conn.destroy();
            conn = null;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeover(String altServer, boolean forced, String cause, long connectTimeout, long readTimeout) {
        this.writeLock.lock();
        try {
            this.takeoverNotThreadSafe(altServer, forced, cause, connectTimeout, readTimeout);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeover(String server1, String server2, int checkingId, String cause, Exception exception, long connectTimeout, long readTimeout) {
        String altServer = null;
        if (checkingId != this.connectorId) {
            return;
        }
        this.writeLock.lock();
        try {
            if (checkingId != this.connectorId) {
                return;
            }
            altServer = this.serverName.equals(server1) ? server2 : server1;
            if (altServer == null) {
                return;
            }
            this.takeoverNotThreadSafe(altServer, this.isFatalError(exception), cause, connectTimeout, readTimeout);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void takeoverNotThreadSafe(String altServer, boolean forced, String cause, long connectTimeout, long readTimeout) {
        block4: {
            if (!forced && this.checkConnector()) {
                return;
            }
            if (altServer == null) {
                altServer = this.serverName;
            }
            this.emailNotify(altServer, cause);
            this.destroy();
            try {
                this.initialize(altServer, connectTimeout, readTimeout);
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_Session2._21403_LEVEL)) break block4;
                logger.log(JeusMessage_Session2._21403_LEVEL, JeusMessage_Session2._21403, (Object)altServer, (Throwable)e);
            }
        }
    }

    private final void emailNotify(final String altServer, final String cause) {
        Runnable runner = new Runnable(){

            public void run() {
                try {
                    String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21404, (Object[])new String[]{altServer, SessionServerConnector.this.serverName, cause});
                    if (logger.isLoggable(JeusMessage_Session2._21404_LEVEL)) {
                        logger.sendEmailNotification(JeusMessage_Session2._21404_LEVEL, SessionServerConnector.this.mailSubject, msg);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Thread email = new Thread(runner);
        email.setDaemon(true);
        email.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkConnector() {
        this.readLock.lock();
        try {
            if (this.sessionManagerClient == null) {
                throw new Exception(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session2._21401, (Object)this.serverName));
            }
            this.sessionManagerClient.alive();
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
        return true;
    }

    private boolean isFatalError(Exception e) {
        return e instanceof IOException || e instanceof RemoteException;
    }

    public String getServerName() {
        return this.serverName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentConnections() {
        this.readLock.lock();
        try {
            if (this.sessionManagerClient == null) {
                if (logger.isLoggable(JeusMessage_Session2._21401_LEVEL)) {
                    logger.log(JeusMessage_Session2._21401_LEVEL, JeusMessage_Session2._21401, (Object)this.serverName);
                }
                int n = 0;
                return n;
            }
            int n = this.sessionManagerClient.getCurrentConnections();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getConnectorId() {
        return this.connectorId;
    }
}

