/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.central;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.central.Entry;
import jeus.sessionmanager.central.SessionServerException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Session2;

public class SessionStorage {
    private static final JeusLogger logger = Constants.CENTRAL_SESSION_LOGGER;
    private String fileDBPath;
    private String fileDBName;
    private File file1;
    private File file2;
    private RandomAccessFile DBfile;
    private final Hashtable table;
    private int numHole = 0;
    private float packingRate = 0.5f;
    private int minHole = 1000;
    private AtomicLong removalTO;
    private final Switch trigger = new Switch(true);

    public SessionStorage(String dbPath, String dbName, long removalTO, int initCap) throws SessionServerException {
        this.fileDBPath = dbPath;
        this.fileDBName = dbName;
        this.removalTO = new AtomicLong(removalTO);
        this.table = new Hashtable(initCap);
        this.makeDBFile();
    }

    private void makeDBFile() throws SessionServerException {
        try {
            String fileName = this.fileDBPath + File.separator + this.fileDBName + "1" + ".fdb";
            this.file1 = new File(fileName);
            String parent = this.file1.getParent();
            if (parent != null) {
                new File(parent).mkdirs();
            }
            fileName = this.fileDBPath + File.separator + this.fileDBName + "2" + ".fdb";
            this.file2 = new File(fileName);
            this.DBfile = new RandomAccessFile(this.file1, "rw");
        }
        catch (IOException ex) {
            throw new SessionServerException(JeusMessage_Session2._21020, (Throwable)ex);
        }
    }

    public int getSessionSize() {
        return this.table.size();
    }

    public void setPackingRate(float rate) {
        this.packingRate = rate;
    }

    public float getPackingRate() {
        return this.packingRate;
    }

    public void setMinHole(int num) {
        this.minHole = num;
    }

    public int getMinHole() {
        return this.minHole;
    }

    public int size() {
        return this.table.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getEntries() {
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            return new Hashtable(this.table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAllSessionIds() {
        Set set = null;
        HashSet<String> Ids = new HashSet<String>();
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            set = this.table.keySet();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                Ids.add((String)((Entry)it.next()).key);
            }
        }
        return Ids;
    }

    public void store(Entry key, byte[] value) throws SessionServerException {
        try {
            SessionStorageEntry entry = this.write(value);
            this.addEntry(key, entry);
        }
        catch (IOException e) {
            throw new SessionServerException(JeusMessage_Session2._21022, (Throwable)e);
        }
    }

    public byte[] load(Entry key, boolean remove) throws SessionServerException {
        try {
            SessionStorageEntry entry = remove ? this.removeEntry(key) : this.getEntry(key);
            return this.loadEntry(entry);
        }
        catch (IOException e) {
            throw new SessionServerException(JeusMessage_Session2._21024, (Throwable)e);
        }
    }

    public byte[] load(Entry key) throws SessionServerException {
        return this.load(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExist(String id) {
        Entry key = new Entry(id, null, 0L);
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            return this.table.containsKey(key);
        }
    }

    public synchronized long fileSize() {
        try {
            return this.DBfile.getFilePointer();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized SessionStorageEntry write(byte[] obj) throws IOException {
        if (this.numHole > this.minHole && (float)this.numHole / (float)this.table.size() >= this.packingRate) {
            this.packing();
        }
        long filePointer = this.DBfile.getFilePointer();
        try {
            SessionStorageEntry sessionStorageEntry = new SessionStorageEntry(filePointer, obj.length);
            return sessionStorageEntry;
        }
        finally {
            this.DBfile.write(obj);
        }
    }

    private synchronized byte[] loadEntry(SessionStorageEntry entry) throws IOException {
        byte[] data = new byte[entry.length];
        long current = this.DBfile.getFilePointer();
        this.DBfile.seek(entry.position);
        this.DBfile.read(data);
        this.DBfile.seek(current);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void packing() throws IOException {
        RandomAccessFile newDBfile = new RandomAccessFile(this.trigger.flip() ? this.file1 : this.file2, "rw");
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            Enumeration e = this.table.elements();
            while (e.hasMoreElements()) {
                SessionStorageEntry entry = (SessionStorageEntry)e.nextElement();
                byte[] buffer = new byte[entry.length];
                this.DBfile.seek(entry.position);
                this.DBfile.read(buffer);
                entry.position = newDBfile.getFilePointer();
                newDBfile.write(buffer);
            }
        }
        try {
            this.DBfile.setLength(0L);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.DBfile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.DBfile = newDBfile;
        this.numHole = 0;
    }

    public synchronized void clear() {
        try {
            this.DBfile.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.file1.delete();
        this.file2.delete();
        this.table.clear();
    }

    public void setRemovalTO(long timeout) {
        if (timeout < 0L) {
            return;
        }
        this.removalTO.set(timeout);
    }

    private void addEntry(Object key, SessionStorageEntry entry) {
        SessionStorageEntry prev = this.table.put(key, entry);
        if (prev != null) {
            ++this.numHole;
            if (logger.isLoggable(JeusMessage_Session2._21023_LEVEL)) {
                logger.log(JeusMessage_Session2._21023_LEVEL, JeusMessage_Session2._21023, key);
            }
        }
    }

    private SessionStorageEntry getEntry(Object key) throws SessionServerException {
        SessionStorageEntry entry = (SessionStorageEntry)this.table.get(key);
        if (entry == null) {
            throw new SessionServerException(JeusMessage_Session2._21023, key.toString());
        }
        return entry;
    }

    private SessionStorageEntry removeEntry(Object key) throws SessionServerException {
        SessionStorageEntry entry = (SessionStorageEntry)this.table.remove(key);
        if (entry == null) {
            throw new SessionServerException(JeusMessage_Session2._21023, key.toString());
        }
        ++this.numHole;
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession() {
        if (this.removalTO.get() == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            Enumeration entries = this.table.keys();
            while (entries.hasMoreElements()) {
                Entry entry = (Entry)entries.nextElement();
                boolean expired = currentTime - entry.lastAccessTime > this.removalTO.get();
                if (!expired) continue;
                this.table.remove(entry);
                ++this.numHole;
            }
        }
    }

    public boolean remove(Entry key) {
        SessionStorageEntry entry = (SessionStorageEntry)this.table.remove(key);
        if (entry != null) {
            ++this.numHole;
            return true;
        }
        return false;
    }

    private class Switch {
        private boolean value;

        Switch(boolean value) {
            this.value = value;
        }

        synchronized boolean flip() {
            this.value = !this.value;
            return this.value;
        }
    }

    private class SessionStorageEntry {
        private long position;
        private int length;

        public SessionStorageEntry(long position, int length) {
            this.position = position;
            this.length = length;
        }
    }
}

