/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.central.network;

import java.io.IOException;
import jeus.net.AcceptorConnectionListenerSupport;
import jeus.net.NetworkControlPacket;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.net.impl.CrossConnectionException;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.central.network.ServiceHandler;
import jeus.sessionmanager.central.network.SessionServerAcceptor;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Session2;

public class SessionManagerAcceptorConnectionListener
extends AcceptorConnectionListenerSupport {
    private static final JeusLogger logger = Constants.CENTRAL_SESSION_LOGGER;
    private SessionServerAcceptor acceptor;
    private Executor pooledExecutor;
    private ServiceHandler serviceHandler;
    private boolean destoyed;

    public SessionManagerAcceptorConnectionListener(SessionServerAcceptor acceptor, Executor pooledExecutor, ServiceHandler serviceHandler) {
        this.acceptor = acceptor;
        this.pooledExecutor = pooledExecutor;
        this.serviceHandler = serviceHandler;
        this.destoyed = false;
    }

    public void connectionClosed(Exception exception, SocketStream socketStream) {
        if (exception != null && exception instanceof CrossConnectionException) {
            if (logger.isLoggable(JeusMessage_Session2._22121_LEVEL)) {
                logger.log(JeusMessage_Session2._22121_LEVEL, JeusMessage_Session2._22121, (Object)socketStream.getSocketID());
            }
            return;
        }
        if (logger.isLoggable(JeusMessage_Session2._22122_LEVEL)) {
            if (exception == null) {
                logger.log(JeusMessage_Session2._22122_LEVEL, JeusMessage_Session2._22122, (Object)socketStream.getSocketID());
            } else {
                logger.log(JeusMessage_Session2._22122_LEVEL, JeusMessage_Session2._22122, (Object)socketStream.getSocketID(), (Throwable)exception);
            }
        }
        this.destoyed = true;
        this.serviceHandler.clearDataPerSocketId(socketStream.getSocketID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionAllowed(SocketStream sockStream, NetworkControlPacket packet, int connectionType, Object piggybackedData) throws IOException {
        boolean accepted;
        if (logger.isLoggable(JeusMessage_Session2._22120_LEVEL)) {
            logger.log(JeusMessage_Session2._22120_LEVEL, JeusMessage_Session2._22120, (Object)sockStream.getSocketID());
        }
        if (this.destoyed) {
            if (logger.isLoggable(JeusMessage_Session2._22124_LEVEL)) {
                logger.log(JeusMessage_Session2._22124_LEVEL, JeusMessage_Session2._22124, (Object)sockStream.getSocketID());
            }
            return;
        }
        try {
            SocketID socketId = sockStream.getSocketID();
            this.serviceHandler.makeDataPerSocketId(socketId);
            accepted = true;
        }
        catch (Throwable t) {
            accepted = false;
            if (logger.isLoggable(JeusMessage_Session2._22125_LEVEL)) {
                logger.log(JeusMessage_Session2._22125_LEVEL, JeusMessage_Session2._22125, (Object)sockStream.getSocketID(), t);
            }
        }
        finally {
            sockStream.write((Object)packet);
        }
        if (!accepted) {
            sockStream.destroy();
        }
    }

    public void receiveMessage(Object obj, SocketStream sockStream, Object controlInfo) {
        if (this.destoyed) {
            if (logger.isLoggable(JeusMessage_Session2._22124_LEVEL)) {
                logger.log(JeusMessage_Session2._22124_LEVEL, JeusMessage_Session2._22124, (Object)sockStream.getSocketID());
            }
            return;
        }
        this.acceptor.handle(obj, sockStream);
    }

    public void runDelegatedTask(Runnable messageProcessor, boolean isReplyPacket, Object message) {
        this.pooledExecutor.execute(messageProcessor);
    }
}

