/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.central.network;

import java.io.IOException;
import java.net.SocketException;
import java.util.concurrent.ConcurrentHashMap;
import jeus.net.ConnectionListener;
import jeus.net.SocketStream;
import jeus.sessionmanager.central.network.Packet;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Session2;

public class SessionTransceiverConnectionListener
implements ConnectionListener {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.session");
    private ConcurrentHashMap localServerTable;

    public SessionTransceiverConnectionListener(ConcurrentHashMap localServerTable) {
        this.localServerTable = localServerTable;
    }

    public void connectionConnected(SocketStream sockStream) throws SocketException {
    }

    public void connectionAccepted(SocketStream sockStream, int connectionType, Object piggybackedData) throws Exception {
    }

    public void runDelegatedTask(Runnable messageProcessor, boolean isReplyPacket, Object message) {
        messageProcessor.run();
    }

    public Object getPiggybackData(int msgType, SocketStream sockStream, Object piggybackedData) {
        return piggybackedData;
    }

    public void writeDone(SocketStream sockStream) {
    }

    public void receiveMessage(Object message, SocketStream sockStream, Object controlInfo) throws Exception {
        if (message == null || !(message instanceof byte[]) || sockStream == null) {
            if (logger.isLoggable(JeusMessage_Session2._22107_LEVEL)) {
                logger.log(JeusMessage_Session2._22107_LEVEL, JeusMessage_Session2._22107, (Object)(sockStream == null ? "null" : sockStream.getSocketID().toString()));
            }
            sockStream.destroy();
            this.localServerTable.remove(sockStream.getSocketID());
            return;
        }
        Packet rcvpkt = new Packet();
        try {
            rcvpkt.receive((byte[])message);
        }
        catch (IOException e) {
            if (logger.isLoggable(JeusMessage_Session2._22107_LEVEL)) {
                logger.log(JeusMessage_Session2._22107_LEVEL, JeusMessage_Session2._22107, (Object)sockStream.getSocketID());
            }
            sockStream.destroy();
            this.localServerTable.remove(sockStream.getSocketID());
            return;
        }
    }

    public void connectionClosed(Exception exception, SocketStream sockStream) {
        if (logger.isLoggable(JeusMessage_Session2._22106_LEVEL)) {
            if (exception != null) {
                logger.log(JeusMessage_Session2._22106_LEVEL, JeusMessage_Session2._22106, (Object)sockStream, (Throwable)exception);
            } else {
                logger.log(JeusMessage_Session2._22106_LEVEL, JeusMessage_Session2._22106, (Object)sockStream);
            }
        }
        this.localServerTable.remove(sockStream.getSocketID());
    }
}

