/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.distributed;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import jeus.servlet.common.WebContainerManager;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.distributed.DistributedManagerConfig;
import jeus.sessionmanager.distributed.FileDB;
import jeus.sessionmanager.distributed.FileDBEntry;
import jeus.sessionmanager.distributed.SCRemoteContainer;
import jeus.sessionmanager.distributed.network.SCAddress;
import jeus.sessionmanager.distributed.network.SCConstants;
import jeus.sessionmanager.distributed.network.SessionManagerResurrectListener;
import jeus.sessionmanager.session.ByteArraySession;
import jeus.sessionmanager.session.ByteArraySessionImpl;
import jeus.sessionmanager.session.DistributableSession;
import jeus.sessionmanager.session.Session;
import jeus.sessionmanager.util.SessionByteArrayOutputStream;
import jeus.util.JeusBootstrapProperties;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Session3;
import jeus.util.properties.JeusNetPropertyValues;

public final class BackupManager
implements SCConstants {
    private static final JeusLogger logger = Constants.DISTRIBUTED_SESSION_LOGGER;
    public static final String DEFAULT_SESSIONDB_PATH = JeusBootstrapProperties.JEUS_HOME + File.separator + "sessiondb" + File.separator;
    public static final int MAX_BACKUP_BODY_SIZE = 0x100000;
    public static final int VALID_SESSION = 0;
    public static final int INVALID_SESSION = 1;
    public static final int PASSIVATE_SESSION = 2;
    public static final long WRITE_LOCK_TIMEOUT = 500L;
    public static final int WRITE_LOCK_CRITICAL_COUNT = 10;
    private static int hostIndex = 0;
    private AtomicBoolean running = new AtomicBoolean();
    private DistributedManagerConfig desc;
    private SCAddress backupServer;
    private FileDB localStorage;
    private BackupThread backupThread;
    private SCAddress localId;

    public BackupManager(SCAddress localId, DistributedManagerConfig desc) {
        this.running.set(false);
        this.localId = localId;
        this.desc = desc;
        this.backupServer = localId.getBackupAddress();
        this.initStorage();
    }

    private void initStorage() {
        block4: {
            String path;
            String ename = this.localId.getEngineId();
            String nname = WebContainerManager.NODE_NAME;
            if (nname == null) {
                nname = JeusNetPropertyValues.LOCAL_HOSTNAME + hostIndex;
                ++hostIndex;
            }
            if ((path = BackupManager.getFileDBPath(this.desc)) == null) {
                return;
            }
            try {
                this.localStorage = new FileDB(path, ename, this.desc);
            }
            catch (IOException sse) {
                if (!logger.isLoggable(JeusMessage_Session3._37000_LEVEL)) break block4;
                logger.log(JeusMessage_Session3._37000_LEVEL, JeusMessage_Session3._37000, (Object)(path + ename), (Throwable)sse);
            }
        }
    }

    public void startBackupThread(SCRemoteContainer remoteContainer) {
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        if (this.backupServer != null || this.desc.useFile()) {
            this.backupThread = new BackupThread(remoteContainer);
            this.backupThread.setName("distributed-session-backup-thread");
            this.backupThread.start();
        } else {
            this.backupThread = null;
        }
    }

    private void stopBackupThread() {
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        if (this.backupThread != null) {
            this.backupThread.finish();
            this.backupThread = null;
        }
    }

    public void recover() {
        if (this.localStorage != null) {
            this.localStorage.recover();
        }
    }

    public static String getFileDBPath(DistributedManagerConfig desc) {
        if (!desc.useFile()) {
            return null;
        }
        String path = desc.getFilePath();
        if (path == null || !new File(path).exists()) {
            path = DEFAULT_SESSIONDB_PATH;
        } else if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        return path;
    }

    public boolean isBackupDeviceOn() {
        return this.backupThread != null;
    }

    public void destroy() {
        this.stopBackupThread();
        if (this.localStorage != null) {
            this.localStorage.destroy();
        }
    }

    public ByteArraySession getLocalStorageSession(String id, boolean migrate) {
        ByteArraySession fileDBSession;
        block3: {
            fileDBSession = null;
            if (this.localStorage != null) {
                try {
                    fileDBSession = this.localStorage.load(id, migrate);
                }
                catch (IOException ioe) {
                    fileDBSession = null;
                    if (!logger.isLoggable(JeusMessage_Session3._37001_LEVEL)) break block3;
                    logger.log(JeusMessage_Session3._37001_LEVEL, JeusMessage_Session3._37001, (Throwable)ioe);
                }
            }
        }
        return fileDBSession;
    }

    public Set getLocalStorageSessionKeys() {
        if (this.localStorage != null) {
            return this.localStorage.getSessionKeys();
        }
        return new HashSet();
    }

    public void removeSession(String internalId) {
        block3: {
            if (this.localStorage != null) {
                try {
                    this.localStorage.purge(internalId);
                }
                catch (IOException e) {
                    if (!logger.isLoggable(JeusMessage_Session3._39001_LEVEL)) break block3;
                    logger.log(JeusMessage_Session3._39001_LEVEL, JeusMessage_Session3._39001, (Object[])new String[]{this.localId.toString(), internalId}, (Throwable)e);
                }
            }
        }
    }

    public void backupToRemote(DistributableSession session, boolean synchronousSending) throws Exception {
        if (this.backupThread != null) {
            this.backupThread.backup(session, synchronousSending);
        }
    }

    public void dumpBackup(ConcurrentHashMap sessions) {
        if (this.backupThread != null) {
            this.backupThread.backupResurrected(sessions);
        }
    }

    public void storeSessions(HashMap passivations) {
        int criticalCnt;
        if (passivations == null || this.localStorage == null) {
            return;
        }
        for (criticalCnt = 0; passivations.size() > 0 && criticalCnt < 10; ++criticalCnt) {
            BackupManager.serializeNstoreSessions(passivations, null, this.localStorage);
        }
        if (criticalCnt >= 10 && logger.isLoggable(JeusMessage_Session3._39305_LEVEL)) {
            for (Session notResolvedSession : passivations.values()) {
                logger.log(JeusMessage_Session3._39305_LEVEL, JeusMessage_Session3._39305, new Object[]{this.localId.toString(), notResolvedSession.getId(), notResolvedSession.getConcurrentAccessCount()});
            }
        }
    }

    public static int serializeNstoreSessions(HashMap sessions, SessionByteArrayOutputStream sbaos, FileDB storage) {
        int sessionCount = 0;
        CopyOnWriteArrayList<FileDBEntry> fdbEntries = null;
        if (storage != null) {
            fdbEntries = new CopyOnWriteArrayList<FileDBEntry>();
        }
        if (sbaos == null) {
            sbaos = (SessionByteArrayOutputStream)Constants.BACKUP_OUTPUT_STREAM.get();
            sbaos.reset();
        }
        Iterator it = sessions.values().iterator();
        while (it.hasNext()) {
            block13: {
                Object obj = it.next();
                if (!(obj instanceof DistributableSession)) continue;
                DistributableSession session = (DistributableSession)obj;
                if (session.isExpired()) {
                    if (logger.isLoggable(JeusMessage_Session3._39004_LEVEL)) {
                        logger.log(JeusMessage_Session3._39004_LEVEL, JeusMessage_Session3._39004, (Object)session.getId());
                    }
                    it.remove();
                    continue;
                }
                FileDBEntry fileEntry = null;
                try {
                    fileEntry = BackupManager.serialize(session, sbaos);
                    if (fileEntry == null) continue;
                    if (fdbEntries == null) break block13;
                    fdbEntries.add(fileEntry);
                }
                catch (IllegalStateException ise) {
                    if (logger.isLoggable(JeusMessage_Session3._39004_LEVEL)) {
                        logger.log(JeusMessage_Session3._39004_LEVEL, JeusMessage_Session3._39004, (Object)session.getId(), (Throwable)ise);
                    }
                    it.remove();
                    continue;
                }
                catch (Exception e) {
                    if (logger.isLoggable(JeusMessage_Session3._39002_LEVEL)) {
                        logger.log(JeusMessage_Session3._39002_LEVEL, JeusMessage_Session3._39002, (Object)session.getId(), (Throwable)e);
                    }
                    session.destroy();
                    it.remove();
                    sbaos.reset();
                    sessionCount = 0;
                    if (fdbEntries == null) continue;
                    fdbEntries.clear();
                    continue;
                }
            }
            it.remove();
            ++sessionCount;
            if (sbaos.getCount() <= 0x100000) continue;
            if (!logger.isLoggable(JeusMessage_Session3._37123_LEVEL)) break;
            logger.log(JeusMessage_Session3._37123_LEVEL, JeusMessage_Session3._37123, new Object[]{String.valueOf(0x100000), String.valueOf(sbaos.getCount()), String.valueOf(sessionCount)});
            break;
        }
        if (storage != null) {
            block14: {
                try {
                    storage.storeEntries(fdbEntries, sbaos.getByteArray(), sbaos.getCount());
                }
                catch (IOException ioe) {
                    if (!logger.isLoggable(JeusMessage_Session3._37006_LEVEL)) break block14;
                    logger.log(JeusMessage_Session3._37006_LEVEL, JeusMessage_Session3._37006, (Throwable)ioe);
                }
            }
            fdbEntries.clear();
        }
        return sessionCount;
    }

    private boolean serializeNstoreSession(DistributableSession session, SessionByteArrayOutputStream sbaos, FileDB storage) {
        if (session.isExpired()) {
            if (logger.isLoggable(JeusMessage_Session3._39004_LEVEL)) {
                logger.log(JeusMessage_Session3._39004_LEVEL, JeusMessage_Session3._39004, (Object)session.getId());
            }
            return false;
        }
        if (sbaos == null) {
            sbaos = (SessionByteArrayOutputStream)Constants.BACKUP_OUTPUT_STREAM.get();
            sbaos.reset();
        }
        boolean result = false;
        FileDBEntry fileEntry = null;
        for (int criticalCnt = 0; criticalCnt < 10; ++criticalCnt) {
            sbaos.reset();
            try {
                fileEntry = BackupManager.serialize(session, sbaos);
                if (fileEntry == null) {
                    continue;
                }
            }
            catch (IllegalStateException ise) {
                if (logger.isLoggable(JeusMessage_Session3._39004_LEVEL)) {
                    logger.log(JeusMessage_Session3._39004_LEVEL, JeusMessage_Session3._39004, (Object)session.getId(), (Throwable)ise);
                }
                return false;
            }
            catch (Exception e) {
                if (logger.isLoggable(JeusMessage_Session3._39002_LEVEL)) {
                    logger.log(JeusMessage_Session3._39002_LEVEL, JeusMessage_Session3._39002, (Object)session.getId(), (Throwable)e);
                }
                session.destroy();
                return false;
            }
            result = true;
            break;
        }
        if (!result) {
            if (logger.isLoggable(JeusMessage_Session3._39307_LEVEL)) {
                logger.log(JeusMessage_Session3._39307_LEVEL, JeusMessage_Session3._39307, new Object[]{this.localId.toString(), session.getId(), session.getConcurrentAccessCount()});
            }
            return false;
        }
        if (storage != null) {
            try {
                storage.storeEntry(fileEntry, sbaos.getByteArray(), sbaos.getCount());
            }
            catch (IOException ioe) {
                if (logger.isLoggable(JeusMessage_Session3._37006_LEVEL)) {
                    logger.log(JeusMessage_Session3._37006_LEVEL, JeusMessage_Session3._37006, (Throwable)ioe);
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileDBEntry serialize(DistributableSession session, SessionByteArrayOutputStream sbaos) throws Exception {
        if (session.getWriteLock().tryLock(500L, TimeUnit.MILLISECONDS)) {
            try {
                boolean valid;
                int end;
                int start;
                ByteArraySession byteSession = session.getByteSession();
                if (byteSession == null) {
                    byteSession = new ByteArraySessionImpl();
                    byteSession.initialize(session.getInternalId());
                    byteSession.initialize(session.getCreationTime(), session.getLastAccessedTime(), session.getThisAccessedTime(), session.getMaxInactiveInterval());
                    try {
                        SessionByteArrayOutputStream sbaosTmp = (SessionByteArrayOutputStream)Constants.SESSION_OUTPUT_STREAM.get();
                        sbaosTmp.reset();
                        start = sbaosTmp.getCount();
                        session.writeContent(sbaosTmp);
                        end = sbaosTmp.getCount();
                        byte[] byteData = new byte[end - start];
                        System.arraycopy(sbaosTmp.getByteArray(), start, byteData, 0, end - start);
                        byteSession.setBytesData(byteData);
                    }
                    catch (Exception e) {
                        byteSession.setBytesData(null);
                    }
                }
                start = sbaos.getCount();
                byteSession.writeSession(sbaos);
                end = sbaos.getCount();
                boolean bl = valid = !session.isExpired();
                if (logger.isLoggable(JeusMessage_Session3._39003_LEVEL)) {
                    logger.log(JeusMessage_Session3._39003_LEVEL, JeusMessage_Session3._39003, new Object[]{session.getInternalId(), String.valueOf(valid), String.valueOf(start), String.valueOf(end), String.valueOf(end - start)});
                }
                FileDBEntry fileDBEntry = new FileDBEntry(session.getInternalId(), start, valid ? (long)(end - start) : -1L);
                return fileDBEntry;
            }
            finally {
                session.getWriteLock().unlock();
            }
        }
        return null;
    }

    public int getPassivatedSessionsCount() {
        if (this.localStorage == null) {
            return 0;
        }
        return this.localStorage.size();
    }

    public long getPassivatedSessionsFileSize() {
        if (this.localStorage == null) {
            return 0L;
        }
        return this.localStorage.fileSize();
    }

    private class BackupList {
        private HashMap list1 = new HashMap();
        private HashMap list2 = new HashMap();
        private int count = 0;

        private BackupList() {
        }

        private synchronized int add(DistributableSession session) {
            this.list1.put(session.getId(), session);
            return ++this.count;
        }

        private synchronized int add(Map sessions) {
            this.list1.clear();
            this.list1.putAll(sessions);
            this.count = this.list1.size();
            return this.count;
        }

        private synchronized HashMap get() {
            if (this.count == 0) {
                return null;
            }
            this.count = 0;
            HashMap tmp = this.list1;
            this.list1 = this.list2;
            this.list2 = tmp;
            return this.list2;
        }

        public synchronized void clear() {
            this.list1.clear();
            this.list2.clear();
            this.count = 0;
        }
    }

    private class BackupThread
    extends Thread {
        private Object lock;
        private boolean waiting;
        private boolean backupDead;
        private boolean threadShutdowned;
        private SessionManagerResurrectListener resurrectListener;
        private BackupList backupList;
        private SCRemoteContainer remoteContainer;

        private BackupThread(SCRemoteContainer remoteContainer) {
            this.remoteContainer = remoteContainer;
            this.lock = new Object();
            this.backupList = new BackupList();
            this.waiting = false;
            this.backupDead = true;
            this.threadShutdowned = false;
            this.resurrectListener = new SessionManagerResurrectListener();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void backupResurrected(ConcurrentHashMap sessions) {
            Object object = this.lock;
            synchronized (object) {
                this.backupList.add(sessions);
                this.backupDead = false;
                this.lock.notify();
            }
            if (logger.isLoggable(JeusMessage_Session3._37102_LEVEL)) {
                logger.log(JeusMessage_Session3._37102_LEVEL, JeusMessage_Session3._37102, new Object[]{BackupManager.this.localId, BackupManager.this.backupServer, String.valueOf(sessions.size())});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void backup(DistributableSession session, boolean synchronousSending) throws Exception {
            if (BackupManager.this.backupServer != null && !this.isBackupAlive()) {
                this.remoteContainer.registerServerForChecking(BackupManager.this.backupServer, this.resurrectListener, BackupManager.this.desc.getBackupCheckTo());
                if (synchronousSending) {
                    IOException ioe = new IOException("backup server(" + BackupManager.this.backupServer + ") is dead");
                    if (logger.isLoggable(JeusMessage_Session3._37104_LEVEL)) {
                        logger.log(JeusMessage_Session3._37104_LEVEL, JeusMessage_Session3._37104, new Object[]{BackupManager.this.localId, BackupManager.this.backupServer, session.getId()}, (Throwable)ioe);
                    }
                    throw ioe;
                }
                return;
            }
            if (synchronousSending) {
                if (!this.processBackupLocalSession(session)) {
                    throw new Exception("failed to backup the session. id=" + session.getId());
                }
            } else {
                int trigger;
                int size = this.backupList.add(session);
                if (size >= (trigger = BackupManager.this.desc.getBackupTrigger()) && this.waiting) {
                    Object object = this.lock;
                    synchronized (object) {
                        if (size >= trigger && this.waiting) {
                            this.lock.notify();
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isBackupAlive() {
            if (this.backupDead) {
                if (this.remoteContainer.isAlive(BackupManager.this.backupServer)) {
                    Object object = this.lock;
                    synchronized (object) {
                        this.backupDead = false;
                    }
                    return true;
                }
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object backupData;
            try {
                if (BackupManager.this.backupServer != null && !this.isBackupAlive()) {
                    this.remoteContainer.registerServerForChecking(BackupManager.this.backupServer, this.resurrectListener, BackupManager.this.desc.getBackupCheckTo());
                }
                while (BackupManager.this.running.get()) {
                    backupData = this.backupList.get();
                    if (backupData != null) {
                        this.processBackupLocalSessions((HashMap)backupData);
                    }
                    Object object = this.lock;
                    synchronized (object) {
                        this.waiting = true;
                        try {
                            if (BackupManager.this.localStorage != null || !this.backupDead) {
                                this.lock.wait(BackupManager.this.desc.getBackupCheckTo());
                            } else {
                                this.lock.wait();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.waiting = false;
                        if (!BackupManager.this.running.get()) {
                            break;
                        }
                    }
                }
                if ((backupData = this.backupList.get()) != null) {
                    this.processBackupLocalSessions((HashMap)backupData);
                }
                if (logger.isLoggable(JeusMessage_Session3._37005_LEVEL)) {
                    logger.log(JeusMessage_Session3._37005_LEVEL, JeusMessage_Session3._37005);
                }
                this.remoteContainer.unregisterServerForChecking(BackupManager.this.backupServer);
                this.backupList.clear();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                backupData = this.lock;
                synchronized (backupData) {
                    this.threadShutdowned = true;
                    this.lock.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processBackupLocalSessions(HashMap backupData) {
            int sz = backupData.size();
            if (sz > 0 && logger.isLoggable(JeusMessage_Session3._37122_LEVEL)) {
                logger.log(JeusMessage_Session3._37122_LEVEL, JeusMessage_Session3._37122, new Object[]{BackupManager.this.localId, BackupManager.this.backupServer, String.valueOf(sz)});
            }
            for (int criticalCnt = 0; backupData.size() > 0 && criticalCnt < 10; ++criticalCnt) {
                SessionByteArrayOutputStream backupOutputStream = (SessionByteArrayOutputStream)Constants.BACKUP_OUTPUT_STREAM.get();
                backupOutputStream.reset();
                int scount = BackupManager.serializeNstoreSessions(backupData, backupOutputStream, BackupManager.this.localStorage);
                if (BackupManager.this.backupServer == null || this.remoteContainer.backupSession(BackupManager.this.backupServer, scount, backupOutputStream)) continue;
                Object object = this.lock;
                synchronized (object) {
                    backupData.clear();
                    this.backupDead = true;
                }
                this.remoteContainer.registerServerForChecking(BackupManager.this.backupServer, this.resurrectListener, BackupManager.this.desc.getBackupCheckTo());
                break;
            }
            if (logger.isLoggable(JeusMessage_Session3._39307_LEVEL)) {
                for (Session notResolvedSession : backupData.values()) {
                    logger.log(JeusMessage_Session3._39307_LEVEL, JeusMessage_Session3._39307, new Object[]{BackupManager.this.localId.toString(), notResolvedSession.getId(), notResolvedSession.getConcurrentAccessCount()});
                }
            }
            if (!this.backupDead && logger.isLoggable(JeusMessage_Session3._37103_LEVEL)) {
                logger.log(JeusMessage_Session3._37103_LEVEL, JeusMessage_Session3._37103, new Object[]{BackupManager.this.localId, BackupManager.this.backupServer, String.valueOf(sz - backupData.size())});
            }
            backupData.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean processBackupLocalSession(DistributableSession session) {
            SessionByteArrayOutputStream backupOutputStream = (SessionByteArrayOutputStream)Constants.BACKUP_OUTPUT_STREAM.get();
            backupOutputStream.reset();
            if (!BackupManager.this.serializeNstoreSession(session, backupOutputStream, BackupManager.this.localStorage)) {
                return false;
            }
            if (BackupManager.this.backupServer != null && !this.remoteContainer.backupSession(BackupManager.this.backupServer, 1, backupOutputStream)) {
                Object object = this.lock;
                synchronized (object) {
                    this.backupDead = true;
                }
                this.remoteContainer.registerServerForChecking(BackupManager.this.backupServer, this.resurrectListener, BackupManager.this.desc.getBackupCheckTo());
                return false;
            }
            if (logger.isLoggable(JeusMessage_Session3._37105_LEVEL)) {
                logger.log(JeusMessage_Session3._37105_LEVEL, JeusMessage_Session3._37105, new Object[]{BackupManager.this.localId, BackupManager.this.backupServer, session.getId()});
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finish() {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
                if (!this.threadShutdowned) {
                    try {
                        this.lock.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.remoteContainer.unregisterServerForChecking(BackupManager.this.backupServer);
        }
    }
}

