/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.distributed;

import java.io.IOException;
import jeus.descriptor.sessionmanager.DistributedSessionManagerDescriptor;
import jeus.sessionmanager.JkRouter;
import jeus.sessionmanager.distributed.DistributedRouter;

public class DistributedJkRouter
extends JkRouter
implements DistributedRouter {
    private String primary = null;
    private String backup = null;

    public DistributedJkRouter() {
        this(null);
    }

    public DistributedJkRouter(String suffix) {
        super(suffix);
    }

    public String getPrimary() {
        return this.primary;
    }

    public String getBackup() {
        return this.backup;
    }

    public void setRouterInfo(String primary, String backup) {
        if (primary == null) {
            return;
        }
        this.primary = DistributedJkRouter.getOnlyRouterInfo(primary);
        this.backup = DistributedJkRouter.getOnlyRouterInfo(backup);
        super.setSuffix(this.primary);
    }

    public String getPrimaryFromId(String id) {
        if (id == null) {
            return null;
        }
        int pos = id.indexOf(46);
        if (pos <= 0) {
            return null;
        }
        return DistributedJkRouter.getOnlyRouterInfo(id.substring(pos + 1));
    }

    public String getBackupFromPrimary(String primary) {
        if (primary == null) {
            return null;
        }
        String backup = null;
        try {
            backup = DistributedSessionManagerDescriptor.getBackupEngine(primary);
        }
        catch (IOException e) {
            e.printStackTrace();
            backup = null;
        }
        return DistributedJkRouter.getOnlyRouterInfo(backup);
    }

    public static String getOnlyRouterInfo(String engineId) {
        if (engineId == null) {
            return null;
        }
        int pos = engineId.indexOf(45);
        if (pos > 0) {
            return engineId.substring(0, pos);
        }
        return engineId;
    }

    public static String getOnlyRouterExtraInfo(String engineId) {
        if (engineId == null) {
            return null;
        }
        int pos = engineId.indexOf(45);
        if (pos > 0) {
            try {
                return engineId.substring(pos + 1);
            }
            catch (IndexOutOfBoundsException ioobe) {
                return null;
            }
        }
        return null;
    }
}

