/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.distributed.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import jeus.net.ReplyListener;
import jeus.net.helper.MsgSync;
import jeus.net.impl.SocketStream14;
import jeus.sessionmanager.distributed.network.SCPacket;
import jeus.sessionmanager.util.SessionByteArrayOutputStream;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_Session3;

public final class SCBackupPacket
extends SCPacket {
    private byte[] body;
    private int wrcnt;
    private int sessionCount;

    public SCBackupPacket(int sessionCount, SessionByteArrayOutputStream sbaos) {
        this.resetBody();
        this.sessionCount = sessionCount;
        this.body = sbaos.getByteArray();
        this.wrcnt = sbaos.getCount();
        this.header.setOpcode(259);
    }

    public void resetBody() {
        this.body = null;
        this.wrcnt = 0;
        this.sessionCount = 0;
    }

    void sendBody(SocketStream14 out, MsgSync reply) throws IOException {
        if (this.wrcnt < 0) {
            throw new IOException("backup packet's body size is invalid. body size = " + this.wrcnt);
        }
        byte[] smNameBytes = this.getNameBytes();
        if (smNameBytes == null) {
            throw new IOException("backup packet's smName is null");
        }
        int totalSize = 32 + smNameBytes.length + this.wrcnt;
        ByteBuffer buffer = null;
        buffer = reply == null ? out.getReplyByteBuffer(totalSize) : out.getReqeustByteBuffer(totalSize);
        this.header.setMagic();
        this.header.setVersion(1);
        this.header.setFlag(this.sessionCount);
        this.header.setNameLen(smNameBytes.length);
        this.header.setBodyLength(this.wrcnt);
        buffer.put(this.header.getHeader(), 0, 32);
        buffer.put(smNameBytes);
        if (this.wrcnt > 0) {
            buffer.put(this.body, 0, this.wrcnt);
        }
        if (reply == null) {
            out.writeReply(buffer);
        } else {
            out.write(buffer, (ReplyListener)reply);
        }
    }

    void addBodyInt(int value) {
    }

    void addBodyLong(long value) {
    }

    public void addBodyString(String value) {
    }

    public void addBody(byte[] value) {
    }

    public void setBody(byte[] value, int off, int len) {
    }

    int getBodyInt() {
        throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session3._37024));
    }

    long getBodyLong() {
        throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session3._37024));
    }

    public String getBodyString() {
        throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session3._37024));
    }

    byte[] getBody(int len) {
        throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session3._37024));
    }

    public byte[] getBody() {
        throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session3._37024));
    }
}

