/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.distributed.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import jeus.net.ReplyListener;
import jeus.net.helper.MsgSync;
import jeus.net.impl.SocketStream14;
import jeus.sessionmanager.distributed.network.SCPacket;
import jeus.sessionmanager.distributed.network.SCPacketHeader;
import jeus.util.ErrorMsgManager;
import jeus.util.cnet.NetUtil;
import jeus.util.message.JeusMessage_Session3;

public final class SCSimplePacket
extends SCPacket {
    private static final int MAX_CONTROL_BODY_LEN = 256;
    private byte[] body;
    private int wrcnt;
    private int wrstart;
    private int rdcnt;

    public SCSimplePacket() {
        this.wrstart = 0;
        this.wrcnt = 0;
        this.rdcnt = 0;
    }

    SCSimplePacket(SCPacketHeader header, byte[] message) {
        super(header);
        int nameLen;
        if (message == null) {
            this.body = null;
        }
        if ((nameLen = header.getNameLen()) > 0) {
            byte[] nameBytes = new byte[nameLen];
            System.arraycopy(message, 32, nameBytes, 0, nameLen);
            this.setNameBytes(nameBytes);
        } else {
            nameLen = 0;
        }
        int bodyLen = message.length - 32 - nameLen;
        if (bodyLen <= 0) {
            this.body = null;
        } else {
            byte[] body = new byte[bodyLen];
            System.arraycopy(message, 32 + nameLen, body, 0, bodyLen);
            this.body = body;
        }
        this.wrstart = 0;
        this.wrcnt = 0;
        this.rdcnt = 0;
    }

    private void ensureCapacity(int cap) {
        int bodylength;
        int n = bodylength = this.body == null ? 0 : this.body.length;
        if (bodylength == 0) {
            int len1;
            int len2 = this.wrcnt + cap;
            for (len1 = 256; len1 < len2; len1 *= 2) {
            }
            this.body = new byte[len1];
        } else if (this.wrcnt + cap > bodylength) {
            int len1;
            int len2 = this.wrcnt + cap;
            for (len1 = bodylength; len1 < len2; len1 *= 2) {
            }
            byte[] tmp = new byte[len1];
            System.arraycopy(this.body, 0, tmp, 0, this.wrcnt);
            this.body = tmp;
        }
    }

    private void ensurePosition(int len) {
        if (this.body == null || this.body.length - this.rdcnt < len) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session3._37070, (Object[])new String[]{String.valueOf(len), this.body == null ? String.valueOf(0 - this.rdcnt) : String.valueOf(this.body.length - this.rdcnt)}));
        }
    }

    public void resetBody() {
        this.body = null;
        this.wrcnt = 0;
        this.rdcnt = 0;
        this.wrstart = 0;
    }

    void sendBody(SocketStream14 out, MsgSync reply) throws IOException {
        if (this.wrcnt < 0) {
            throw new IOException("simple packet's body size is invalid. body size = " + this.wrcnt);
        }
        byte[] smNameBytes = this.getNameBytes();
        int smNameLen = smNameBytes == null ? 0 : smNameBytes.length;
        int totalSize = 32 + smNameLen + this.wrcnt;
        ByteBuffer buffer = null;
        buffer = reply == null ? out.getReplyByteBuffer(totalSize) : out.getReqeustByteBuffer(totalSize);
        this.header.setMagic();
        this.header.setVersion(1);
        this.header.setNameLen(smNameLen);
        this.header.setBodyLength(this.wrcnt);
        buffer.put(this.header.getHeader(), 0, 32);
        if (smNameLen > 0) {
            buffer.put(smNameBytes);
        }
        if (this.wrcnt > 0) {
            buffer.put(this.body, this.wrstart, this.wrcnt);
        }
        if (reply == null) {
            out.writeReply(buffer);
        } else {
            out.write(buffer, (ReplyListener)reply);
        }
    }

    void addBodyInt(int value) {
        this.ensureCapacity(4);
        NetUtil.writeInt((byte[])this.body, (int)this.wrcnt, (int)value);
        this.wrcnt += 4;
    }

    void addBodyLong(long value) {
        this.ensureCapacity(8);
        NetUtil.writeLong((byte[])this.body, (int)this.wrcnt, (long)value);
        this.wrcnt += 8;
    }

    public void addBodyString(String value) {
        byte[] value2 = value.getBytes();
        int len = value2.length;
        this.ensureCapacity(4 + len);
        NetUtil.writeInt((byte[])this.body, (int)this.wrcnt, (int)len);
        this.wrcnt += 4;
        System.arraycopy(value2, 0, this.body, this.wrcnt, len);
        this.wrcnt += len;
    }

    public void addBody(byte[] value) {
        this.ensureCapacity(value.length);
        System.arraycopy(value, 0, this.body, this.wrcnt, value.length);
        this.wrcnt += value.length;
    }

    public void setBody(byte[] value, int off, int len) {
        this.body = value;
        this.wrcnt = len;
        this.wrstart = off;
    }

    int getBodyInt() {
        this.ensurePosition(4);
        int result = NetUtil.readInt((byte[])this.body, (int)this.rdcnt);
        this.rdcnt += 4;
        return result;
    }

    long getBodyLong() {
        this.ensurePosition(8);
        long result = NetUtil.readLong((byte[])this.body, (int)this.rdcnt);
        this.rdcnt += 8;
        return result;
    }

    public String getBodyString() {
        this.ensurePosition(4);
        int len = NetUtil.readInt((byte[])this.body, (int)this.rdcnt);
        this.rdcnt += 4;
        String result = new String(this.body, this.rdcnt, len);
        this.rdcnt += len;
        return result;
    }

    byte[] getBody(int len) {
        this.ensurePosition(len);
        if (this.rdcnt == 0 && len == this.body.length) {
            this.rdcnt = this.body.length;
            return this.body;
        }
        byte[] result = new byte[len];
        System.arraycopy(this.body, this.rdcnt, result, 0, len);
        this.rdcnt += len;
        return result;
    }

    public byte[] getBody() {
        this.rdcnt = this.body == null ? 0 : this.body.length;
        return this.body;
    }
}

