/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.distributed.network;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import jeus.net.AcceptorConnectionListenerSupport;
import jeus.net.NetworkControlPacket;
import jeus.net.SocketStream;
import jeus.net.impl.CrossConnectionException;
import jeus.net.impl.SocketStream14;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.distributed.DistributedSessionManager;
import jeus.sessionmanager.distributed.network.MessageHandler;
import jeus.sessionmanager.distributed.network.SCAddress;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Session3;

public class SessionManagerAcceptorConnectionListener
extends AcceptorConnectionListenerSupport {
    private static final JeusLogger logger = Constants.DISTRIBUTED_SESSION_LOGGER;
    private Executor pooledExecutor;
    private MessageHandler handler;
    private ConcurrentHashMap managerMap;
    private boolean destoyed;

    public SessionManagerAcceptorConnectionListener(MessageHandler handler, ConcurrentHashMap managerMap, Executor pooledExecutor) {
        this.handler = handler;
        this.managerMap = managerMap;
        this.pooledExecutor = pooledExecutor;
        this.destoyed = false;
    }

    public void connectionClosed(Exception exception, SocketStream sockStream) {
        if (exception != null && exception instanceof CrossConnectionException) {
            if (logger.isLoggable(JeusMessage_Session3._37121_LEVEL)) {
                logger.log(JeusMessage_Session3._37121_LEVEL, JeusMessage_Session3._37121, (Object)sockStream.getSocketID());
            }
            return;
        }
        if (logger.isLoggable(JeusMessage_Session3._37118_LEVEL)) {
            if (exception == null) {
                logger.log(JeusMessage_Session3._37118_LEVEL, JeusMessage_Session3._37118, (Object)sockStream.getSocketID());
            } else {
                logger.log(JeusMessage_Session3._37118_LEVEL, JeusMessage_Session3._37118, (Object)sockStream.getSocketID(), (Throwable)exception);
            }
        }
        this.destoyed = true;
        if (this.handler != null) {
            this.handler.destroy();
            this.handler = null;
        }
        this.managerMap = null;
        this.pooledExecutor = null;
    }

    public void connectionAccepted(SocketStream sockStream, int connectionType, Object piggybackedData) {
        if (logger.isLoggable(JeusMessage_Session3._37119_LEVEL)) {
            logger.log(JeusMessage_Session3._37119_LEVEL, JeusMessage_Session3._37119, (Object)sockStream.getSocketID());
        }
        if (this.destoyed) {
            if (logger.isLoggable(JeusMessage_Session3._37117_LEVEL)) {
                logger.log(JeusMessage_Session3._37117_LEVEL, JeusMessage_Session3._37117, (Object)sockStream.getSocketID());
            }
            return;
        }
        for (DistributedSessionManager manager : this.managerMap.values()) {
            SCAddress backup = manager.getLocalId().getBackupAddress();
            if (backup == null || !backup.equals(sockStream.getSocketID())) continue;
            manager.dumpBackup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionAllowed(SocketStream sockStream, NetworkControlPacket packet, int connectionType, Object piggybackedData) throws IOException {
        boolean accepted;
        if (logger.isLoggable(JeusMessage_Session3._37120_LEVEL)) {
            logger.log(JeusMessage_Session3._37120_LEVEL, JeusMessage_Session3._37120, (Object)sockStream.getSocketID());
        }
        if (this.destoyed) {
            if (logger.isLoggable(JeusMessage_Session3._37117_LEVEL)) {
                logger.log(JeusMessage_Session3._37117_LEVEL, JeusMessage_Session3._37117, (Object)sockStream.getSocketID());
            }
            return;
        }
        try {
            for (DistributedSessionManager manager : this.managerMap.values()) {
                SCAddress backup = manager.getLocalId().getBackupAddress();
                if (backup == null || !backup.equals(sockStream.getSocketID())) continue;
                manager.dumpBackup();
            }
            accepted = true;
        }
        catch (Throwable t) {
            accepted = false;
            if (logger.isLoggable(JeusMessage_Session3._37124_LEVEL)) {
                logger.log(JeusMessage_Session3._37124_LEVEL, JeusMessage_Session3._37124, (Object)sockStream.getSocketID(), t);
            }
        }
        finally {
            sockStream.write((Object)packet);
        }
        if (!accepted) {
            sockStream.destroy();
        }
    }

    public void receiveMessage(Object obj, SocketStream sockStream, Object controlInfo) {
        if (obj == null || !(obj instanceof byte[]) || sockStream == null) {
            if (logger.isLoggable(JeusMessage_Session3._37107_LEVEL)) {
                logger.log(JeusMessage_Session3._37107_LEVEL, JeusMessage_Session3._37107, (Throwable)new Exception("failed to handle a message"));
            }
            return;
        }
        if (this.destoyed) {
            if (logger.isLoggable(JeusMessage_Session3._37117_LEVEL)) {
                logger.log(JeusMessage_Session3._37117_LEVEL, JeusMessage_Session3._37117, (Object)sockStream.getSocketID());
            }
            return;
        }
        this.handler.handleMessage((byte[])obj, (SocketStream14)sockStream);
    }

    public void runDelegatedTask(Runnable messageProcessor, boolean isReplyPacket, Object message) {
        this.pooledExecutor.execute(messageProcessor);
    }
}

