/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.session;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import jeus.servlet.property.WebProperties;
import jeus.sessionmanager.Constants;
import jeus.sessionmanager.SessionAttributeListener;
import jeus.sessionmanager.SessionConfig;
import jeus.sessionmanager.WebSessionConfig;
import jeus.sessionmanager.session.AbstractSession;
import jeus.sessionmanager.session.HttpSessionWrapper;
import jeus.sessionmanager.session.WebSession;
import jeus.sessionmanager.util.SerializedObjectTable;

public abstract class AbstractWebSession
extends AbstractSession
implements WebSession,
SessionAttributeListener {
    protected final transient SerializedObjectTable serAttributes;
    protected final Map attributes = new Hashtable();
    private final transient HttpSession wrapper = new HttpSessionWrapper(this);
    private final HttpSessionEvent httpSessionEvent = new HttpSessionEvent(this.wrapper);
    private transient SessionAttributeListener attributeListenerSupport;

    public AbstractWebSession(SessionConfig config) {
        super(config);
        this.serAttributes = SerializedObjectTable.getSerializedObjectTable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backupSessions() {
        List notSerializedNames;
        Map map = this.attributes;
        synchronized (map) {
            notSerializedNames = this.serAttributes.serialize(this.attributes);
        }
        Iterator i = notSerializedNames.iterator();
        while (i.hasNext()) {
            this.removeAttribute((String)i.next());
        }
    }

    public void notifyAttibuteAddition(Object param) {
        if (this.attributeListenerSupport != null) {
            this.attributeListenerSupport.notifyAttibuteAddition(param);
        }
    }

    public void notifyAttibuteReplacement(Object param) {
        if (this.attributeListenerSupport != null) {
            this.attributeListenerSupport.notifyAttibuteReplacement(param);
        }
    }

    public void notifyAttibuteRemoval(Object param) {
        if (this.attributeListenerSupport != null) {
            this.attributeListenerSupport.notifyAttibuteRemoval(param);
        }
    }

    public long getCreationTime() {
        if (this.isExpired()) {
            throw new IllegalStateException("session invalidated");
        }
        return super.getCreationTime();
    }

    public long getLastAccessedTime() {
        if (this.isExpired()) {
            throw new IllegalStateException("session invalidated");
        }
        return super.getLastAccessedTime();
    }

    public void setMaxInactiveInterval(int secondsInterval) {
        super.setMaxInactiveInterval(secondsInterval);
    }

    public boolean isNew() {
        if (this.isExpired()) {
            throw new IllegalStateException("session invalidated");
        }
        return super.isNew();
    }

    public void destroy() {
        if (this.isExpired()) {
            if (WebProperties.J2EE_COMPATIBLE.value) {
                throw new IllegalStateException("session invalidated");
            }
            return;
        }
        Enumeration enum1 = this.getAttributeNames();
        while (enum1.hasMoreElements()) {
            String name = (String)enum1.nextElement();
            this.removeAttribute(name);
        }
        this.attributes.clear();
        this.attributeListenerSupport = null;
        super.destroy();
    }

    public HttpSession getHttpWrapper() {
        return this.wrapper;
    }

    public HttpSessionEvent getHttpSessionEvent() {
        return this.httpSessionEvent;
    }

    public WebSessionConfig getConfig() {
        if (this.config instanceof WebSessionConfig) {
            return (WebSessionConfig)this.config;
        }
        return Constants.DUMMY_WEB_SESSION_CONFIG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        if (this.isExpired()) {
            throw new IllegalStateException("session invalidated");
        }
        if (name == null) {
            throw new IllegalArgumentException("arguement is null");
        }
        Map map = this.attributes;
        synchronized (map) {
            Object o = this.attributes.get(name);
            if (o != null) {
                return o;
            }
            o = this.serAttributes.deserialize(name);
            if (o != null) {
                this.attributes.put(name, o);
            }
            return o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        if (this.isExpired()) {
            throw new IllegalStateException("session invalidated");
        }
        Map map = this.attributes;
        synchronized (map) {
            this.serAttributes.deserialize(this.attributes);
            return ((Hashtable)this.attributes).keys();
        }
    }

    public String[] getValueNames() {
        if (this.isExpired()) {
            throw new IllegalStateException("session invalidated");
        }
        Enumeration e = this.getAttributeNames();
        Vector names = new Vector();
        while (e.hasMoreElements()) {
            names.addElement(e.nextElement());
        }
        Object[] valueNames = new String[names.size()];
        names.copyInto(valueNames);
        return valueNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        if (this.isExpired()) {
            throw new IllegalStateException("session invalidated");
        }
        if (name == null) {
            throw new IllegalArgumentException("arguement is null");
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        Object prev = null;
        Map map = this.attributes;
        synchronized (map) {
            prev = this.attributes.put(name, value);
            if (prev == null) {
                prev = this.serAttributes.deserialize(name);
            }
        }
        this.notifyBindingListeners(name, prev, value);
        this.notifyAttributeListeners(name, prev, value);
        this.setNeedUpdate(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        if (this.isExpired()) {
            throw new IllegalStateException("session invalidated");
        }
        if (name == null) {
            return;
        }
        Object o = null;
        Map map = this.attributes;
        synchronized (map) {
            o = this.attributes.remove(name);
            if (o == null) {
                o = this.serAttributes.deserialize(name);
            }
        }
        this.notifyBindingListeners(name, o);
        this.notifyAttributeListeners(name, o);
        this.setNeedUpdate(true);
    }

    public SessionAttributeListener getAttributeListenerSupport() {
        return this.attributeListenerSupport;
    }

    public void setAttributeListenerSupport(SessionAttributeListener listenerSupport) {
        this.attributeListenerSupport = listenerSupport;
    }

    private void notifyBindingListeners(String name, Object oldValue, Object newValue) {
        if (oldValue != null && oldValue instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)oldValue).valueUnbound(new HttpSessionBindingEvent(this.wrapper, name, oldValue));
        }
        if (newValue instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)newValue).valueBound(new HttpSessionBindingEvent(this.wrapper, name, newValue));
        }
    }

    private void notifyBindingListeners(String name, Object oldValue) {
        if (oldValue != null && oldValue instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)oldValue).valueUnbound(new HttpSessionBindingEvent(this.wrapper, name, oldValue));
        }
    }

    private void notifyAttributeListeners(String name, Object oldValue, Object newValue) {
        boolean replaced;
        boolean bl = replaced = oldValue != null;
        if (replaced) {
            HttpSessionBindingEvent hsbe = new HttpSessionBindingEvent(this.wrapper, name, oldValue);
            this.notifyAttibuteReplacement(hsbe);
        } else {
            HttpSessionBindingEvent hsbe = new HttpSessionBindingEvent(this.wrapper, name, newValue);
            this.notifyAttibuteAddition(hsbe);
        }
    }

    private void notifyAttributeListeners(String name, Object oldValue) {
        if (oldValue != null) {
            HttpSessionBindingEvent hsbe = new HttpSessionBindingEvent(this.wrapper, name, oldValue);
            this.notifyAttibuteRemoval(hsbe);
        }
    }
}

