/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.session;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.util.Map;
import jeus.sessionmanager.SessionConfig;
import jeus.sessionmanager.central.CentralSessionManager;
import jeus.sessionmanager.session.AbstractWebSession;
import jeus.sessionmanager.session.CentralSession;
import jeus.sessionmanager.util.SessionByteArrayInputStream;
import jeus.sessionmanager.util.SessionByteArrayOutputStream;
import jeus.util.message.JeusMessage_Session4;

public class CentralWebSession
extends AbstractWebSession
implements CentralSession {
    private transient byte[] storedBytes = null;
    private transient boolean uniqueCreation = false;
    private transient boolean checkModified = false;

    public CentralWebSession(SessionConfig config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readSession(byte[] inputBytes, int offset, int length) throws Exception {
        Map map = this.attributes;
        synchronized (map) {
            int count = 0;
            int tempInt = 0;
            try {
                this.storedBytes = inputBytes;
                SessionByteArrayInputStream pbis = new SessionByteArrayInputStream(inputBytes, offset, length);
                DataInputStream dataInputStream = new DataInputStream(pbis);
                count += this.readSessionTimes(dataInputStream);
                int attrCount = dataInputStream.readInt();
                count += 4;
                if (attrCount > 0) {
                    tempInt = pbis.getPos();
                    this.serAttributes.deserialize(pbis, attrCount, this.attributes);
                    count += pbis.getPos() - tempInt;
                }
            }
            catch (Exception e) {
                this.attributes.clear();
                if (logger.isLoggable(JeusMessage_Session4._47653_LEVEL)) {
                    logger.log(JeusMessage_Session4._47653_LEVEL, JeusMessage_Session4._47653, (Throwable)e);
                }
                throw e;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSession(OutputStream outputStream) throws Exception {
        Map map = this.attributes;
        synchronized (map) {
            int attributeCntOffset;
            if (!(outputStream instanceof SessionByteArrayOutputStream)) {
                throw new Exception(outputStream + " is not supported in CentralWebSession");
            }
            SessionByteArrayOutputStream sbaos = (SessionByteArrayOutputStream)outputStream;
            int attrCount = 0;
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(sbaos);
                this.writeSessionTimes(dataOutputStream);
                attributeCntOffset = sbaos.getCount();
                dataOutputStream.writeInt(0);
                attrCount = this.serAttributes.serialize(sbaos, this.attributes);
            }
            catch (Exception e) {
                if (logger.isLoggable(JeusMessage_Session4._47652_LEVEL)) {
                    logger.log(JeusMessage_Session4._47652_LEVEL, JeusMessage_Session4._47652, (Throwable)e);
                }
                throw e;
            }
            sbaos.writeInt(attributeCntOffset, attrCount);
            this.checkModified(sbaos);
            this.storedBytes = sbaos.getByteArray();
            if (logger.isLoggable(JeusMessage_Session4._48000_LEVEL)) {
                logger.log(JeusMessage_Session4._48000_LEVEL, JeusMessage_Session4._48000, new Object[]{this, this.getId(), sbaos.getByteArray(), sbaos.getByteArray() == null ? "null" : String.valueOf(sbaos.getByteArray().length), new Integer(sbaos.getCount())});
            }
            return;
        }
    }

    public boolean isUniqueCreation() {
        return this.uniqueCreation;
    }

    public void setUniqueCreation(boolean uniqueCreation) {
        this.uniqueCreation = uniqueCreation;
    }

    public boolean isCheckModified() {
        return this.checkModified;
    }

    public void setCheckModified(boolean checkModified) {
        this.checkModified = checkModified;
    }

    public void destroy() {
        this.storedBytes = null;
        this.uniqueCreation = false;
        super.destroy();
    }

    private void checkModified(SessionByteArrayOutputStream sbaos) {
        if (this.isNeedUpdate()) {
            return;
        }
        if (!this.checkModified) {
            return;
        }
        if (!CentralSessionManager.checkModified(sbaos, this.storedBytes)) {
            this.setNeedUpdate(true);
        }
    }
}

