/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.session;

import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import jeus.sessionmanager.SessionManager;
import jeus.sessionmanager.WebSessionConfig;
import jeus.sessionmanager.session.WebSession;

public class HttpSessionWrapper
implements HttpSession {
    private final WebSession session;
    private static final HttpSessionContext HTTP_SESSION_CONTEXT = new HttpSessionContext(){
        protected final Enumeration emptyEnumeration = Collections.enumeration(Collections.EMPTY_LIST);

        public HttpSession getSession(String sessionId) {
            return null;
        }

        public Enumeration getIds() {
            return this.emptyEnumeration;
        }
    };

    public HttpSessionWrapper(WebSession session) {
        this.session = session;
    }

    public long getCreationTime() {
        return this.session.getCreationTime();
    }

    public long getLastAccessedTime() {
        return this.session.getLastAccessedTime();
    }

    public void setMaxInactiveInterval(int secondsInterval) {
        if (secondsInterval == 0) {
            this.invalidate();
        }
        this.session.setMaxInactiveInterval(secondsInterval);
    }

    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    public boolean isNew() {
        return this.session.isNew();
    }

    public String getId() {
        return this.session.getId();
    }

    public void setAttribute(String name, Object value) {
        this.session.setAttribute(name, value);
    }

    public Object getAttribute(String name) {
        return this.session.getAttribute(name);
    }

    public void removeAttribute(String name) {
        this.session.removeAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.session.getAttributeNames();
    }

    public String[] getValueNames() {
        return this.session.getValueNames();
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public ServletContext getServletContext() {
        WebSessionConfig config = this.session.getConfig();
        if (config == null) {
            return null;
        }
        return config.getServletContext();
    }

    public void invalidate() {
        if (this.session.isExpired()) {
            throw new IllegalStateException("Session is already invalidated.");
        }
        WebSessionConfig config = this.session.getConfig();
        if (config == null) {
            return;
        }
        SessionManager manager = config.getManager();
        if (manager == null) {
            return;
        }
        manager.destroy(this.session);
    }

    public HttpSessionContext getSessionContext() {
        return HTTP_SESSION_CONTEXT;
    }
}

