/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;

public class LocalIpAddressUtil {
    private static final ArrayList IP_LISTS = new ArrayList();
    private static final String LOCAL_HOST = "127.0.0.1";

    public static ArrayList getAllLocalIp() {
        if (!IP_LISTS.isEmpty()) {
            return IP_LISTS;
        }
        IP_LISTS.clear();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface nif = enumeration.nextElement();
                Enumeration<InetAddress> enum2 = nif.getInetAddresses();
                while (enum2.hasMoreElements()) {
                    InetAddress localHostaddr = enum2.nextElement();
                    String ipAddress = localHostaddr.getHostAddress();
                    IP_LISTS.add(ipAddress);
                }
            }
        }
        catch (SocketException se) {
            se.printStackTrace();
            IP_LISTS.clear();
        }
        return IP_LISTS;
    }

    public static String getPrimeLocalIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isLocalIp(String ip) {
        if (IP_LISTS.isEmpty()) {
            LocalIpAddressUtil.getAllLocalIp();
        }
        if (LOCAL_HOST.equals(ip)) {
            return true;
        }
        for (int i = 0; i < IP_LISTS.size(); ++i) {
            String local = (String)IP_LISTS.get(i);
            if (local == null || !local.equals(ip)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.println("Prime Local IP = " + LocalIpAddressUtil.getPrimeLocalIp());
        System.out.println("All Local IPs = " + LocalIpAddressUtil.getAllLocalIp());
    }
}

