/*
 * Decompiled with CFR 0.152.
 */
package jeus.sessionmanager.util;

import jeus.sessionmanager.util.JeusRandom;
import jeus.sessionmanager.util.RandomPerJvm;
import jeus.sessionmanager.util.SessionManagerUtil;

public class SecureSessionIdGenerator {
    private static final int UNIQUE_ID_LENGTH = 64;
    private static final char[] SESSION_CHARS = new char[]{'1', '8', 'D', 'E', 'i', 'G', 'P', '3', 'u', '1', 'N', 'R', 'Z', 'r', 'H', 'e', 's', 'X', '2', 'S', 'q', '6', 'O', 'Q', 'g', '9', 'M', '0', 'U', 'y', '4', 'V', 'J', 'p', '7', 'b', 'x', 'n', 'z', 'v', 'l', 't', 'T', 'j', 'W', 'L', 'w', 'C', 'o', 'a', 'Y', 'I', 'd', 'c', 'B', 'A', 'k', '5', 'f', 'm', 'h', 'F', 'K', 'a'};

    public static String generateId() {
        char[] id = new char[64];
        int systemTime = SessionManagerUtil.safeCasting(System.currentTimeMillis() / 1000L);
        JeusRandom jeusRandom = RandomPerJvm.getRandomPerJvm().getJeusRandom();
        for (int j = 0; j < 64; ++j) {
            id[j] = j % 16 == 0 ? SESSION_CHARS[(systemTime >> j / 2) % 64] : SESSION_CHARS[(jeusRandom.nextByte() + 128) % 64];
        }
        return new String(id);
    }

    public static void main(String[] args) {
        SecureSessionIdGenerator.generateId();
        long startT = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            SecureSessionIdGenerator.generateId();
        }
        long endT = System.currentTimeMillis();
        long gap = endT - startT;
        System.out.println("Total time gap = " + gap);
    }
}

