/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.inspector.xml;

import java.util.ArrayList;
import javax.enterprise.deploy.shared.ModuleType;
import javax.xml.transform.TransformerException;
import jeus.tool.builder.deploy.IDeployUnit;
import jeus.tool.builder.inspector.xml.EJBXMLInsp;
import jeus.tool.builder.inspector.xml.ModuleXMLInspector;
import jeus.tool.builder.inspector.xml.XMLInspector;
import jeus.tool.xmlui.util.XMLUtil;
import jeus.xml.util.IXPathAPI;
import jeus.xml.util.XPathAPIFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EJBModuleXMLInsp
extends ModuleXMLInspector {
    public static final String ENTERPRISE_BEANS = "enterprise-beans";
    public static final String SESSION = "session";
    public static final String ENTITY = "entity";
    public static final String MESSAGE_DRIVEN = "message-driven";
    public static final String BEANLIST = "beanlist";
    public static final String JEUS_BEAN = "jeus-bean";
    public static final String EJB_NAME = "ejb-name";
    public static final String SESSION_TYPE = "session-type";

    public EJBModuleXMLInsp(IDeployUnit deployUnit) {
        super(deployUnit, ModuleType.EJB, "META-INF/ejb-jar.xml");
    }

    public String getJ2eeConfigPath() {
        return "/ejb-jar";
    }

    public String getJ2eeConfigUIName() {
        return "ejb-jar";
    }

    public String getJeusConfigPath() {
        return "/jeus-ejb-dd";
    }

    public String getJeusConfigUIName() {
        return "jeus-ejb-dd";
    }

    public XMLInspector[] getChildren() {
        if (!this.dirty()) {
            return this.children;
        }
        if (this.j2eeElement == null) {
            return new XMLInspector[0];
        }
        ArrayList<EJBXMLInsp> result = new ArrayList<EJBXMLInsp>();
        String prefix = this.j2eeElement.getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        String xpath = "./" + prefix + ":enterprise-beans/*";
        IXPathAPI xpathAPI = XPathAPIFactory.createXPathAPI();
        try {
            NodeList nodeList = xpathAPI.selectNodeList(this.j2eeElement, xpath);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                Element ejbNode = XMLUtil.getFirstElement((Element)node, EJB_NAME);
                String ejbName = XMLUtil.getValue(ejbNode);
                EJBXMLInsp ejbInsp = null;
                if (node.getLocalName().equals(SESSION)) {
                    Element sessionType = XMLUtil.getFirstElement((Element)node, SESSION_TYPE);
                    String type = XMLUtil.getValue(sessionType);
                    ejbInsp = new EJBXMLInsp(this, type + "SessionBean", ejbName, new String[][]{{"ejb-jar", "/ejb-jar/enterprise-beans/$enterprise-beans$/session"}, {"jeus-ejb-dd", "/jeus-ejb-dd/beanlist/jeus-bean"}});
                } else {
                    ejbInsp = node.getLocalName().equals(ENTITY) ? new EJBXMLInsp(this, "EntityBean", ejbName, new String[][]{{"ejb-jar", "/ejb-jar/enterprise-beans/$enterprise-beans$/entity"}, {"jeus-ejb-dd", "/jeus-ejb-dd/beanlist/jeus-bean"}}) : new EJBXMLInsp(this, "MessageDrivenBean", ejbName, new String[][]{{"ejb-jar", "/ejb-jar/enterprise-beans/$enterprise-beans$/message-driven"}, {"jeus-ejb-dd", "/jeus-ejb-dd/beanlist/jeus-bean"}});
                }
                result.add(ejbInsp);
            }
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        this.children = result.toArray(new XMLInspector[result.size()]);
        this.dirty = false;
        return this.children;
    }

    public String getType() {
        return "EJBModule";
    }

    public String getUniqueId() {
        return "<EJBModule[name='" + this.getName() + "']>";
    }
}

