/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.resource;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import jeus.tool.builder.WIOBuilderException;

public class MsgRscManager {
    private static final String propertisStrings = "jeus.tool.builder.resource.LocalStrings";
    private static final String[] supportLanguages = new String[]{"english", "chinese", "japanese", "korea"};
    private static final String EMPTY_STRING = "";
    private static final int LANG_EN = 0;
    private static final int LANG_CH = 1;
    private static final int LANG_JA = 2;
    private static final int LANG_KO = 3;
    public static String m_language = supportLanguages[0];
    public static Locale m_locale;
    public static ResourceBundle resource;

    private MsgRscManager() {
    }

    public static void initResourceManager() throws WIOBuilderException {
        MsgRscManager.initResourceManager(m_language);
    }

    public static void initResourceManager(String language) throws WIOBuilderException {
        if (!MsgRscManager.isSupportLanguages(language)) {
            throw new WIOBuilderException("Not support language : " + language);
        }
        try {
            switch (MsgRscManager.getSupportLanguageNumber(language)) {
                case 0: {
                    m_locale = Locale.ENGLISH;
                    break;
                }
                case 1: {
                    m_locale = Locale.CHINESE;
                    break;
                }
                case 2: {
                    m_locale = Locale.JAPANESE;
                    break;
                }
                case 3: {
                    m_locale = Locale.KOREAN;
                    break;
                }
                default: {
                    throw new WIOBuilderException("Not support language : " + language);
                }
            }
            resource = ResourceBundle.getBundle(propertisStrings, m_locale);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WIOBuilderException(e);
        }
    }

    public static void setLanguage(String language) throws WIOBuilderException {
        if (!MsgRscManager.isSupportLanguages(language)) {
            throw new WIOBuilderException("Not support language : " + language);
        }
        if (!m_language.equals(language)) {
            m_language = language;
            MsgRscManager.initResourceManager();
        }
    }

    public static String getLanguage() {
        return m_language;
    }

    public static Locale getLocale() {
        return m_locale;
    }

    private static boolean isSupportLanguages(String language) {
        if (language == null || language.equalsIgnoreCase(EMPTY_STRING)) {
            return false;
        }
        for (int i = 0; i < supportLanguages.length; ++i) {
            if (!language.equals(supportLanguages[i])) continue;
            return true;
        }
        return false;
    }

    private static int getSupportLanguageNumber(String language) {
        if (language == null || language.equalsIgnoreCase(EMPTY_STRING)) {
            return -1;
        }
        for (int i = 0; i < supportLanguages.length; ++i) {
            if (!language.equals(supportLanguages[i])) continue;
            return i;
        }
        return -1;
    }

    public static String getString(String key) {
        if (resource == null) {
            try {
                MsgRscManager.initResourceManager();
            }
            catch (WIOBuilderException e) {
                e.printStackTrace();
            }
        }
        String value = resource.getString(key);
        return value;
    }

    public static void printMsgResource() {
        Enumeration<String> e = resource.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            System.out.println("[" + key + " / " + MsgRscManager.getString(key) + "]");
        }
    }

    private static String AsciiToKorean(String str) {
        String value = null;
        try {
            value = new String(str.getBytes("8859_1"), "ksc5601");
        }
        catch (UnsupportedEncodingException ue) {
            ue.printStackTrace();
        }
        return value;
    }
}

