/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.tree;

import java.awt.Component;
import java.io.File;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jeus.tool.builder.tree.FileTreeNode;

public class FileSystemTree
extends JScrollPane
implements TreeExpansionListener,
TreeWillExpandListener,
TreeSelectionListener {
    private static final String ROOT_NODE_NAME = "My Computer";
    public static String ROOT_NAME = "system";
    private static FileSystemTree fileSystemTree = null;
    private static Object syncObj = new Object();
    private JTree fileTree = new JTree();
    private FileTreeNode rootNode = new FileTreeNode(null, null);
    private DefaultTreeModel treeModel;
    private File selectedFile;

    private FileSystemTree() {
        this.rootNode.setName(ROOT_NODE_NAME);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.fileTree.setModel(this.treeModel);
        this.fileTree.addTreeWillExpandListener(this);
        this.fileTree.addTreeSelectionListener(this);
        File[] topFiles = File.listRoots();
        for (int i = 0; i < topFiles.length; ++i) {
            FileTreeNode fileTreeNode = new FileTreeNode(topFiles[i], this.rootNode);
        }
        this.fileTree.updateUI();
        this.fileTree.repaint();
        this.getViewport().add((Component)this.fileTree, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileSystemTree getInstance() {
        if (fileSystemTree == null) {
            Object object = syncObj;
            synchronized (object) {
                if (fileSystemTree == null) {
                    fileSystemTree = new FileSystemTree();
                }
            }
        }
        return fileSystemTree;
    }

    public void treeExpand(TreeExpansionEvent event) {
        try {
            FileTreeNode fnode = this.treeGenerate(event.getPath());
            if (fnode == null) {
                return;
            }
            TreePath path = event.getPath();
            FileTreeNode node = (FileTreeNode)path.getLastPathComponent();
            ((DefaultTreeModel)this.fileTree.getModel()).nodeStructureChanged(node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void treeClicked(TreePath path) {
        if (path == null) {
            return;
        }
        FileTreeNode node = (FileTreeNode)path.getLastPathComponent();
        this.selectedFile = node.getFile();
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public FileTreeNode treeGenerate(TreePath path) {
        if (path == null) {
            return null;
        }
        FileTreeNode node = (FileTreeNode)path.getLastPathComponent();
        this.makeChildrenNode(node);
        return node;
    }

    public void makeChildrenNode(FileTreeNode selectedNode) {
        if (selectedNode.getChildCount() > 0) {
            return;
        }
        File myFile = selectedNode.getFile();
        if (myFile != null) {
            File[] childList = myFile.listFiles();
            for (int i = 0; i < childList.length; ++i) {
                if (!childList[i].isDirectory()) continue;
                new FileTreeNode(childList[i], selectedNode);
            }
        }
    }

    public void treeExpanded(TreeExpansionEvent event) {
        this.treeExpand(event);
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void treeWillExpand(TreeExpansionEvent event) {
        this.treeExpand(event);
    }

    public void treeWillCollapse(TreeExpansionEvent event) {
    }

    public void valueChanged(TreeSelectionEvent event) {
        TreePath selPath = event.getPath();
        this.treeClicked(selPath);
    }
}

